/*
 * MultiMail offline mail reader
 * packet list window

 Copyright (c) 1996 Kolossvary Tamas <thomas@vma.bme.hu>
 Copyright (c) 1998 William McBrine <wmcbrine@clark.net>

 Distributed under the GNU General Public License.
 For details, see the file COPYING in the parent directory. */

#include "interfac.h"

extern mmail		mm;
extern file_list	*packetList;
extern HelpWindow	helpwindow;

PacketListWindow::PacketListWindow()
{
	char tmp[512];

	packetList = new file_list(mm.resourceObject->get(PacketDir));

	if (!NumOfItems()) {
		sprintf(tmp, "No packets found.\n\n"
			"Please place any packets to be read in:\n%s",
			mm.resourceObject->get(PacketDir));
		fatalError(tmp);
	}
}

PacketListWindow::~PacketListWindow()
{
	delete packetList;
}

void PacketListWindow::MakeActive()
{
	oldPos = oldActive = -100;
	list_max_y = LINES - 19;
	list = new InfoWin(LINES - 16, 60, 10, COLS / 2 - 30, C_PBBACK);
	wattrset(list->win, C_PHEADTEXT);
	mvwaddstr(list->win, 1, 3, "Packet                Size    Date");
	helpwindow.packetlist();
	list->touch();
	Draw();
}

int PacketListWindow::NumOfItems()
{
	return packetList->getNoOfFiles();
}

void PacketListWindow::Delete()
{
	delete list;
	helpwindow.Delete();
}

void PacketListWindow::oneLine(int i)
{
	int j;
	char tmp1[13], tmpdate[30];
	const char *tmp2;
	time_t tmpt;

	packetList->gotoFile(position + i);

	strcpy(tmp1, "            ");
	tmp2 = packetList->getName();
	j = 0;
	while ((*tmp2 != '.') && (j < 8))
		tmp1[j++] = *tmp2++;
	strncpy(&tmp1[8], tmp2, 4);

	tmpt = packetList->getDate();
	strcpy(tmpdate, ctime(&tmpt));
	tmpdate[strlen(tmpdate) - 1] = '\0';

	wattrset(list->info, C_PLINES);
	if (position + i == active)
		wstandout(list->info);

	mvwprintw(list->info, i, 0, "  %s%16u  %s  ", tmp1,
		(unsigned) packetList->getSize(), tmpdate);
}

void PacketListWindow::Select()
{
	packetList->gotoFile(active);
}

void PacketListWindow::ReList()
{
	if (position > 1) {
		if (active > 1)
			active--;
		position--;
	}
	delete packetList;
	packetList = new file_list(mm.resourceObject->get(PacketDir));
	oldPos = oldActive = -100;
	Draw();
}
