; ramtest -- a memory test program
; Copyright (C) 1999  Stefan Ziegenbalg
; 
; This program is free software; you can redistribute it and/or  
; modify it under the terms of the GNU General Public License as 
; published by the Free Software Foundation; either version 2 of 
; the License, or (at your option) any later version.
;  
; This software is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
; General Public License for more details.
;  
; You should have received a copy of the GNU General Public
; License along with this program; if not, write to the 
; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
; Boston, MA  02111-1307, USA.


;
; undefined jump behaviour in masm:  m...p in labels
;
writemes macro mes
         pusha
         mov dx,offset mes
         mov ah,9
         int 21h
         popa
         endm


str2eax proc s:word
; convert decimal number (stotred in stringz [str]) to a number in eax
        push ebx
        push ecx
        push edx
        push si

         xor eax,eax
         xor ebx,ebx
         mov ecx,10
         mov si,s
lm1:     mov bl,ds:[si]
         cmp bl,0
         jz mexit
         sub bl,'0'
         jc errm
         cmp bl,9
         jg errm
         mul ecx
         neg edx
         jc errm
         add eax,ebx
         inc si
         jmp lm1

mexit:  pop si
        pop edx
        pop ecx
        pop ebx
         ret
mesm     db 'unable to convert string to a number',13,10,'$'
errm:    writemes mesm
         mov eax,-1
         jmp mexit
str2eax endp
;********************************************************************
dw2hexstr proc num:dword, s:word
;convert dw to stringz
       push si
       push eax
       push bx
       push cx
       push edx

        mov si,s
        mov edx,num
        mov bx,offset hextab
        mov cx,8
l1n:    rol edx,4
        mov eax,edx
        and eax,15
        xlat
        mov ds:[si],al
        inc si
        loop l1n
;        mov byte ptr ds:[si],0

       pop edx
       pop cx
       pop bx
       pop eax
       pop si
        ret
hextab db '0123456789abcdef'
dw2hexstr endp
;********************************************************************
b2binstr proc num:byte, s:word
;convert b to stringz
       push si
       push ax
       push cx

        mov si,s
        mov al,num
        mov cx,8
lo1:    shl al,1
        jc jo1
        mov byte ptr ds:[si],'0'
        jmp jo2
jo1:    mov byte ptr ds:[si],'1'
jo2:    inc si
        loop lo1
;        mov byte ptr ds:[si],0

exit:  pop cx
       pop ax
       pop si
        ret
b2binstr endp
;********************************************************************
w2decstr proc num:word, s:word, wi:word
;convert w to stringz
       push si
       push di
       push ax
       push cx
       push dx
       push es

        mov cx,wi
        mov si,s
lp3:    mov byte ptr ds:[si],' '
        inc si
        loop lp3

        mov si,s
        mov cx,10
        mov ax,num
lp1:    xor dx,dx
        div cx
        add dl,'0'
        mov ds:[si],dl
        inc si
        cmp ax,0
        jnz lp1

        mov si,s
        add si,wi
        dec si
        mov di,s
lp2:    mov al,byte ptr ds:[di]
        mov ah,byte ptr ds:[si]
        mov byte ptr ds:[si],al
        mov byte ptr ds:[di],ah
        inc di
        dec si
        cmp di,si
        jc lp2

exit:  pop es
       pop dx
       pop cx
       pop ax
       pop di
       pop si
        ret
w2decstr endp
