; ramtest -- a memory test program
; Copyright (C) 1999  Stefan Ziegenbalg
; 
; This program is free software; you can redistribute it and/or  
; modify it under the terms of the GNU General Public License as 
; published by the Free Software Foundation; either version 2 of 
; the License, or (at your option) any later version.
;  
; This software is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
; General Public License for more details.
;  
; You should have received a copy of the GNU General Public
; License along with this program; if not, write to the 
; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
; Boston, MA  02111-1307, USA.

.model tiny,pascal
.486P

constpatt equ 0  ; use constant patterns
emmerr    equ 0  ; emulate errors

;********************************************************************
;************************************************ MACROS ************
;********************************************************************
writemestofile macro mes
local l1,j1
         pusha
         mov dx,offset mes
         mov bx,dx
         xor cx,cx
l1:      cmp byte ptr ds:[bx],'$'
         jz j1
         inc bx
         inc cx
         jmp l1
j1:      mov bx,fhand
         mov ah,40h
         intf 21h
         jc err3
         popa
         endm

faterror macro mes
         writemes mes
         call done_intredirect
         mov ax,4c01h
         int 21h
         endm

warnerror macro mes
         writemes mes
         call done_intredirect
         mov ax,4c00h
         int 21h
         endm

tickwait macro
local l1
        push eax
         mov eax,dword ptr es:[46ch]
l1:      cmp dword ptr es:[46ch],eax
         jz l1
        pop eax
         endm

testaccess macro
local l1,j1,j2
         tickwait
         mov ebx,es:[46ch]
         xor esi,esi
         xor ecx,ecx
l1:
for i,<0,1,2,3>
 for j,<0,1,2,3,4,5,6,7>
         mov eax,gs:[esi+j*4+i*32]
  endm
 endm
         add esi,128
         cmp esi,edx
         jc j1
         xor esi,esi
j1:      test si,1fffh
         jnz l1
         inc ecx
         mov eax,es:[46ch]
         sub eax,ebx
         jnc j2
         add eax,1572480  ; midnight?
j2:      cmp eax,91
         jc l1
         shr ecx,6
         endm

;************************************************ testmemdd *********
testmemdd macro ofs
local j1,j2,j3
; test dd at gs:[esi+ofs*4]
         random
if emmerr
 ife ofs
         test esi,03fffffh             ; for testing, cause w error every 4MB
         jnz j1
         ror eax,1
j1:
 endif
endif
         mov edx,eax
         mov ebx,eax
if emmerr
 if ofs eq 1
         test esi,03fffffh             ; for testing, cause r error every 4MB
         jnz j1
         ror ebx,1
j1:
 endif
endif
         xor eax,dword ptr gs:[esi+ofs*4]
         xor edx,dword ptr gs:[esi+ofs*4]
         mov ebp,eax
         xor ebx,dword ptr gs:[esi+ofs*4]
         or eax,edx
         or eax,ebx
         neg eax
         jz j3
        push esi
         add esi,ofs*4
         call memerror
        pop esi
j3:
        endm
;************************************************************* random
ife constpatt

random macro
         add ecx,2139999977
         mov ax,cx
         xchg cl,ch
         ror ecx,16
         xor cx,ax
         mov eax,ecx
         endm

randomr macro
         ror ecx,16
         xchg cl,ch
         mov ax,cx
         ror ecx,16
         xor cx,ax
         ror ecx,16
         sub ecx,2139999977
         mov eax,ecx
         endm
else

random macro
         mov eax,0aaaaaaaah
         endm

randomr equ random
endif

;************************************************************* testmemb

testmemb macro
local j0,j1,j2,j3,j4
         cmp al,0
         jnz j0
         cmp dl,0
         jnz j0
         cmp bl,0
         jz j3
j0:      invoke dw2hexstr, esi, offset nmes2
         invoke b2binstr, al, offset nmes3
         invoke b2binstr, dl, offset nmes4
         invoke b2binstr, bl, offset nmes5
         cmp cache,0
         jz j1
         writemes nmes1a
         writemestofile nmes1a
         jmp j2
j1:      cmp al,dl
         jnz j4
         cmp al,bl
         jnz j4
         writemes nmes1b
         writemestofile nmes1b
         jmp j2
j4:      writemes nmes1c
         writemestofile nmes1c
j2:      writemes nmes2
         writemestofile nmes2
j3:
         endm

;********************************************************************
;********************************************************************
;********************************************************************
.code
         .startup
         jmp start
         db 1,0

include numstr.inc
include xms.inc
include promode.inc

;********************************************************************
;************************************************ DATA **************
;********************************************************************

usage    db 13,10
         db 'Usage: ',13,10
         db ' ramtest <start> <stop> [report file [outer loop [inner loop [blocksize]]]]',13,10
         db '   start        where to start im MB',13,10
         db '   stop         where to stop MB (last byte tested is stop*1M-1)',13,10
         db '   report file  there errors are reported',13,10
         db '   outer loop   number of outer loops (see below)',13,10
         db '   inner loop   number of inner loops (see below)',13,10
         db '   blocksize    size of block tested in inner loop (see below)',13,10
         db 13,10
         db 'Example:',13,10
         db '   ramtest 11MB 128MB null 16 16 4',13,10
         db '       -test the memory from 11MB to 128MB in 4MB blocks',13,10
         db '       -16 outer loops, 16 inner loops',13,10
         db 13,10
         db 'default values:',13,10
         db '   report file  nul',13,10
         db '   outer loop   4',13,10
         db '   inner loop   2',13,10
         db '   blocksize    stop-start',13,10
         db 13,10
         db 'Warning: ramtest do not run with emm386 or in vitual mode!',13,10
         db 13,10
         db 'Warning: This program destroys the data in the testet segments.',13,10
         db '         Find out how much memory is used before running it!',13,10
         db '         Be carfully with smartdrv or other disk cache programs!',13,10
         db '         Its save to disable it.',13,10
         db 13,10
         db 'Hint: You should disable the memory caches before use.',13,10
         db '      Or set block size to stop-start',13,10
         db 13,10
         db 'How it works:',13,10
         db 13,10
         db '  (in something like pascal)',13,10
         db 13,10
         db ' procedure test(a);',13,10
         db '  begin',13,10
         db '  b:=random2;',13,10
         db '  c1:=memory[a] xor b;',13,10
         db '  c2:=memory[a] xor b;',13,10
         db '  c3:=memory[a] xor b;',13,10
         db '  if c1<>c2 or c1<>c3 then',13,10
         db "         write('memory error (r/(w)) at', a, '(xor: ', c1, c2,... )",13,10
         db '                        // means read error and maybe write error',13,10
         db '     else',13,10
         db '     if c1<>b then',13,10
         db "         write('memory error (w) at', a, '(xor: ', c1, c2, ...);",13,10
         db '                        // means write error',13,10
         db '  // detection whether (w) / (r/(w)) works only if cache(s) is/are disabled',13,10
         db '  end;',13,10
         db 13,10
         db ' begin',13,10
         db ' randomize1(0);                     // 2 independend random',13,10
         db ' randomize2(0);                     // number generators',13,10
         db ' for i:=1 to outer loop do',13,10
         db '  begin',13,10
         db '  bt:=start;',13,10
         db '  repeat',13,10
         db '   et:=bt+blocksize;',13,10
         db '   if et>stop then et:=stop;',13,10
         db 13,10
         db '   for j:=1 to inner loop do               // "up test"',13,10
         db '    begin',13,10
         db '    for k:=0 to blocksize*1M-1 do',13,10
         db '     memory[et*1M+k]:=random1;',13,10
         db '    for k:=0 to blocksize*1M-1 do',13,10
         db '     test(et*1M+k);',13,10
         db '    end;',13,10
         db 13,10
         db '   for j:=1 to inner loop do               // "down test"',13,10
         db '    begin',13,10
         db '    for k:=blocksize*1M-1 downto 0 do',13,10
         db '     memory[et*1M+k]:=random1;',13,10
         db '    for k:=blocksize*1M-1 downto 0 do',13,10
         db '     test(et*1M+k);',13,10
         db '    end;',13,10
         db 13,10
         db '   for j:=1 to inner loop do               // "up/down test"',13,10
         db '    begin',13,10
         db '    for k:=0 to blocksize*1M-1 do',13,10
         db '     memory[et*1M+k]:=random1;',13,10
         db '    for k:=blocksize*1M-1 downto 0 do',13,10
         db '     test(et*1M+k);',13,10
         db '    end;',13,10
         db 13,10
         db '   for j:=1 to inner loop do               // "down/up test"',13,10
         db '    begin',13,10
         db '    for k:=blocksize*1M-1 downto 0 do',13,10
         db '     memory[et*1M+k]:=random1;',13,10
         db '    for k:=0 to blocksize*1M-1 do',13,10
         db '     test(et*1M+k);',13,10
         db '    end;',13,10
         db 13,10
         db '   bt:=et+1;',13,10
         db '   until bt>stop;',13,10
         db '  end.',13,10
         db 13,10
         db 13,10
         db ' Use Esc to abort at every time.',13,10
         db 13,10
         db ' !!!!! Use this programm at the risk of your own !!!!!',13,10
         db 13,10
         db ' spelling mistakes, bugs or ideas: stefan.ziegenbalg@mailbox.tu-dresden.de',13,10
         db ' www: http://www.simg.de',13,10
         db 13,10,'$'

mmes1    db '"up testing" '
mmes2    db 8 dup('0')
         db 13,10,'$'

rmes1    db '"down testing" '
rmes2    db 8 dup('0')
         db 13,10,'$'

vmes1    db '"up/down testing" '
vmes2    db 8 dup('0')
         db 13,10,'$'

wmes1    db '"down/up testing" '
wmes2    db 8 dup('0')
         db 13,10,'$'

nmes1a   db 'memory error at $'
nmes1b   db 'memory error (w) at $'
nmes1c   db 'memory error (r/(w)) at $'
nmes2    db 8 dup('0'),'   (xor: '
nmes3    db 8 dup('0'),', '
nmes4    db 8 dup('0'),', '
nmes5    db 8 dup('0'),')',13,10,'$'

omes1    db 'outer loop'
omes2    db '    ',13,10,'$'

pmes1    db 'test performance: '
pmes2    db '   .  MB/s',13,10,'$'

qmes     db 'runnig in virtual mode, ramtest requires real mode',13,10,'$'

tmes1    db 'read performance in [start,stop): '
tmes2    db '   .  MB/s',13,10,'$'

smes1    db 'read performance in [start,start+8K): '
smes2    db '   .  MB/s',13,10,13,10,'$'

umes     db 'Warning: Cache(s) is probably enabled.',13,10,13,10,'$'

starts   dd 0
stops    dd 0
inl      dw 2
oul      dw 4
i        dw 0
j        dw 0
begint   dd 0
endt     dd 0
bs       dd 1024*1024*4

fdefault db 'nul',0
pof      dw fdefault
fhand    dw 0

gdt_start db 8 dup(0)
         dw 0       ; 0..15 segment size
          dw 0      ; 0..15 physical position
          db 0      ; 16..23 physical position
          db 92h
          db 0      ; bit 0..3: 16..19 segmet size; if bit 7 then *4K
          db 0      ; 24..31 physical position

time1     dd 0
cache     db 0

vrand1    dd 0
vrand2    dd 0

;********************************************************************
;************************************************ PROCEDURES ********
;********************************************************************

memerror:
         add esi,starts
         mov eax,ebp
         testmemb
         shr eax,8
         shr edx,8
         shr ebx,8
         inc esi
         testmemb
         shr eax,8
         shr edx,8
         shr ebx,8
         inc esi
         testmemb
         shr eax,8
         shr edx,8
         shr ebx,8
         inc esi
         testmemb
         ret

int9:   push ax
         in al,60h
         cmp al,1
        pop ax
         jnz int09
         call done_intredirect
         int 9h
         mov ax,4c00h
         int 21h

;********************************************************************
;***********************************************             ********
;***********************************************  MAIN PART  ********
;***********************************************             ********
;********************************************************************
start:   writemes usage

         mov eax,cr0
         test eax,1
         jz j5
         writemes qmes
         mov ax,4c00h
         int 21h

j5:      call init_intredirect
         call init_xms
         xor ax,ax                              ; int9 handler
         mov es,ax
         ints off
         mov es:[36],[int9]
         mov es:[38],cs
         ints on

;***                                             ; scan paramter line
nextarg macro    ; di <- begin of arg,  si <- first blank after arg
local l1,l2,j1
l1:      inc bx
         cmp byte ptr ds:[bx],0
         jz l1
         cmp byte ptr ds:[bx],32
         jz l1
         mov di,bx
         cmp bx,cx
         jnc j1
l2:      inc bx
         cmp byte ptr ds:[bx],0
         jz j1
         cmp byte ptr ds:[bx],32
         jz j1
         jmp l2
j1:      mov si,bx
         endm
;***

         mov bx,80h
         mov ch,0
         mov cl,cs:[80h]
         inc cx
         add cx,bx
         mov si,cx
         mov byte ptr ds:[si],0

         nextarg                                ; arg start
         cmp si,cx
         jg err1
         mov byte ptr ds:[si],0
         invoke str2eax, di
         cmp eax,-1
         jz err1
         shl eax,20
         mov starts,eax

         nextarg                                ; arg stop
         cmp si,cx
         jg err1
         mov byte ptr ds:[si],0
         invoke str2eax, di
         cmp eax,-1
         jz err1
         shl eax,20
         mov stops,eax
         sub eax,starts
         mov bs,eax

         nextarg                                ; arg report file
         cmp si,cx
         jg j2
         mov pof,di
         mov byte ptr ds:[si],0

         nextarg                                ; arg outer loop
         cmp si,cx
         jg j2
         mov byte ptr ds:[si],0
         invoke str2eax, di
         cmp eax,-1
         jz err1
         mov oul,ax
         cmp ax,0
         jz err7

         nextarg                                ; arg inner loop
         cmp si,cx
         jg j2
         mov byte ptr ds:[si],0
         invoke str2eax, di
         cmp eax,-1
         jz err1
         mov inl,ax
         cmp ax,0
         jz err7

         nextarg                        ; arg block size
         cmp si,cx
         jg j2
         mov byte ptr ds:[si],0
         invoke str2eax, di
         cmp eax,-1
         jz err1
         cmp ax,0
         jz err7
         shl eax,20
         mov bs,eax
j2:

         mov eax,stops                  ; stop < start
         cmp eax,starts
         jc err5

         cmp starts,2*1024*1024         ; overwrite used memory?
         jc err6
l21:     mov dx,hand
         mov ah,0eh
         call dword ptr cs:[xmsaddr]
         cmp ax,1
         jz j21
         cmp ax,0
         jnz err4
         cmp bl,0a2h  ; invalid handle
         jz j22
         jmp err4
j21:     cmp dx,0
         jz j22
         xor ecx,ecx
         mov cx,dx
         shl ecx,10
         mov dx,hand
         mov ah,0ch
         call dword ptr cs:[xmsaddr]
         cmp ax,1
         jz j23
         cmp ax,1
         jnz err4
         cmp bl,0a2h  ; invalid handle
         jz j22
         cmp bl,0ach  ; block lock count overflowed
         jz j22
         cmp bl,0adh  ; lock failed
         jz j22
         jmp err4
j23:     mov ax,dx
         shl eax,16
         mov ax,bx
        push eax
         mov ah,0dh
         mov dx,hand
         call dword ptr cs:[xmsaddr]
         cmp ax,1
         jnz err4
        pop eax
         add ecx,eax
         cmp starts,ecx
         jnc j22
         cmp stops,eax
         jg err6
j22:     inc hand
         jnz l21

         mov ah,3ch                     ; create report file
         mov cx,0
         mov dx,pof
         intf 21h
         jc err2
         mov fhand,ax

         mov eax,starts                 ; set gdt
         mov word ptr ds:[gdt_start+8+2],ax
         shr eax,16
         mov ds:[gdt_start+8+4],al
         mov ds:[gdt_start+8+7],ah
         mov eax,stops
         sub eax,starts
         shr eax,12
         mov word ptr ds:[gdt_start+8],ax
         shr eax,16
         or al,128
         mov ds:[gdt_start+8+6],al

         set_gdt 2,gdt_start            ; promode
         init_promode gs

         mov eax,stops
         sub eax,starts
         mov stops,eax


         mov edx,stops                  ; test cache
         testaccess
        push ecx
         invoke w2decstr, cx, offset tmes2, 4
         mov al,byte ptr [tmes2+3]
         mov byte ptr [tmes2+3],'.'
         mov byte ptr [tmes2+4],al
         writemes tmes1
         mov edx,8192
         testaccess
         invoke w2decstr, cx, offset smes2, 4
         mov al,byte ptr [smes2+3]
         mov byte ptr [smes2+3],'.'
         mov byte ptr [smes2+4],al
         writemes smes1
        pop ebx
         mov eax,ecx
         sar ecx,3
         sub eax,ecx
         cmp eax,ebx
         jc j6
         writemes umes
         mov cache,1
j6:


         tickwait                       ; get time
         mov eax,dword ptr es:[46ch]
         mov time1,eax

                                        ; memory test
l14:     inc i                          ; outer loop
         invoke w2decstr, i, offset omes2,4
         writemes omes1

         xor esi,esi                    ; middle loop ("up test")
j11:     mov eax,starts
         add eax,esi
         invoke dw2hexstr, eax,offset mmes2
         writemes mmes1
         mov edi,esi
         add edi,bs
         cmp edi,stops
         jc j10
         mov edi,stops
j10:     mov ax,inl
         mov j,ax
l13:    push esi                        ; inner loop ("up test")
         mov ecx,vrand1
l10:     random
         mov dword ptr gs:[esi],eax
         random
         mov dword ptr gs:[esi+4],eax
         random     ; it looks silly but its faster
         mov dword ptr gs:[esi+8],eax
         random
         mov dword ptr gs:[esi+12],eax
         add esi,16
         cmp esi,edi
         jc l10
         mov vrand1,ecx
        pop esi
        push esi
         mov ecx,vrand2
l12:     testmemdd 0
         testmemdd 1
         testmemdd 2
         testmemdd 3
         add esi,16
         cmp esi,edi
         jc l12
         mov vrand2,ecx
        pop esi
         dec j
         jnz l13                        ; end inner loop ("up test")

         mov esi,edi
         cmp esi,stops
         jc j11                         ; end middle loop ("up test")


         mov esi,stops                  ; middle loop ("down test")
j31:     mov eax,starts
         sub eax,4
         add eax,esi
         invoke dw2hexstr, eax,offset rmes2
         writemes rmes1
         mov edi,esi
         sub edi,bs
         jnc j30
         xor edi,edi
j30:     mov ax,inl
         mov j,ax
l33:    push esi                        ; inner loop ("down test")
         mov ecx,vrand1
l30:     sub esi,16
         random
         mov dword ptr gs:[esi+12],eax
         random     ; it looks silly but its faster
         mov dword ptr gs:[esi+8],eax
         random
         mov dword ptr gs:[esi+4],eax
         random
         mov dword ptr gs:[esi],eax
         cmp edi,esi
         jc l30
         mov vrand1,ecx
        pop esi
        push esi
         mov ecx,vrand2
l32:     sub esi,16
         testmemdd 3
         testmemdd 2
         testmemdd 1
         testmemdd 0
         cmp edi,esi
         jc l32
         mov vrand2,ecx
        pop esi
         dec j
         jnz l33                        ; end inner loop ("down test")

         mov esi,edi
         cmp esi,0
         jnz j31                        ; end middle loop ("down test")


         xor esi,esi                    ; middle loop ("up/down test")
         mov ecx,vrand1
         neg ecx
j41:     mov eax,starts
         add eax,esi
         invoke dw2hexstr, eax,offset vmes2
         writemes vmes1
         mov edi,esi
         add edi,bs
         cmp edi,stops
         jc j40
         mov edi,stops
j40:     mov ax,inl
         mov j,ax
l43:    push esi                        ; inner loop ("up/down test")
l40:     randomr
         mov dword ptr gs:[esi],eax
         randomr
         mov dword ptr gs:[esi+4],eax
         randomr    ; it looks silly but its faster
         mov dword ptr gs:[esi+8],eax
         randomr
         mov dword ptr gs:[esi+12],eax
         add esi,16
         cmp esi,edi
         jc l40
         randomr
        pop edi
        push esi
l42:     sub esi,16
         testmemdd 3
         testmemdd 2
         testmemdd 1
         testmemdd 0
         cmp edi,esi
         jc l42
         mov edi,esi
        pop edi
         dec j
         jnz l43                        ; end inner loop ("up/down test")

         mov esi,edi
         cmp esi,stops
         jc j41                         ; end middle loop ("up/down test")


         mov esi,stops                  ; middle loop ("down/up test")
j51:     mov eax,starts
         sub eax,4
         add eax,esi
         invoke dw2hexstr, eax,offset wmes2
         writemes wmes1
         mov edi,esi
         sub edi,bs
         jnc j50
         xor edi,edi
j50:     mov ax,inl
         mov j,ax
l53:    push esi                        ; inner loop ("down/up test")
l50:     sub esi,16
         randomr
         mov dword ptr gs:[esi+12],eax
         randomr     ; it looks silly but its faster
         mov dword ptr gs:[esi+8],eax
         randomr
         mov dword ptr gs:[esi+4],eax
         randomr
         mov dword ptr gs:[esi],eax
         cmp edi,esi
         jc l50
         randomr
        pop edi
        push esi
l52:     testmemdd 0
         testmemdd 1
         testmemdd 2
         testmemdd 3
         add esi,16
         cmp esi,edi
         jc l52
        pop edi
         dec j
         jnz l53                        ; end inner loop ("down/up test")

         mov esi,edi
         cmp esi,0
         jnz j51                        ; end middle loop ("down/up test")

         dec oul
         jnz l14                        ; end outer loop


         mov eax,91                     ; test performance
         xor ebx,ebx
         mov bx,inl
         mul ebx
         mov bx,i
         mul ebx
         mov ebx,stops
         shr ebx,15
         mul ebx
         mov ebx,dword ptr es:[46ch]
         sub ebx,time1
         jnc j3
         add ebx,1572480  ;midnight?
j3:      div ebx
         shr ebx,1
         cmp edx,ebx
         jc j4
         inc eax
j4:      invoke w2decstr, ax, offset pmes2, 4
         mov al,byte ptr [pmes2+3]
         mov byte ptr [pmes2+3],'.'
         mov byte ptr [pmes2+4],al
         writemes pmes1

         done_promode
         mov bx,fhand
         mov ah,3eh
         int 21h
         call done_intredirect
         mov ax,4c00h
         int 21h

err1:    faterror emes1
emes1    db 'illegal parameter list',13,10,'$'
err2:    faterror emes2
emes2    db 'unable to create file',13,10,'$'
err3:    done_promode
         faterror emes3
emes3    db 'cant write to file',13,10,'$'
err4:    faterror emes4
emes4    db 'XMS error',13,10,'$'
err5:    faterror emes5
emes5    db 'stop < start',13,10,'$'
err6:    writemes emes6
         call meminfo
         call done_intredirect
         mov ax,4c00h
         int 21h
emes6    db '[start,stop) include used memory',13,10
         db 'meminfo: ',13,10,13,10,'$'
err7:    warnerror emes7
emes7    db 'cant do anything',13,10,'$'
end
