#############################################################################
#
#                   Copyright (C) 1994 SciTech Software.
#                           All rights reserved.
#
# Descripton:   Makefile for the PMODE library sample programs.
#               MSDOS version for Watcom C/C++^32 and DOS4GW
#
# $Id: makefile.wat 1.1 1994/03/10 09:06:58 kjb Exp $
#
#############################################################################

CC              = wcl386            # Name of C compiler

!if $d(debug)
CC_DOPT         = -d2               # Turn on debugging for C compiler
!endif

CC_FLAGS        = -l=dos4g -zq -DDOS4GW $(CC_DOPT)

# Implicit rules to make the object files for the library...

.c.obj:
    $(CC) $(CC_FLAGS) -c {$< }

# Object files required by the library

all: memtest.exe biosptr.exe video.exe isvesa.exe alias.exe

memtest.exe: pmode.obj memtest.obj
    $(CC) $(CC_FLAGS) memtest.obj pmode.obj

biosptr.exe: pmode.obj biosptr.obj
    $(CC) $(CC_FLAGS) biosptr.obj pmode.obj

video.exe: pmode.obj video.obj
    $(CC) $(CC_FLAGS) video.obj pmode.obj

isvesa.exe: pmode.obj isvesa.obj
    $(CC) $(CC_FLAGS) isvesa.obj pmode.obj

alias.exe: pmode.obj alias.obj
    $(CC) $(CC_FLAGS) alias.obj pmode.obj

# Clean up directory removing all files not needed to make the library

clean:
    @del *.obj

realclean:  clean
    @del *.exe

