
These patches were provided by IBM.

With this patch, you should be able to get the IBM Logo package
(in the bright yellow box) to work on *ALL* of the PC and PS/2
computers.

There are two problems with Logo on VGA systems.
The first, and most obvious, has to do with getting into and out of
graphics mode.  This is because Logo improperly detects the presence
of the EGA/VGA card, such that it only works on EGA but not VGA.
Going into graphics mode on VGA results in a strange mode setting.
The second, and most deadly, occurs when leaving Logo and returning
to DOS using the '.DOS' command.  This bug is manifests itself on
80386 systems, and is due to some self-modifying code which the 80386
prefetch queue prevents the modification from being recognised.

To apply the patches using DEBUG:

(1) From DOS, type 'DEBUG LOGO.COM', assuming DEBUG is in your path
somewhere and LOGO.COM is in your current disk/subdirectory.

(2) Apply the VGA patch stating at offset C6B6.  Type  'E C6B6' and
DEBUG will show you the old byte value followed by a period - You type
in the new byte value followed by a space.  When all of the bytes have
been patched, press Enter to get the DEBUG prompt (a dash) back again.

 Old  -> New            Starting at offset C6B6 of LOGO.COM
 Value   Value          when loaded in under DEBUG.
 =====   =====

  B9  ->  50
  00  ->  B4
  C0  ->  12
  8E  ->  B3
  D9  ->  10
  81  ->  CD
  3E  ->  10
  00  ->  80
  00  ->  FB
  55  ->  10
  AA  ->  58
  75  ->  74

(3) Apply the 80386 patch starting at offset 7A4B, as in step 2.

 Old  -> New          Starting at offset 7A4B of LOGO.COM
 Value   Value        when loaded in under DEBUG.
 =====   =====

  2E  ->  E9
  A3  ->  00
  30  ->  00
  17  ->  90

(4) Write the patch file back out to disk.  Type 'W' and Enter.

(5) Quit out of DEBUG.  Type 'Q' and Enter.

You now have a version of Logo ready to run on your VGA system!

For those of you interested in Logo Learner, the VGA patch is required,
but the 80386 patch is not.  Follow the same steps as in the previous
append, but the patch area in step 2 starts at offset 88BA of the file
LEARNER.COM instead of offset C6B6 of LOGO.COM, but the old values
you'll find there, and the new values to be put there are exactly the
same.  And, you can skip the patch in step 3.

The patches above just allow CGA graphics to work on an IBM VGA
system.  Since VGA wasn't available when LOGO came out in 1983, the
display will still look like CGA.  Non-IBM VGA systems may display 
snow with this patch.

As for the 'snow', I've got another patch for the technically
inclined who are not faint at heart.  I haven't tested this
myself, but someone else did it successfully.
 
Logo 'knew' where in the ROM the fonts were, so they
hard-coded that info into the program.  Since BIOS did
not (at that time) give you an API to determine where
the font was, there was no better way to do it than to
hardcode the address F000:FA6E into your program to
find out what the lower 128 characters looked like.
Today's video BIOS does provide a way to find the font
table (often refered to as a "Character Table".)
Logo uses BIOS to put the characters up on the screen,
but when it scrolls, it erases the character based on
the font at F000:FA6E; so if the font BIOS is using is
different from the font at that spot in the ROM, then
the differences will be highlighted by extra dots
appearing on the screen.  

To fix it, you can patch Logo to use your font table
instead.  This means hard-coding your font table to
replace the hard-coded BIOS font table. The value
appears hard-coded in two places in LOGO.COM.  Try
this:  

First, determine the Segment:Offset of the Font Table
your card is using.  This requires creating a program
than uses function 11h of interupt 10h (INT 10h with
AH = 11h, AL=30h, and BL=3 returns the Segment:offset
in ES:BP).  

    Then get into DEBUG.
DEBUG LOGO.COM
    Look at the first section of code:
U F6A F71
    Then change the segment address at F6B from F000 to
    your segment address. 
E F6B   00.xx  F0.xx
    And change the offset address at F70 from FA6E to  
    your offset. 
E F70   6E.xx  FA.xx
    Now look at the second section of code:
U C406 C416
    Then change the segment address at C407 from F000  
  to you segment address. 
E C407  00.xx  F0.xx
    And change the offset address at C415 from FA6E to
    your offset. 
E C415   6E.xx  FA.xx

Remember: when typing in those addresses to enter the
low-order byte first.  

I have not tested this fix, since I don't have non-IBM
hardware to test it on. The IBM font shape is the same
on CGA and EGA. That's why this problem doesn't show up
on IBM hardware.

