 /**********************************************************
 *                                                         *
 *                 OBTAIN_SESSION_PROC                     *
 *                      (OBTSESS)                          *
 *                                                         *
 *  Handles the acqusition of a session for use by         *
 *  the conversation.                                      *
 *                                                         *
 * INPUT : indicator of ATTACH/NO_ATTACH, pointer to RCB.  *
 *                                                         *
 * OUTPUT: GET_SESSION is sent to RM.                      *
 *                                                         *
 *                                                         *
 * CopyRight 1995. Nicholas Poljakov all rights reserved.  *
 *                                                         *
 **********************************************************/
#include <stdio.h>
#include <state1.h>
#include <session.h>
#include <rcb.h>
#include <tcb.h>
#include <sparm.h>
#include <string.h>

int sk_r_wt(void *);
int SendBlock(void *, void *);
int setrc(void *, void *);
int sendhsf(void *);
int sendhs(void *);
int sendbm(void *, void *);
int sendat(void *);
int rtsend(void *);
unsigned long rmfmh5(void *, void *);
int recwait(void *);
int rcvru(void *, void *);
int rcvhs(void *, void *, void *, void *);
int ralloc(void *, void *);
int psrm(int, void *, void *);
int ps_conv(int, void *);
int proterr(void *, unsigned long);
int preptrcv(void *, void *);
int post_rcb(void *);
struct repass *postopen(void *);
int phsrec(void *);
int pfmh5(void *);
int opndst(void *);
int Lrf_handler(void *);
int get_sess(void *, void *);
int get_attr(void *);
int fsm_error(unsigned char, void *);
int fsm_conv(unsigned char, unsigned char, void *);
int flush (void *);
int dcp(void *);
int dealloc(void *);
int crtp(void *);
int conv(void *);
int chkparm(void *, void *);
int check_end(unsigned int, void *);
struct rqb *call_appl(void *);
int buffmng(unsigned char, void *, void *, void *, unsigned, unsigned char, unsigned);
unsigned long attltck(void *);
unsigned long attacheck(void *);
char *cgetmem(int, int);
int sendhsf(void *);
int opndst(void *);
int alloc_rcb(void *, void *);
int allocate(void *);
int clsdst(void *);

obtsess(r_ptr, p)
struct rcb *r_ptr;
unsigned char p;
{
    struct gets gs;
    struct sessa sa;
    unsigned int code;
    char p1;

#if OS_TYPE == 1
/*********  Trace facility **********/
unsigned int rtype;   /* type of record */
unsigned int pnum;    /* point number */
char pname[8];        /* name of module */
char *drec;       /* record for dump */
int  lenr;            /* record length */

rtype = INPROC;
strcpy(pname, "obtsess");
pnum = 1;
drec = NULL;
lenr = 0;
gtf(rtype, pname, pnum, drec, lenr);
/***********************************/
#endif

    gs.p_tcb = r_ptr->p_tcb;
    gs.p_rcb = r_ptr;
    code = GET_SESSION;
    psrm(code, &gs, &sa);

    switch (sa.rc) {
        case OK : break; /* We ommiting the security info. */
        case UNSUC_NO_RETRY :
              {
                p1 = ALLOC_FAIL_NO_RETRY;
                fsm_error(p1,r_ptr);
                return (-1);
              }
        case SYNC_LEVEL_NOT_SUPPORTED :
              {
                p1 = SYNC_LEVEL_NOT_SUPPORTED;
                fsm_error(p1,r_ptr);
                return (-2);
              }
    }
    return(0);
}

