/*-----------------------------------------------------------------------*
 * Greg Stevens                                                   6/24/93*
 *                              NNHEBBLN.C                               *
 *                                             [file 6 in a series of 6] *
 *                                                                       *
 * This file contains the functions for calculating the error and weight *
 * changes for the Hebb rule for unsupervised learning.  Defined         *
 * in this file are EPSILON, the weight change increment/coefficient,    *
 * and function that updates the weights [UpDateWeightandThresh()].  It  *
 * also contains code for a function called GetDerivs(), but this is to  *
 * be used in the function UpDateWeightsandDerivs(), not by a main       *
 * program.                                                              *
 *                                                                       *
 *-----------------------------------------------------------------------*/
#include "nnloadin.c"

#define EPSILON 0.01        /* constant incrementation for weight change */

/* Function Prototype */
NNETtype UpDateWeightandThresh( NNETtype oldn );

/* Function Definition */
NNETtype UpDateWeightandThresh( NNETtype oldn )
{
   NNETtype n;
   int u,v;
   int BIG = 0;

   n = oldn;

   for (u=0; (u<OUTPUT_LAYER_SIZE); ++u )
     {
       if (n.unit[1][u].state>0.0)                 /* increment weights of */
         {                                          /* connex. btw. any co- */
            for (v=0; (v<INPUT_LAYER_SIZE); ++v )   /* active nodes.        */
              {
                if (n.unit[0][v].state>0.0)
                  n.unit[1][u].weights[v] += EPSILON;
                if (n.unit[1][u].weights[v]>10.0)
                  BIG = 1;
              }
         }
     }

   if (BIG==1)                                      /* if weights grew too  */
     {                                              /* much, scale all down */
       for (u=0; (u<OUTPUT_LAYER_SIZE); ++u )
         {
            for (v=0; (v<INPUT_LAYER_SIZE); ++v )
              {
                 n.unit[1][u].weights[v] = n.unit[1][u].weights[v] / 2.0;
              }
         }
     }

   return( n );
}
