/*-----------------------------------------------------------------------*
 * Greg Stevens                                                  6/24/93 *
 *                               nnparams.c                              *
 *                                             [file 1 in a series of 6] *
 *                                                                       *
 *  This file contains constant definitions that define the parameters of*
 * a neural net with an input layer, an output layer, and zero or more   *
 * hidden layers.                                                        *
 *                                                                       *
 *-----------------------------------------------------------------------*/

#define INPUT_LAYER_SIZE   2          /* number of nodes in input layer  */
#define OUTPUT_LAYER_SIZE  1          /* number of nodes in output layer */
#define NUM_HIDDEN_LAYERS  1          /* number of hidden layers; MAX=10 */

#define HL_SIZE_1   2                 /*  These define the sizes of the  */
#define HL_SIZE_2   0                 /* hidden layers.  Make sure there */
#define HL_SIZE_3   0                 /* is a positive integer for each  */
#define HL_SIZE_4   0                 /* hidden layer that exists, i.e.  */
#define HL_SIZE_5   0                 /* make sure there are as many     */
#define HL_SIZE_6   0                 /* positive integers as there are  */
#define HL_SIZE_7   0                 /* hidden layers [as specified by  */
#define HL_SIZE_8   0                 /* NUM_HIDDEN_LAYERS],  and make   */
#define HL_SIZE_9   0                 /* sure the rest are set to 0.     */
#define HL_SIZE_10  0


/*-----------------------------------------------------------------------*/
/*  Constants defined below: MAXNODES, NUMLAYERS                         */
/*                                                                       */
/*-----------------------------------------------------------------------*/
/*++++++++++++++++++ NOTHING PAST HERE NEED BE MODIFIED++++++++++++++++++*/
/*-----------------------------------------------------------------------*/

/* defines total number of layers: NUMLAYERS  */
#define NUMLAYERS  (NUM_HIDDEN_LAYERS+2)

/* defines the number of nodes in the largest layer: MAXNODES  */
#define MAXNODES INPUT_LAYER_SIZE
#if (OUTPUT_LAYER_SIZE>MAXNODES)
	#define MAXNODES OUTPUT_LAYER_SIZE
#endif
#if (HL_SIZE_1>MAXNODES)
    #define MAXNODES HL_SIZE_1 
#endif
#if (HL_SIZE_2>MAXNODES)
    #define MAXNODES HL_SIZE_2 
#endif
#if (HL_SIZE_3>MAXNODES)
    #define MAXNODES HL_SIZE_3 
#endif
#if (HL_SIZE_4>MAXNODES)
    #define MAXNODES HL_SIZE_4 
#endif
#if (HL_SIZE_5>MAXNODES)
    #define MAXNODES HL_SIZE_5 
#endif
#if (HL_SIZE_6>MAXNODES)
    #define MAXNODES HL_SIZE_6 
#endif
#if (HL_SIZE_7>MAXNODES)
    #define MAXNODES HL_SIZE_7 
#endif
#if (HL_SIZE_8>MAXNODES)
    #define MAXNODES HL_SIZE_8 
#endif
#if (HL_SIZE_9>MAXNODES)
    #define MAXNODES HL_SIZE_9 
#endif
#if (HL_SIZE_10>MAXNODES)
    #define MAXNODES HL_SIZE_10
#endif

