/* debug.h - Debugging output macros */
/*   Rich Braun @ Kronos, Inc.  Waltham, MA */
/*   31 Jan 91 */

#ifndef _DEBUG_H
#define _DEBUG_H

#ifndef STDIO_H
#include <stdio.h>
#endif

#ifndef _TIME_T_DEFINED
#include <time.h>
#endif

typedef struct _dbgflags {
    unsigned rpctrace : 1,
    	     mountd   : 1,
	     nfserr   : 1,
	     nfsdebug : 1,
	     nfsdisp  : 1,
	     nfslookup: 1,
	     nfsread  : 1,
	     nfswrite : 1,
	     nfstime  : 1,
	     inode    : 1;
    };

extern struct _dbgflags __dbgflags__;
extern FILE   *__dbgfp__;
static char   __dbgbuf__ [200];

#ifndef DEBUG
#define DBGPRT0(FLAG,STR) ((void)0)
#define DBGPRT1(FLAG,STR,PARM1)	((void)0)
#define DBGPRT2(FLAG,STR,PARM1,PARM2) ((void)0)
#define DBGPRT3(FLAG,STR,PARM1,PARM2,PARM3) ((void)0)
#define DBGPRT4(FLAG,STR,PARM1,PARM2,PARM3,PARM4) ((void)0)
#else

/* Disable timestamped output for small-model compilation */
#define _TDBG 0

#if _TDBG
/*
 * Define DBGPRTx macros to print 0, 1, 2, 3, or 4 parameters following
 * the prefix time-DBG-flagname-string.
 */

static time_t __dbgnow__;
#define __DTIME_STAMP (FLAG, STR) \
	   if (__dbgflags__.nfstime) {\
		time (&__dbgnow__); \
		(void) sprintf (__dbgbuf__, "%8.8s-DBG-%s-%s\n", \
				ctime (&__dbgnow__)+11, #FLAG, STR); \
	   } else \
	        sprintf (__dbgbuf__, "DBG-%s-%s\n", #FLAG, STR)

#define DBGPRT0(FLAG,STR) \
	if (__dbgflags__.FLAG) { \
	   if (__dbgflags__.nfstime) {\
		time (&__dbgnow__); \
		(void) fprintf (__dbgfp__, "%8.8s-DBG-%s-%s\n", \
				ctime (&__dbgnow__)+11, #FLAG, STR); \
	   } else \
	      (void) fprintf (__dbgfp__, "DBG-%s-%s\n", #FLAG, STR); \
	}

#define DBGPRT1(FLAG,STR,PARM1) \
	if (__dbgflags__.FLAG) { \
	   __DTIME_STAMP(FLAG,STR);
	   (void) fprintf (__dbgfp__, __dbgbuf__, PARM1); \
	}

#define DBGPRT2(FLAG,STR,PARM1,PARM2) \
	if (__dbgflags__.FLAG) { \
	   __DTIME_STAMP(FLAG,STR);
	   (void) fprintf (__dbgfp__, __dbgbuf__, PARM1, PARM2); \
	}
	
#define DBGPRT3(FLAG,STR,PARM1,PARM2,PARM3) \
	if (__dbgflags__.FLAG) { \
	   __DTIME_STAMP(FLAG,STR);
	   (void) fprintf (__dbgfp__, __dbgbuf__, PARM1, PARM2, PARM3); \
	}

#define DBGPRT4(FLAG,STR,PARM1,PARM2,PARM3,PARM4) \
	if (__dbgflags__.FLAG) { \
	   __DTIME_STAMP(FLAG,STR); \
	   (void) fprintf (__dbgfp__, __dbgbuf__, PARM1, PARM2, PARM3,PARM4); \
	}
#else

/*
 * Define DBGPRTx macros to print 0, 1, 2, 3, or 4 parameters following
 * the prefix DBG-flagname-string.
 */
#define DBGPRT0(FLAG,STR) \
	if (__dbgflags__.FLAG) { \
	      (void) fprintf (__dbgfp__, "DBG-%s-%s\n", #FLAG, STR); \
	}

#define DBGPRT1(FLAG,STR,PARM1) \
	if (__dbgflags__.FLAG) { \
	   sprintf (__dbgbuf__, "DBG-%s-%s\n", #FLAG, STR); \
	   (void) fprintf (__dbgfp__, __dbgbuf__, PARM1); \
	}

#define DBGPRT2(FLAG,STR,PARM1,PARM2) \
	if (__dbgflags__.FLAG) { \
	   sprintf (__dbgbuf__, "DBG-%s-%s\n", #FLAG, STR); \
	   (void) fprintf (__dbgfp__, __dbgbuf__, PARM1, PARM2); \
	}
	
#define DBGPRT3(FLAG,STR,PARM1,PARM2,PARM3) \
	if (__dbgflags__.FLAG) { \
	   sprintf (__dbgbuf__, "DBG-%s-%s\n", #FLAG, STR); \
	   (void) fprintf (__dbgfp__, __dbgbuf__, PARM1, PARM2, PARM3); \
	}

#define DBGPRT4(FLAG,STR,PARM1,PARM2,PARM3,PARM4) \
	if (__dbgflags__.FLAG) { \
	   sprintf (__dbgbuf__, "DBG-%s-%s\n", #FLAG, STR); \
	   (void) fprintf (__dbgfp__, __dbgbuf__, PARM1, PARM2, PARM3,PARM4); \
	}
#endif /* _TDBG */
	
#endif /* DEBUG */
#endif /* _DEBUG_H */
