; assembler subroutine to read system's timer with microsecond-resolution
; PROTIMER.ASM                            (c) Jan-Erik Rosinowski 1989
;
; Publics : PROCEDURE INITTIMER         : prepares timer for its duty
;           PROCEDURE RESTORETIMER      : restore timer's original state
;           FUNCTION  READTIMER:LONGINT : the kernel-procedure

code    segment byte public
        assume     cs:code,ds:code
        public     readtimer,inittimer,restoretimer

counter =          0
corr    =          5
tport   =          40h
tctrl   =          tport+3
ictrl   =          20h

inittimer proc
        mov        al,34h
        jmp        short skip1
inittimer endp

restoretimer proc
        mov        al,36h
skip1:  out        tctrl,al
        mov        cx,2
itl:    mov        al,0
        out        tport,al
        loop       itl
        ret
restoretimer endp

readtimer proc
        push       bp
        mov        bp,sp
        push       ds                  ;we'll need dosseg
        cli                            ;disable all interrupts
        mov        al,00001010b        ;set ocw 3 to read interrupt-request..
        out        ictrl,al            ; ..register
        in         al,ictrl            ;read it
        mov        cl,al
        mov        al,counter shl 6    ;function latch timer
        out        tctrl,al            ;latch timer
        in         al,tport            ;read timer low
        mov        bl,al               ;into bl
        in         al,tport            ;read timer high
        mov        bh,al               ;into bh, bx=clicks mod 64k
        mov        ax,40h              ;switch to dosseg
        mov        ds,ax
        mov        dx,word ptr ds:[6ch];get clicks div 64k
        sti                            ;enable all interrupts
        not        bx                  ;we need ascending count
        test       cl,00000001b        ;timer requested int ?
        jz         exit                ;no
        cmp        bx,corr             ;interrupt while reading
        ja         exit                ;probably not
        inc        dx                  ;timer int disabled via cli
exit:   pop        ds                  ;back to original ds
        mov        ax,bx
        mov        [bp-4],ax           ;lsw
        mov        [bp-2],dx           ;msw
        mov        sp,bp
        pop        bp
        ret
readtimer endp
code    ends

        end
