***********************************************************************
* DEL.PRG                                                FoxPro 2.0
* Delete all files specified by a wildcard expression.
*
* Example: DO DEL WITH "c:\*.bak"
***********************************************************************
PROCEDURE DEL
PARAMETERS mWild
PRIVATE mPath, mFile

  mWild = FULLPATH(mWild)                 && Construct full path

  mPath = LEFT( mWild, RAT("\",mWild) )   && Extract path
  mFile = SYS( 2000, mWild )              && Find first matching file.
  DO WHILE ! EMPTY( mFile )               && Was a matching file found?
     ERASE ( mPath+mFile )                &&    Yes, delete it.
     mFile = SYS( 2000, mWild, 1)         &&    Find next matching file.
  ENDDO                                   && Repeat process.

RETURN
