PROGRAM EmptyDlg;
Uses WinTypes, WinProcs, WObjects;
{$R EMPTYDLG}
{$D Copyright (c) 1991 by Neil J. Rubenking}
CONST
  AppName : PChar = 'EMPTYDLG';
TYPE
  TMyApplication = object(TApplication)
    PROCEDURE InitMainWindow; virtual;
  END;

  PEmptyDialog = ^TEmptyDialog;
  TEmptyDialog = OBJECT(TDlgWindow)
    CONSTRUCTOR Init(AParent : PWindowsObject; AName : PChar);
    DESTRUCTOR Done; Virtual;
    PROCEDURE SetUpWindow; Virtual;
    FUNCTION GetClassName : PChar; Virtual;
    PROCEDURE GetWindowClass(var AWndClass: TWndClass); virtual;
  END;

{--------------------------------------------------}
{ TEmptyDialog's methods                            }
{--------------------------------------------------}
  CONSTRUCTOR TEmptyDialog.Init(AParent : PWindowsObject; AName : PChar);
  BEGIN TDlgWindow.Init(AParent, AName); END;

  PROCEDURE TEmptyDialog.SetUpWindow;
  BEGIN TDlgWindow.SetUpWindow; END;

  DESTRUCTOR TEmptyDialog.Done;
  BEGIN TDlgWindow.Done; END;

  FUNCTION TEmptyDialog.GetClassName;
  BEGIN GetClassName := AppName; END;

  PROCEDURE TEmptyDialog.GeTWindowClass(VAR AWndClass : TWndClass);
  BEGIN
    TDlgWindow.GetWindowClass(AWndClass);
    AWndClass.hIcon := LoadIcon(HInstance, AppName);
  END;

{--------------------------------------------------}
{ TMyApplication's method implementations:         }
{--------------------------------------------------}
  PROCEDURE TMyApplication.InitMainWindow;
  BEGIN MainWindow := New(PEmptyDialog, Init(NIL, AppName)); END;

{--------------------------------------------------}
{ Main program:                                    }
{--------------------------------------------------}
VAR MyApp: TMyApplication;
BEGIN
  MyApp.Init(AppName);
  MyApp.Run;
  MyApp.Done;
END.
