
// prready.c -  check printer and return TRUE if ready else FALSE 
#include<dos.h>  // required for prt_ready function   
#include<stdio.h>  // not needed for prt_ready function 
#include<stdlib.h>

unsigned char printer_status(int prt);

char *PrinterStatus[8] = // Printer Status Bits:
    {
    "Time Out",     // 0
    "",             // 1 - (Unused)
    "",             // 2 - (Unused)
    "I/O Error",    // 3
    "Selected",     // 4
    "Out of Paper", // 5
    "Acknowledged", // 6
    "Not Busy"      // 7
    };

void main(int argc, char **argv)
    {
    unsigned char status;
    int printerno,i;

    printerno = atoi(argv[1]);

    if((argc != 2) || (printerno < 1) || (printerno > 3))
        {
        printf("Usage: PRREADY <printernumber (1-3)>\n");
        exit(1);
        }

    status = printer_status(printerno);
    printf("Printer %d status: ",printerno);

    if(!(status & 0xf9))
        printf("not available");
    else
        {
        for( i = 0; i < 8; i++, status >>= 1)
            {
            if(i == 1)
                {
                status >>= 1;
                i++;
                continue;
                }
            if(status & 0x01)
                printf("%s ",PrinterStatus[i]);
            if(i == 7 && (!status))
                printf("Busy");
            }
        }
    }

    // prt should be 1, 2, or 3  depending on printer to be checked 
unsigned char printer_status(int prt)
    {
    union REGS regs;

    regs.h.ah = 2;  // request printer status 
    regs.x.dx = prt-1;  // printer (0-2) 
    int86(0x17, &regs, &regs);

    // if printer is ready status should be 0x90: Powered on, 
    //   Selected, Not Busy 
    return regs.h.ah;
    }

