// inifile.cpp RHS 8/1/91

#include<string.h>
#include<stdio.h>
#include<dos.h>
#include<stdlib.h>
#include"inifile.h"

IniFile::IniFile(char *ininame)
    {
    name = NULL;
    SetName(ininame);
    }

IniFile::IniFile(void)
    {
    name = NULL;
    }

void IniFile::SetName(char *ininame)
    {
    if(name)
        delete name;
    name = new char[strlen(ininame)+1];
    strcpy(name,ininame);
    }


int IniFile::AddLine(char *line, char *def)
    {
    INIFILELINE *I = new INIFILELINE;

    if(!I)
        return 1;

    I->line = strdup(line);
    I->value = strdup(def);
    return list.Add(I);
    }

int IniFile::AddLine(char *line, int def)
    {
    char temp[10];

    itoa(def,temp,10);
    return CallAddLine(line,temp);
    }

int IniFile::CallAddLine(char *line, char *def)
    {
    char *temp = new char[strlen(def)+1];
    strcpy(temp,def);
    int i = AddLine(line,temp);
    delete temp;
    return i;
    }

int IniFile::AddLine(char *line, long def)
    {
    char temp[18];

    ltoa(def,temp,10);
    return CallAddLine(line,temp);
    }

char *IniFile::GetLine(char *line)
    {
    return GetLine(line,NULL);
    }

char *IniFile::GetLine(char *line, char *def)
    {
    INIFILELINE *I;
    int i;

    for(i = 0; i < list.Num(); i++)
        {
        I = (INIFILELINE *)list[i];
        if(!stricmp(line,I->line))
            {
            if(!def)
                {
                char *temp = new char[strlen(I->value)+1];
                strcpy(temp,I->value);
                return temp;
                }
            else
                {
                strcpy(def,I->value);
                return def;
                }
            }
        }
    }

INIFILELINE *IniFile::FindLine(char *line)
    {
    int i;
    INIFILELINE *I;

    for(i = 0; i < list.Num(); i++)
        {
        I = (INIFILELINE *)list[i];
        if(!strcmpi(I->line,line))
            return I;
        }
    return NULL;
    }


char *rtrim(char *str)
    {
    char *p = strrchr(str,' ');

    if(!p)
        return str;
    while(*p == ' ' && p > str)
        p--;
    p++;
    *p = '\0';
    return str;
    }


int IniFile::Read(void)
    {
    FILE *fp = fopen(name,"rt");

    if(!fp && !strchr(name,'\\'))
        {
        char *temp = new char[strlen(name)+strlen(_argv[0])+1];
        strcpy(temp,_argv[0]);
        char *p = strrchr(temp,'\\');
        p++;
        strcpy(p,name);
        fp = fopen(temp,"rt");
        delete temp;
        if(!fp)
            return 1;
        }
    char buf[BUFSIZ];
    char *value,*p;
    INIFILELINE *I;

    while(fgets(buf,BUFSIZ,fp))
        {
        buf[strlen(buf)-1] = '\0';
        if(p = strchr(buf,';'))
            *p = '\0';
        rtrim(buf);
        if(!strlen(buf) || (!(value = strchr(buf,'='))) )
            continue;
        *value++ = '\0';

        if(I = FindLine(buf))
            {
            if(!I->value || strcmp(I->value,value))
                {
                if(I->value)
                    delete I->value;
                char *temp = new char[strlen(value)+1];
                strcpy(temp,value);
                I->value = temp;
                }
            }
        }
    fclose(fp);
    }


void IniFile::Dump(void)
    {
    int i;
    INIFILELINE *I;

    for(i = 0; i < list.Num(); i++)
        {
        list.Dump(i);
        I = (INIFILELINE *)list[i];
        printf("list[%d]: @ %p line=%s value=%s\n",i,I,I->line,I->value);
        }
    }


