// winapp.h RHS 1/13/91 rev. 12/16/91

#if !defined(WINAPP_H)
#define WINAPP_H

#include<windows.h>
#include<dos.h>
#include"winmsg.h"

extern char *szMDIClient;

typedef struct WinAppMsg
    {
    WORD        msg;
    WORD        wParam;
    LONG        lParam;
    LONG        msgRetVal;
    BOOL        userMsgUsed;
    } WINAPPMSG;

long far pascal WinAppWndProc(HWND hWnd, WORD msg, WORD wParam, LONG lParam);

const unsigned WINAPP_RESERVED = sizeof(void *);

/* WINAPPLICATION:
An object of this class is defined once for every application. It contains the
items passed to WinMain, as well as access functions for returning them. The
constructor initializes them.
*/
extern HANDLE _hInstance, _hPrev;
extern int _cmdShow;
extern unsigned int _psp, _pszCmdline;

class WinApplication    // Windows application class
    {
    static HANDLE ApphInstance;
    static HANDLE hPrevInstance;
    static LPSTR lpszCmdLine;
    static int nCmdShow;
public:
    WinApplication(void)
        {
        ApphInstance = _hInstance;
        hPrevInstance = _hPrev;
        lpszCmdLine = (LPSTR)MK_FP(_psp,_pszCmdline);
        nCmdShow = _cmdShow;
        }
    static HANDLE GetInstance(void)     { return ApphInstance;  }
    static HANDLE GetPrevInstance(void) { return hPrevInstance; }
    static LPSTR GetCmdLine(void)       { return lpszCmdLine;   }
    static int GetCmdShow(void)         { return nCmdShow;      }
    int Run(void);    // default message loop processing
    virtual BOOL UserMessageProcessing(MSG *msg)    
        {   
        msg = msg;  // turn off compiler warning
        return FALSE;   
        }
    virtual ~WinApplication(){}
    };

   
/* WINCLASS
*/
const NOSTYLE = 0;
const NOEXTRABYTES = 0;

/* defined in WINDOWS.H:
typedef struct tagWNDCLASS
  {
    WORD        style;
    LONG        (FAR PASCAL *lpfnWndProc)( HWND, WORD, WORD, LONG );
    int         cbClsExtra;
    int         cbWndExtra;
    HANDLE      hInstance;
    HICON       hIcon;
    HCURSOR     hCursor;
    HBRUSH      hbrBackground;
    LPSTR       lpszMenuName;
    LPSTR       lpszClassName;
  } WNDCLASS;
 */
 
class WinClass : public WNDCLASS
    {
    BOOL    class_registered;
public:
    WinClass(void);
    void ClassRegister(void);
    BOOL ClassRegistered(void);
    virtual ~WinClass(){}
    };

/* WINHANDLE
An object of this class is created with every instance of Window (below). It
contains data that controls Window creation handling, as well as the window
handle.
 */

class WinHandle
    {
    HWND hWnd;
    LPSTR classname;
    LPSTR windowname;
    DWORD winstyle;
    int upper_left_x;
    int upper_left_y;
    int winwidth;
    int winheight;
    HWND winParent;
    HMENU menu;
    HANDLE hInstance;
    LPSTR lpParam;

public:
    WinHandle(void);
    HWND GetHandle(void) { return hWnd; }
    BOOL Create(void);
    
    friend class Window;    // allow Window to modify members
    virtual ~WinHandle(){}
    };


/* WINDOW
*/
class Window : public WinApplication, WinClass
    {
private:
    WinHandle WHdl;
    int     current_display;
    int     previously_visible;

    void    Show(void)
        { previously_visible = ShowWindow(hWnd,current_display); }
    void SetClassWinXbytes(int xtrabytes)    
        { cbWndExtra = xtrabytes; }

protected:
    HWND hWnd;
    char    *classname;

public:
    Window(char *winname);
    void SethWnd(HWND h)        {   hWnd = h;   }
    virtual ~Window() {}
        // displays window and creates if not already created
    BOOL Display(void);
    BOOL Display(int display_style);
    BOOL ClassRegistered(void);
        // should call SetClassInstance and SetClassName if not called
    void Register(void);
    virtual BOOL Create(void);
    HWND GetHandle(void)        { return hWnd;                      }

    void Hide(void)             { Display(SW_HIDE);                 }
    void Minimize(void)         { Display(SW_MINIMIZE);             }
    void Maximize(void)         { Display(SW_SHOWMAXIMIZED);        }
        // displays window in original size and position
    void Normalize(void)        { Display(SW_SHOWNORMAL);           }
    void DefaultDisplay(void)   { current_display = GetCmdShow();   }
    void Paint(void);
    void Update(void)           { UpdateWindow(hWnd);            }

        // vocab of functions for modifying the registration info
    void SetClassInstance(void)         { hInstance = GetInstance();    }
    void SetClassName(LPSTR classname)  { lpszClassName = classname;    }
    void SetClassStyle(unsigned newstyle)   { style = newstyle;         }
    void AddClassStyle(unsigned addstyle)   { style |= addstyle;        }
    void DelClassStyle(unsigned delstyle)   { style ^= delstyle;        }
    void AddClassWinXbytes(int xtrabytes)   { cbWndExtra += xtrabytes;  }
    void SetClassIcon(LPSTR iconname);
    void SetClassWinProc(long (FAR PASCAL *wndProc)(HWND, unsigned, 
            WORD, LONG))
        {   
        lpfnWndProc = wndProc;  
        }
    void SetClassBackGround(HBRUSH handle)  
        {   
        hbrBackground = (handle <= COLOR_ENDCOLORS) ? handle+1 : handle; 
        }

    LPSTR GetClassName(void)            { return lpszClassName;         }
    void SetClassMenu(LPSTR menuname)   {   lpszMenuName = menuname;    }

        // vocab of functions for modifying the create info
    void SetWinClassName(LPSTR classname)   { WHdl.classname = classname;}
    void SetWinName(LPSTR winname)  { WHdl.windowname = winname;        }
    LPSTR GetWinName(void)          { return WHdl.windowname;           }
    void SetWinStyle(DWORD dword)   { WHdl.winstyle = dword;            }
    void AddWinStyle(DWORD dword)   { WHdl.winstyle |= dword;           }
    void DelWinStyle(DWORD dword)   { WHdl.winstyle ^= dword;           }
    void SetWinX(int x)             { WHdl.upper_left_x = x;            }
    void SetWinY(int y)             { WHdl.upper_left_y = y;            }
    void SetWinWidth(int width)     { WHdl.winwidth = width;            }
    void SetWinHeight(int height)   { WHdl.winheight = height;          }
    void SetWinParent(HWND hWnd)    { WHdl.winParent = hWnd;            }
    void SetWinMenu(HMENU hmenu)    { WHdl.menu = hmenu;                }
    void SetWinInstance(HANDLE hinst){ WHdl.hInstance = hinst;          }
    void SetWinParams(LPSTR param)  { WHdl.lpParam = param;             }

    virtual void DefWinProc(WinAppMsg& m);
    virtual void WMUSER(WinAppMsg& m);
    virtual void UserCommandMessages(WinAppMsg& m)
        {
        DefWinProc(m);
        m.userMsgUsed = TRUE;
        }
    LONG PASCAL SendMsg(WORD message, WORD wParam = 0, LONG lParam = 0L)
        {
        return SendMessage(hWnd,message,wParam,lParam);
        }
    LONG PASCAL PostMsg(WORD message, WORD wParam = 0, LONG lParam = 0L)
        {
        return PostMessage(hWnd,message,wParam,lParam);
        }

#if defined(_WM_NULL)
    virtual void WMNULL(WinAppMsg& m)               {    DefWinProc(m); }
#endif
#if defined(_WM_CREATE)
    virtual void WMCREATE(WinAppMsg& m)             {    DefWinProc(m); }
#endif
#if defined(_WM_DESTROY)
    virtual void WMDESTROY(WinAppMsg& m)            {    DefWinProc(m); }
#endif
#if defined(_WM_MOVE)
    virtual void WMMOVE(WinAppMsg& m)               {    DefWinProc(m); }
#endif
#if defined(_WM_SIZE)
    virtual void WMSIZE(WinAppMsg& m)               {    DefWinProc(m); }
#endif
#if defined(_WM_ACTIVATE)
    virtual void WMACTIVATE(WinAppMsg& m)           {    DefWinProc(m); }
#endif
#if defined(_WM_SETFOCUS)
    virtual void WMSETFOCUS(WinAppMsg& m)           {    DefWinProc(m); }
#endif
#if defined(_WM_KILLFOCUS)
    virtual void WMKILLFOCUS(WinAppMsg& m)          {    DefWinProc(m); }
#endif
#if defined(_WM_ENABLE)
    virtual void WMENABLE(WinAppMsg& m)             {    DefWinProc(m); }
#endif
#if defined(_WM_SETREDRAW)
    virtual void WMSETREDRAW(WinAppMsg& m)          {    DefWinProc(m); }
#endif
#if defined(_WM_SETTEXT)
    virtual void WMSETTEXT(WinAppMsg& m)            {    DefWinProc(m); }
#endif
#if defined(_WM_GETTEXT)
    virtual void WMGETTEXT(WinAppMsg& m)            {    DefWinProc(m); }
#endif
#if defined(_WM_GETTEXTLENGTH)
    virtual void WMGETTEXTLENGTH(WinAppMsg& m)      {    DefWinProc(m); }
#endif
#if defined(_WM_PAINT)
    virtual void WMPAINT(WinAppMsg& m)              {    DefWinProc(m); }
#endif
#if defined(_WM_CLOSE)
    virtual void WMCLOSE(WinAppMsg& m)              {    DefWinProc(m); }
#endif
#if defined(_WM_QUERYENDSESSION)
    virtual void WMQUERYENDSESSION(WinAppMsg& m)    {    DefWinProc(m); }
#endif
#if defined(_WM_QUIT)
    virtual void WMQUIT(WinAppMsg& m)               {    DefWinProc(m); }
#endif
#if defined(_WM_QUERYOPEN)
    virtual void WMQUERYOPEN(WinAppMsg& m)          {    DefWinProc(m); }
#endif
#if defined(_WM_ERASEBKGND)
    virtual void WMERASEBKGND(WinAppMsg& m)         {    DefWinProc(m); }
#endif
#if defined(_WM_SYSCOLORCHANGE)
    virtual void WMSYSCOLORCHANGE(WinAppMsg& m)     {    DefWinProc(m); }
#endif
#if defined(_WM_ENDSESSION)
    virtual void WMENDSESSION(WinAppMsg& m)         {    DefWinProc(m); }
#endif
#if defined(_WM_SHOWWINDOW)
    virtual void WMSHOWWINDOW(WinAppMsg& m)         {    DefWinProc(m); }
#endif
#if defined(_WM_CTLCOLOR)
    virtual void WMCTLCOLOR(WinAppMsg& m)           {    DefWinProc(m); }
#endif
#if defined(_WM_WININICHANGE)
    virtual void WMWININICHANGE(WinAppMsg& m)       {    DefWinProc(m); }
#endif
#if defined(_WM_DEVMODECHANGE)
    virtual void WMDEVMODECHANGE(WinAppMsg& m)      {    DefWinProc(m); }
#endif
#if defined(_WM_ACTIVATEAPP)
    virtual void WMACTIVATEAPP(WinAppMsg& m)        {    DefWinProc(m); }
#endif
#if defined(_WM_FONTCHANGE)
    virtual void WMFONTCHANGE(WinAppMsg& m)         {    DefWinProc(m); }
#endif
#if defined(_WM_TIMECHANGE)
    virtual void WMTIMECHANGE(WinAppMsg& m)         {    DefWinProc(m); }
#endif
#if defined(_WM_CANCELMODE)
    virtual void WMCANCELMODE(WinAppMsg& m)         {    DefWinProc(m); }
#endif
#if defined(_WM_SETCURSOR)
    virtual void WMSETCURSOR(WinAppMsg& m)          {    DefWinProc(m); }
#endif
#if defined(_WM_MOUSEACTIVATE)
    virtual void WMMOUSEACTIVATE(WinAppMsg& m)      {    DefWinProc(m); }
#endif
#if defined(_WM_CHILDACTIVATE)
    virtual void WMCHILDACTIVATE(WinAppMsg& m)      {    DefWinProc(m); }
#endif
#if defined(_WM_QUEUESYNC)
    virtual void WMQUEUESYNC(WinAppMsg& m)          {    DefWinProc(m); }
#endif
#if defined(_WM_GETMINMAXINFO)
    virtual void WMGETMINMAXINFO(WinAppMsg& m)      {    DefWinProc(m); }
#endif
#if defined(_WM_PAINTICON)
    virtual void WMPAINTICON(WinAppMsg& m)          {    DefWinProc(m); }
#endif
#if defined(_WM_ICONERASEBKGND)
    virtual void WMICONERASEBKGND(WinAppMsg& m)     {    DefWinProc(m); }
#endif
#if defined(_WM_NEXTDLGCTL)
    virtual void WMNEXTDLGCTL(WinAppMsg& m)         {    DefWinProc(m); }
#endif
#if defined(_WM_SPOOLERSTATUS)
    virtual void WMSPOOLERSTATUS(WinAppMsg& m)      {    DefWinProc(m); }
#endif
#if defined(_WM_DRAWITEM)
    virtual void WMDRAWITEM(WinAppMsg& m)           {    DefWinProc(m); }
#endif
#if defined(_WM_MEASUREITEM)
    virtual void WMMEASUREITEM(WinAppMsg& m)        {    DefWinProc(m); }
#endif
#if defined(_WM_DELETEITEM)
    virtual void WMDELETEITEM(WinAppMsg& m)         {    DefWinProc(m); }
#endif
#if defined(_WM_VKEYTOITEM)
    virtual void WMVKEYTOITEM(WinAppMsg& m)         {    DefWinProc(m); }
#endif
#if defined(_WM_CHARTOITEM)
    virtual void WMCHARTOITEM(WinAppMsg& m)         {    DefWinProc(m); }
#endif
#if defined(_WM_SETFONT)
    virtual void WMSETFONT(WinAppMsg& m)            {    DefWinProc(m); }
#endif
#if defined(_WM_GETFONT)
    virtual void WMGETFONT(WinAppMsg& m)            {    DefWinProc(m); }
#endif
#if defined(_WM_QUERYDRAGICON)
    virtual void WMQUERYDRAGICON(WinAppMsg& m)      {    DefWinProc(m); }
#endif
#if defined(_WM_COMPAREITEM)
    virtual void WMCOMPAREITEM(WinAppMsg& m)        {    DefWinProc(m); }
#endif
#if defined(_WM_COMPACTING)
    virtual void WMCOMPACTING(WinAppMsg& m)         {    DefWinProc(m); }
#endif
#if defined(_WM_NCCREATE)
    virtual void WMNCCREATE(WinAppMsg& m)           {    DefWinProc(m); }
#endif
#if defined(_WM_NCDESTROY)
    virtual void WMNCDESTROY(WinAppMsg& m)          {    DefWinProc(m); }
#endif
#if defined(_WM_NCCALCSIZE)
    virtual void WMNCCALCSIZE(WinAppMsg& m)         {    DefWinProc(m); }
#endif
#if defined(_WM_NCHITTEST)
    virtual void WMNCHITTEST(WinAppMsg& m)          {    DefWinProc(m); }
#endif
#if defined(_WM_NCPAINT)
    virtual void WMNCPAINT(WinAppMsg& m)            {    DefWinProc(m); }
#endif
#if defined(_WM_NCACTIVATE)
    virtual void WMNCACTIVATE(WinAppMsg& m)         {    DefWinProc(m); }
#endif
#if defined(_WM_GETDLGCODE)
    virtual void WMGETDLGCODE(WinAppMsg& m)         {    DefWinProc(m); }
#endif
#if defined(_WM_NCMOUSEMOVE)
    virtual void WMNCMOUSEMOVE(WinAppMsg& m)        {    DefWinProc(m); }
#endif
#if defined(_WM_NCLBUTTONDOWN)
    virtual void WMNCLBUTTONDOWN(WinAppMsg& m)      {    DefWinProc(m); }
#endif
#if defined(_WM_NCLBUTTONUP)
    virtual void WMNCLBUTTONUP(WinAppMsg& m)        {    DefWinProc(m); }
#endif
#if defined(_WM_NCLBUTTONDBLCLK)
    virtual void WMNCLBUTTONDBLCLK(WinAppMsg& m)    {    DefWinProc(m); }
#endif
#if defined(_WM_NCRBUTTONDOWN)
    virtual void WMNCRBUTTONDOWN(WinAppMsg& m)      {    DefWinProc(m); }
#endif
#if defined(_WM_NCRBUTTONUP)
    virtual void WMNCRBUTTONUP(WinAppMsg& m)        {    DefWinProc(m); }
#endif
#if defined(_WM_NCRBUTTONDBLCLK)
    virtual void WMNCRBUTTONDBLCLK(WinAppMsg& m)    {    DefWinProc(m); }
#endif
#if defined(_WM_NCMBUTTONDOWN)
    virtual void WMNCMBUTTONDOWN(WinAppMsg& m)      {    DefWinProc(m); }
#endif
#if defined(_WM_NCMBUTTONUP)
    virtual void WMNCMBUTTONUP(WinAppMsg& m)        {    DefWinProc(m); }
#endif
#if defined(_WM_NCMBUTTONDBLCLK)
    virtual void WMNCMBUTTONDBLCLK(WinAppMsg& m)    {    DefWinProc(m); }
#endif
#if defined(_WM_KEYFIRST)
    virtual void WMKEYFIRST(WinAppMsg& m)           {    DefWinProc(m); }
#endif
#if defined(_WM_KEYDOWN)
    virtual void WMKEYDOWN(WinAppMsg& m)            {    DefWinProc(m); }
#endif
#if defined(_WM_KEYUP)
    virtual void WMKEYUP(WinAppMsg& m)              {    DefWinProc(m); }
#endif
#if defined(_WM_CHAR)
    virtual void WMCHAR(WinAppMsg& m)               {    DefWinProc(m); }
#endif
#if defined(_WM_DEADCHAR)
    virtual void WMDEADCHAR(WinAppMsg& m)           {    DefWinProc(m); }
#endif
#if defined(_WM_SYSKEYDOWN)
    virtual void WMSYSKEYDOWN(WinAppMsg& m)         {    DefWinProc(m); }
#endif
#if defined(_WM_SYSKEYUP)
    virtual void WMSYSKEYUP(WinAppMsg& m)           {    DefWinProc(m); }
#endif
#if defined(_WM_SYSCHAR)
    virtual void WMSYSCHAR(WinAppMsg& m)            {    DefWinProc(m); }
#endif
#if defined(_WM_SYSDEADCHAR)
    virtual void WMSYSDEADCHAR(WinAppMsg& m)        {    DefWinProc(m); }
#endif
#if defined(_WM_KEYLAST)
    virtual void WMKEYLAST(WinAppMsg& m)            {    DefWinProc(m); }
#endif
#if defined(_WM_INITDIALOG)
    virtual void WMINITDIALOG(WinAppMsg& m)         {    DefWinProc(m); }
#endif
#if defined(_WM_COMMAND)
    virtual void WMCOMMAND(WinAppMsg& m)    
        {
        UserCommandMessages(m);
        if(!m.userMsgUsed)
            DefWinProc(m);
        }
#endif
#if defined(_WM_SYSCOMMAND)
    virtual void WMSYSCOMMAND(WinAppMsg& m)         {    DefWinProc(m); }
#endif
#if defined(_WM_TIMER)
    virtual void WMTIMER(WinAppMsg& m)              {    DefWinProc(m); }
#endif
#if defined(_WM_HSCROLL)
    virtual void WMHSCROLL(WinAppMsg& m)            {    DefWinProc(m); }
#endif
#if defined(_WM_VSCROLL)
    virtual void WMVSCROLL(WinAppMsg& m)            {    DefWinProc(m); }
#endif
#if defined(_WM_INITMENU)
    virtual void WMINITMENU(WinAppMsg& m)           {    DefWinProc(m); }
#endif
#if defined(_WM_INITMENUPOPUP)
    virtual void WMINITMENUPOPUP(WinAppMsg& m)      {    DefWinProc(m); }
#endif
#if defined(_WM_MENUSELECT)
    virtual void WMMENUSELECT(WinAppMsg& m)         {    DefWinProc(m); }
#endif
#if defined(_WM_MENUCHAR)
    virtual void WMMENUCHAR(WinAppMsg& m)           {    DefWinProc(m); }
#endif
#if defined(_WM_ENTERIDLE)
    virtual void WMENTERIDLE(WinAppMsg& m)          {    DefWinProc(m); }
#endif
#if defined(_WM_MOUSEFIRST)
    virtual void WMMOUSEFIRST(WinAppMsg& m)         {    DefWinProc(m); }
#endif
#if defined(_WM_MOUSEMOVE)
    virtual void WMMOUSEMOVE(WinAppMsg& m)          {    DefWinProc(m); }
#endif
#if defined(_WM_LBUTTONDOWN)
    virtual void WMLBUTTONDOWN(WinAppMsg& m)        {    DefWinProc(m); }
#endif
#if defined(_WM_LBUTTONUP)
    virtual void WMLBUTTONUP(WinAppMsg& m)          {    DefWinProc(m); }
#endif
#if defined(_WM_LBUTTONDBLCLK)
    virtual void WMLBUTTONDBLCLK(WinAppMsg& m)      {    DefWinProc(m); }
#endif
#if defined(_WM_RBUTTONDOWN)
    virtual void WMRBUTTONDOWN(WinAppMsg& m)        {    DefWinProc(m); }
#endif
#if defined(_WM_RBUTTONUP)
    virtual void WMRBUTTONUP(WinAppMsg& m)          {    DefWinProc(m); }
#endif
#if defined(_WM_RBUTTONDBLCLK)
    virtual void WMRBUTTONDBLCLK(WinAppMsg& m)      {    DefWinProc(m); }
#endif
#if defined(_WM_MBUTTONDOWN)
    virtual void WMMBUTTONDOWN(WinAppMsg& m)        {    DefWinProc(m); }
#endif
#if defined(_WM_MBUTTONUP)
    virtual void WMMBUTTONUP(WinAppMsg& m)          {    DefWinProc(m); }
#endif
#if defined(_WM_MBUTTONDBLCLK)
    virtual void WMMBUTTONDBLCLK(WinAppMsg& m)      {    DefWinProc(m); }
#endif
#if defined(_WM_MOUSELAST)
    virtual void WMMOUSELAST(WinAppMsg& m)          {    DefWinProc(m); }
#endif
#if defined(_WM_PARENTNOTIFY)
    virtual void WMPARENTNOTIFY(WinAppMsg& m)       {    DefWinProc(m); }
#endif
#if defined(_WM_MDICREATE)
    virtual void WMMDICREATE(WinAppMsg& m)          {    DefWinProc(m); }
#endif
#if defined(_WM_MDIDESTROY)
    virtual void WMMDIDESTROY(WinAppMsg& m)         {    DefWinProc(m); }
#endif
#if defined(_WM_MDIACTIVATE)
    virtual void WMMDIACTIVATE(WinAppMsg& m)        {    DefWinProc(m); }
#endif
#if defined(_WM_MDIRESTORE)
    virtual void WMMDIRESTORE(WinAppMsg& m)         {    DefWinProc(m); }
#endif
#if defined(_WM_MDINEXT)
    virtual void WMMDINEXT(WinAppMsg& m)            {    DefWinProc(m); }
#endif
#if defined(_WM_MDIMAXIMIZE)
    virtual void WMMDIMAXIMIZE(WinAppMsg& m)        {    DefWinProc(m); }
#endif
#if defined(_WM_MDITILE)
    virtual void WMMDITILE(WinAppMsg& m)            {    DefWinProc(m); }
#endif
#if defined(_WM_MDICASCADE)
    virtual void WMMDICASCADE(WinAppMsg& m)         {    DefWinProc(m); }
#endif
#if defined(_WM_MDIICONARRANGE)
    virtual void WMMDIICONARRANGE(WinAppMsg& m)     {    DefWinProc(m); }
#endif
#if defined(_WM_MDIGETACTIVE)
    virtual void WMMDIGETACTIVE(WinAppMsg& m)       {    DefWinProc(m); }
#endif
#if defined(_WM_MDISETMENU)
    virtual void WMMDISETMENU(WinAppMsg& m)         {    DefWinProc(m); }
#endif
#if defined(_WM_CUT)
    virtual void WMCUT(WinAppMsg& m)                {    DefWinProc(m); }
#endif
#if defined(_WM_COPY)
    virtual void WMCOPY(WinAppMsg& m)               {    DefWinProc(m); }
#endif
#if defined(_WM_PASTE)
    virtual void WMPASTE(WinAppMsg& m)              {    DefWinProc(m); }
#endif
#if defined(_WM_CLEAR)
    virtual void WMCLEAR(WinAppMsg& m)              {    DefWinProc(m); }
#endif
#if defined(_WM_UNDO)
    virtual void WMUNDO(WinAppMsg& m)               {    DefWinProc(m); }
#endif
#if defined(_WM_RENDERFORMAT)
    virtual void WMRENDERFORMAT(WinAppMsg& m)       {    DefWinProc(m); }
#endif
#if defined(_WM_RENDERALLFORMATS)
    virtual void WMRENDERALLFORMATS(WinAppMsg& m)   {    DefWinProc(m); }
#endif
#if defined(_WM_DESTROYCLIPBOARD)
    virtual void WMDESTROYCLIPBOARD(WinAppMsg& m)   {    DefWinProc(m); }
#endif
#if defined(_WM_DRAWCLIPBOARD)
    virtual void WMDRAWCLIPBOARD(WinAppMsg& m)      {    DefWinProc(m); }
#endif
#if defined(_WM_PAINTCLIPBOARD)
    virtual void WMPAINTCLIPBOARD(WinAppMsg& m)     {    DefWinProc(m); }
#endif
#if defined(_WM_VSCROLLCLIPBOARD)
    virtual void WMVSCROLLCLIPBOARD(WinAppMsg& m)   {    DefWinProc(m); }
#endif
#if defined(_WM_SIZECLIPBOARD)
    virtual void WMSIZECLIPBOARD(WinAppMsg& m)      {    DefWinProc(m); }
#endif
#if defined(_WM_ASKCBFORMATNAME)
    virtual void WMASKCBFORMATNAME(WinAppMsg& m)    {    DefWinProc(m); }
#endif
#if defined(_WM_CHANGECBCHAIN)
    virtual void WMCHANGECBCHAIN(WinAppMsg& m)      {    DefWinProc(m); }
#endif
#if defined(_WM_HSCROLLCLIPBOARD)
    virtual void WMHSCROLLCLIPBOARD(WinAppMsg& m)   {    DefWinProc(m); }
#endif
#if defined(_WM_QUERYNEWPALETTE)
    virtual void WMQUERYNEWPALETTE(WinAppMsg& m)    {    DefWinProc(m); }
#endif
#if defined(_WM_PALETTEISCHANGING)
    virtual void WMPALETTEISCHANGING(WinAppMsg& m)  {    DefWinProc(m); }
#endif
#if defined(_WM_PALETTECHANGED)
    virtual void WMPALETTECHANGED(WinAppMsg& m)     {    DefWinProc(m); }
#endif

    };

inline void SetWindowPointer(HWND hWnd, void *ptr)
    {
#if defined(__SMALL__) || defined(__MEDIUM__)
    SetWindowWord(hWnd,0,(WORD)ptr);
#elif defined(__LARGE__) || defined(__COMPACT__) || defined(__HUGE__)
    SetWindowLong(hWnd,0,(LONG)ptr);
#else
    #error Must use Small, Medium, Large, Compact or Huge models!
#endif
    }

inline Window *GetWindowPointer(HWND hWnd)
    {
#if defined(__SMALL__) || defined(__MEDIUM__)
    return (Window *)GetWindowWord(hWnd,0);
#elif defined(__LARGE__) || defined(__COMPACT__) || defined(__HUGE__)
    return (Window *)GetWindowLong(hWnd,0);
#else
    #error Must use Small, Medium, Large, Compact or Huge models!
#endif
    }

void PASCAL StdWndProc(Window *w, WinAppMsg& m);

#endif

