#include <afxwin.h>
#include <afxext.h>
#include "buttons2.h"

CMyApp myApp;

/////////////////////////////////////////////////////////////////////////////
// Member functions for the CMyApp class.

BOOL CMyApp::InitInstance ()
{
    m_pMainWnd = new CMainWindow ();
    m_pMainWnd->ShowWindow (m_nCmdShow);
    m_pMainWnd->UpdateWindow ();
    SetDialogBkColor ();
    return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// Member functions and message map for the CMainWindow class.

CMainWindow::CMainWindow ()
{
    Create (NULL, "CBitmapButton Demo 2", WS_OVERLAPPEDWINDOW,
        rectDefault, NULL, "MainMenu");
}

int CMainWindow::OnCreate (LPCREATESTRUCT)
{
    CRect rect;

    rect.SetRect (4, 4, 36, 36);
    m_OpenButton.Create (NULL, WS_CHILD | WS_VISIBLE | BS_OWNERDRAW,
        rect, this, IDB_OPEN);
    m_OpenButton.LoadBitmaps ("OPENU", "OPEND", NULL, "OpenX");

    rect.SetRect (40, 4, 72, 36);
    m_SaveButton.Create (NULL, WS_CHILD | WS_VISIBLE | BS_OWNERDRAW,
        rect, this, IDB_SAVE);
    m_SaveButton.LoadBitmaps ("SaveU", "SaveD", NULL, "SaveX");
    return 0;
}

void CMainWindow::OnPaint ()
{
    CRect rect;
    CPaintDC dc (this);
    
    GetClientRect (rect);
    rect.BottomRight().y = 40;
    CBrush brush (RGB (192, 192, 192));
    dc.FillRect (rect, &brush);
    dc.MoveTo (rect.TopLeft().x, rect.BottomRight().y);
    dc.LineTo (rect.BottomRight().x, rect.BottomRight().y);
}

void CMainWindow::OnOpen ()
{
    ::MessageBeep (MB_OK);
}

void CMainWindow::OnSave ()
{
    ::MessageBeep (MB_ICONHAND);
}

void CMainWindow::OnOptions ()
{
    COptionsDlg dlg (this);
    dlg.DoModal ();
}

void CMainWindow::OnExit ()
{
    SendMessage (WM_CLOSE, 0, 0L);
}

BEGIN_MESSAGE_MAP (CMainWindow, CFrameWnd)
    ON_WM_CREATE ()
    ON_WM_PAINT ()
    ON_COMMAND (IDM_OPEN, OnOpen)
    ON_COMMAND (IDM_SAVE, OnSave)
    ON_COMMAND (IDM_OPTIONS, OnOptions)
    ON_COMMAND (IDM_EXIT, OnExit)
    ON_BN_CLICKED (IDB_OPEN, OnOpen)
    ON_BN_CLICKED (IDB_SAVE, OnSave)
END_MESSAGE_MAP ()

/////////////////////////////////////////////////////////////////////////////
// Member functions and message map for the COptionsDlg class.

BOOL COptionsDlg::OnInitDialog ()
{
    m_OKButton.AutoLoad (IDOK, this);
    m_CancelButton.AutoLoad (IDCANCEL, this);
    CheckRadioButton (IDD_ENABLEOPEN, IDD_DISABLEOPEN,
        ((CMainWindow *) (myApp.m_pMainWnd))->m_OpenButton.IsWindowEnabled () ?
        IDD_ENABLEOPEN : IDD_DISABLEOPEN);
    CheckRadioButton (IDD_ENABLESAVE, IDD_DISABLESAVE,
        ((CMainWindow *) (myApp.m_pMainWnd))->m_SaveButton.IsWindowEnabled () ?
        IDD_ENABLESAVE : IDD_DISABLESAVE);
    return TRUE;
}

void COptionsDlg::OnOK ()
{
    ((CMainWindow *) (myApp.m_pMainWnd))->m_OpenButton.EnableWindow (
        IsDlgButtonChecked (IDD_ENABLEOPEN));
    ((CMainWindow *) (myApp.m_pMainWnd))->m_SaveButton.EnableWindow (
        IsDlgButtonChecked (IDD_ENABLESAVE));
    CModalDialog::OnOK ();
}

BEGIN_MESSAGE_MAP (COptionsDlg, CModalDialog)
    ON_COMMAND (IDOK, OnOK)
END_MESSAGE_MAP ()
