VERSION 2.00
Begin Form frmSetup 
   BorderStyle     =   3  'Fixed Double
   Caption         =   "GUIToons Setup"
   ClientHeight    =   4965
   ClientLeft      =   2085
   ClientTop       =   1770
   ClientWidth     =   5385
   Height          =   5490
   Icon            =   SETUP.FRX:0000
   Left            =   2025
   LinkTopic       =   "Form1"
   ScaleHeight     =   4965
   ScaleWidth      =   5385
   Top             =   1305
   Width           =   5505
   Begin CommandButton Command4 
      Caption         =   "About GUIToons..."
      Height          =   375
      Left            =   2520
      TabIndex        =   24
      Top             =   4440
      Width           =   2655
   End
   Begin HScrollBar sbScrMovement 
      Height          =   240
      LargeChange     =   10
      Left            =   840
      Max             =   50
      Min             =   1
      TabIndex        =   19
      Top             =   1305
      Value           =   10
      Width           =   3975
   End
   Begin HScrollBar sbAnimSpeed 
      Height          =   240
      LargeChange     =   10
      Left            =   840
      Max             =   50
      Min             =   1
      TabIndex        =   16
      Top             =   540
      Value           =   50
      Width           =   3975
   End
   Begin CheckBox Check2 
      Caption         =   "Use Password"
      Height          =   315
      Left            =   315
      TabIndex        =   15
      Top             =   3465
      Width           =   1635
   End
   Begin CommandButton Command5 
      Caption         =   "Change Password"
      Height          =   405
      Left            =   2070
      TabIndex        =   14
      Top             =   3420
      Width           =   3105
   End
   Begin CheckBox Check1 
      Caption         =   "&Insert"
      Height          =   285
      Left            =   330
      TabIndex        =   13
      Top             =   2385
      Width           =   885
   End
   Begin CommandButton Command6 
      Caption         =   "&Clear"
      Height          =   375
      Left            =   1260
      TabIndex        =   12
      Top             =   1845
      Width           =   735
   End
   Begin OptionButton Option1 
      Caption         =   "&Leave Alone"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   255
      Index           =   1
      Left            =   525
      TabIndex        =   10
      Top             =   4485
      Width           =   1485
   End
   Begin OptionButton Option1 
      Caption         =   "&Clear"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   255
      Index           =   0
      Left            =   525
      TabIndex        =   9
      Top             =   4215
      Width           =   855
   End
   Begin CommonDialog CMDialog1 
      CancelError     =   -1  'True
      Left            =   270
      Top             =   2745
   End
   Begin CommandButton Command3 
      Caption         =   "&Help"
      Height          =   375
      Left            =   4440
      TabIndex        =   4
      Top             =   4020
      Width           =   735
   End
   Begin CommandButton Command8 
      Caption         =   "&Del"
      Height          =   375
      Left            =   1260
      TabIndex        =   1
      Top             =   2835
      Width           =   735
   End
   Begin CommandButton Command7 
      Caption         =   "&Add"
      Height          =   375
      Left            =   1260
      TabIndex        =   0
      Top             =   2355
      Width           =   735
   End
   Begin ListBox List1 
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   1395
      Left            =   2100
      TabIndex        =   5
      Top             =   1845
      Width           =   3075
   End
   Begin CommandButton Command2 
      Cancel          =   -1  'True
      Caption         =   "Cancel"
      Height          =   375
      Left            =   3360
      TabIndex        =   3
      Top             =   4020
      Width           =   975
   End
   Begin CommandButton Command1 
      Caption         =   "OK"
      Default         =   -1  'True
      Enabled         =   0   'False
      Height          =   375
      Left            =   2520
      TabIndex        =   2
      Top             =   4020
      Width           =   735
   End
   Begin Label LabScrMovement 
      AutoSize        =   -1  'True
      Caption         =   "10"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   195
      Left            =   2040
      TabIndex        =   22
      Top             =   945
      Width           =   180
   End
   Begin Label LabAnimSpeed 
      AutoSize        =   -1  'True
      Caption         =   "50"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   195
      Left            =   2040
      TabIndex        =   23
      Top             =   210
      Width           =   180
   End
   Begin Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "Fast"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   195
      Index           =   5
      Left            =   4920
      TabIndex        =   21
      Top             =   1305
      Width           =   300
   End
   Begin Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "Slow"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   195
      Index           =   4
      Left            =   240
      TabIndex        =   20
      Top             =   1305
      Width           =   345
   End
   Begin Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "Fast"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   195
      Index           =   3
      Left            =   4920
      TabIndex        =   18
      Top             =   540
      Width           =   300
   End
   Begin Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "Slow"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   195
      Index           =   2
      Left            =   240
      TabIndex        =   17
      Top             =   540
      Width           =   345
   End
   Begin Label Label2 
      AutoSize        =   -1  'True
      Caption         =   "Background:"
      Height          =   195
      Index           =   1
      Left            =   255
      TabIndex        =   11
      Top             =   3945
      Width           =   1125
   End
   Begin Label Label2 
      AutoSize        =   -1  'True
      Caption         =   "Screen Movement:"
      Height          =   195
      Index           =   0
      Left            =   270
      TabIndex        =   8
      Top             =   945
      Width           =   1605
   End
   Begin Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "Animation Speed:"
      Height          =   195
      Index           =   1
      Left            =   255
      TabIndex        =   7
      Top             =   210
      Width           =   1500
   End
   Begin Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "Bitmaps:"
      Height          =   195
      Index           =   0
      Left            =   300
      TabIndex        =   6
      Top             =   1845
      Width           =   735
   End
End
DefInt A-Z
Option Explicit
Dim NumBitmaps, NewNumBitmaps

Sub Check2_Click ()

'-- Password Protection
  Select Case Check2.Value
    Case 0
      Command5.Enabled = False
    Case 1
      Command5.Enabled = True
  End Select

End Sub

Sub Command1_Click ()
'-- OK Button

'-- Write settings to WIN.INI ---------------------------------------------
  Hide
  DoEvents
    '-- Animation Interval
  WriteInt "Interval", sbAnimSpeed.Max - sbAnimSpeed.Value + 1

    '-- Move Speed
  WriteInt "MoveSpeed", sbScrMovement.Value

    '-- Screen
  ClearScreen% = Option1(0).Value
  WriteInt "ClearScreen", ClearScreen%

    '-- Number of Bitmaps
  NewNumBitmaps = List1.ListCount
  WriteInt "NumBitmaps", NewNumBitmaps

  Dim KeyName$, BitMap$, i%
    '-- Bitmap Names
  For i = 1 To NewNumBitmaps
    KeyName$ = "Bitmap" & LTrim$(Str$(i))
    BitMap$ = List1.List(i - 1)
    WriteString KeyName$, BitMap$
  Next
  If NumBitmaps > NewNumBitmaps Then
    For i = NewNumBitmaps + 1 To NumBitmaps
      KeyName$ = "Bitmap" & LTrim$(Str$(i))
      BitMap$ = ""
      WriteString KeyName$, BitMap$
    Next
  End If

    '-- Password
  If Check2.Value = 0 Then
    WriteString "PWProtected", "0"
  Else
    WriteString "PWProtected", "1"
  End If

  End

End Sub

Sub Command2_Click ()
    '-- Cancel
  Hide
  DoEvents
  End
End Sub

Sub Command3_Click ()
    '-- Help Message
  Dim CrLF$, Msg$
  CrLF$ = Chr$(13) & Chr$(10)
  Msg$ = "Use the Add button to add .BMP files in the order "
  Msg$ = Msg$ & "that they are to be displayed in the animation "
  Msg$ = Msg$ & "sequence. The sequence is cyclical, meaning "
  Msg$ = Msg$ & "that it repeats. For example, if you load 4 "
  Msg$ = Msg$ & "bitmaps, the animated sequence will be "
  Msg$ = Msg$ & "{1,2,3,4,3,2,1,REPEAT}." & CrLF$ & CrLF$
  Msg$ = Msg$ & "The MoveSpeed specifies the number of pixels "
  Msg$ = Msg$ & "of background color from each edge of the "
  Msg$ = Msg$ & "image. If this value is too high, you may see "
  Msg$ = Msg$ & "'trails' (do not adjust your set)." & CrLF$
  Msg$ = Msg$ & CrLF$ & "The Animation Interval specifies the "
  Msg$ = Msg$ & "number of milliseconds between each painted "
  Msg$ = Msg$ & "frame of the animation. The smaller the value, "
  Msg$ = Msg$ & "the faster the animation will be."
  MsgBox Msg$, 0, "GUIToons Help"
End Sub

Sub Command4_Click ()
  AboutForm.Show 1
End Sub

Sub Command5_Click ()
'-- Change Password

  frmSetPW.Show 1

End Sub

Sub Command6_Click ()
    '-- Clear button
  List1.Clear
  Command1.Enabled = False
  Command6.Enabled = False
  Command7.Enabled = True
  Command8.Enabled = False
End Sub

Sub Command7_Click ()
    '-- Add button
  Dim Filename$, Path$, NextFile$, Sp, LI%

        '-- Add a Bitmap
        '-- Get a file name from the user
  CMDialog1.Filter = "Windows 3.1 Bitmap|*.BMP"
  CMDialog1.DialogTitle = "Add Bitmap File"
  CMDialog1.DefaultExt = "BMP"
  CMDialog1.Filename = "*.BMP"
  On Error Resume Next
  CMDialog1.Action = 1
  If Err Then Exit Sub
  Filename$ = CMDialog1.Filename
        '-- Files come back separated by spaces.
        '   This little routine parses them
  Sp = InStr(Filename$, " ")
  If Sp Then
    Path$ = Left$(Filename$, Sp - 1) & "\"
    Filename$ = Mid$(Filename$, Sp + 1)
    Do
      Sp = InStr(Filename$, " ")
      If Sp Then
        NextFile$ = Left$(Filename$, Sp - 1)
        Filename$ = Mid$(Filename$, Sp + 1)
        GoSub Add
      Else
        NextFile$ = Filename$
        GoSub Add
        Exit Do
      End If
    Loop
  Else
    NextFile$ = Filename$
    GoSub Add
  End If
  Command6.Enabled = True
  Command8.Enabled = True
  Exit Sub
Add:

  If Check1.Value = 1 Then
    LI = List1.ListIndex
    If LI = -1 Then LI = 0
    List1.AddItem UCase$(Path$ & NextFile$), LI
    List1.ListIndex = List1.ListIndex - 1
  Else
    List1.AddItem UCase$(Path$ & NextFile$)
  End If
  Command1.Enabled = True
  Return
End Sub

Sub Command8_Click ()
    '-- Del button
  Dim OldIndex%
  If List1.ListIndex = -1 Then
    List1.ListIndex = List1.ListCount - 1
  End If
  OldIndex = List1.ListIndex
  List1.RemoveItem List1.ListIndex
  If List1.ListCount = 0 Then
    Command1.Enabled = False
    Command6.Enabled = False
    Command8.Enabled = False
  Else
    If OldIndex > List1.ListCount - 1 Then
      OldIndex = OldIndex - 1
    End If
    List1.ListIndex = OldIndex
  End If

End Sub

Sub Form_Load ()
  
  Dim Interval%, UsePW%, i%
    '-- Center this form
  Screen.MousePointer = 11
  Me.Left = (Screen.Width - Me.Width) / 2
  Me.Top = (Screen.Height - Me.Height) / 2
  Enabled = False

    '-- Allow multiple selection in common dialog
  CMDialog1.Flags = CMDialog1.Flags Or &H200

'-- Read data from the WIN.INI file ------------------------

    '-- Number of Bitmaps
  NumBitmaps = ReadInt("NumBitmaps", 0)

    '-- Move Speed (in pixels)
  MoveSpeed = ReadInt("MoveSpeed", 10)
  If (MoveSpeed > 0) And (MoveSpeed <= sbScrMovement.Max) Then
    sbScrMovement.Value = MoveSpeed
  Else
    sbScrMovement.Value = 10
  End If

    '-- Animation Interval (in clock ticks)
  Interval = ReadInt("Interval", 1)
  If (Interval > 0) And (Interval <= sbAnimSpeed.Max) Then
    sbAnimSpeed.Value = sbAnimSpeed.Max - Interval + 1
  Else
    sbAnimSpeed.Value = 1
  End If

    '-- Background Screen behavior
  ClearScreen% = ReadInt("ClearScreen", False)
  If ClearScreen Then
    Option1(0).Value = True
  Else
    Option1(1).Value = True
  End If
  
    '-- Password
  UsePW = ReadInt("PWProtected", 0) = 1
  If UsePW Then
    Check2.Value = 1
    Command5.Enabled = True
  Else
    Check2.Value = 0
    Command5.Enabled = False
  End If

  Dim KeyName$, Temp$
    '-- Read Bitmap Names
  For i = 1 To NumBitmaps
    KeyName$ = "Bitmap" & LTrim$(Str$(i))
    Temp$ = ReadString$(KeyName$)
    If Len(Temp$) Then
      List1.AddItem Temp$
    End If
  Next

    '-- Enable/Disable Clear and Delete
  If List1.ListCount Then
    Command1.Enabled = True
    Command6.Enabled = True
    Command8.Enabled = True
  Else
    Command6.Enabled = False
    Command8.Enabled = False
  End If

  Screen.MousePointer = 0
  Enabled = True
  Dim Success%, Wid%

  Success = SendMessage(List1.hWnd, LB_SETHORIZONTALEXTENT, 500, 0)

End Sub

Sub sbAnimSpeed_Change ()
  LabAnimSpeed.Caption = Format$(sbAnimSpeed.Value)
End Sub

Sub sbScrMovement_Change ()
  LabScrMovement.Caption = Format$(sbScrMovement.Value)
End Sub

