// cntritem.h : interface of the CCntrItem class
//

class CCntrDoc;
class CCntrView;

class CCntrItem : public COleClientItem
{
	DECLARE_SERIAL(CCntrItem)

// Operations
public:
	void UpdateExtent();
	void InvalidateItem()
		{
		GetDocument()->UpdateAllViews(NULL, HINT_UPDATE_ITEM, this);
		}
	// Constructors
public:
	CCntrItem(CCntrDoc* pContainer = NULL);
		// Note: pContainer is allowed to be NULL to enable IMPLEMENT_SERIALIZE.
		//  IMPLEMENT_SERIALIZE requires the class have a constructor with
		//  zero arguments.  Normally, OLE items are constructed with a
		//  non-NULL document pointer.

// Attributes
public:
	CCntrDoc* GetDocument()
		{ return (CCntrDoc*)COleClientItem::GetDocument(); }
	CCntrView* GetActiveView()
		{ return (CCntrView*)COleClientItem::GetActiveView(); }

	// in the container item class definition, add:
	CRect m_rect;



	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CCntrItem)
	public:
	virtual void OnChange(OLE_NOTIFICATION wNotification, DWORD dwParam);
	protected:
	virtual void OnGetItemPosition(CRect& rPosition);
	virtual void OnDeactivateUI(BOOL bUndoable);
	virtual BOOL OnChangeItemPosition(const CRect& rectPos);
	//}}AFX_VIRTUAL

// Implementation
public:
	~CCntrItem();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif
	virtual void Serialize(CArchive& ar);
};

/////////////////////////////////////////////////////////////////////////////
