// vblisctl.h : Declaration of the CVBListCtrl OLE control class.

/////////////////////////////////////////////////////////////////////////////
// CVBListCtrl : See vblisctl.cpp for implementation.

class CVBListCtrl : public COleControl
{
	DECLARE_DYNCREATE(CVBListCtrl)

// Constructor
public:
	CVBListCtrl();

// Overrides

	// Drawing function
	virtual void OnDraw(
				CDC* pdc, const CRect& rcBounds, const CRect& rcInvalid);

	// Persistence
	virtual void DoPropExchange(CPropExchange* pPX);

	// Reset control state
	virtual void OnResetState();

// Implementation
protected:
	~CVBListCtrl();

	DECLARE_OLECREATE_EX(CVBListCtrl)    // Class factory and guid
	DECLARE_OLETYPELIB(CVBListCtrl)      // GetTypeInfo
	DECLARE_PROPPAGEIDS(CVBListCtrl)     // Property page IDs
	DECLARE_OLECTLTYPE(CVBListCtrl)		// Type name and misc status

// Message maps
	//{{AFX_MSG(CVBListCtrl)
		// NOTE - ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

// Dispatch maps
	//{{AFX_DISPATCH(CVBListCtrl)
	afx_msg BSTR GetHead();
	afx_msg BSTR GetTail();
	afx_msg void RemoveHead();
	afx_msg void RemoveTail();
	afx_msg void RemoveAll();
	afx_msg BSTR GetNext();
	afx_msg BSTR GetPrev();
	afx_msg short Count();
	afx_msg BOOL IsEmpty();
	afx_msg void AddHead(LPCTSTR Value);
	afx_msg void AddTail(LPCTSTR Value);
	afx_msg void GotoHead();
	afx_msg void GotoTail();
	afx_msg BSTR GetCurrent();
	afx_msg void SetCurrent(LPCTSTR Value);
	afx_msg void RemoveCurrent();
	afx_msg short GetCurrentIndex();
	afx_msg BOOL FindFromCurrent(LPCTSTR SearchValue);
	afx_msg BOOL FindFromStart(LPCTSTR SearchValue);
	afx_msg void InsertBefore(LPCTSTR Value);
	afx_msg void InsertAfter(LPCTSTR Value);
	afx_msg void SetCurrentIndex(short Index);
	//}}AFX_DISPATCH
	DECLARE_DISPATCH_MAP()

// Event maps
	//{{AFX_EVENT(CVBListCtrl)
	//}}AFX_EVENT
	DECLARE_EVENT_MAP()

// Dispatch and event IDs
public:
	enum {
	//{{AFX_DISP_ID(CVBListCtrl)
	dispidGetHead = 1L,
	dispidGetTail = 2L,
	dispidRemoveHead = 3L,
	dispidRemoveTail = 4L,
	dispidRemoveAll = 5L,
	dispidGetNext = 6L,
	dispidGetPrev = 7L,
	dispidCount = 8L,
	dispidIsEmpty = 9L,
	dispidAddHead = 10L,
	dispidAddTail = 11L,
	dispidGotoHead = 12L,
	dispidGotoTail = 13L,
	dispidGetCurrent = 14L,
	dispidSetCurrent = 15L,
	dispidRemoveCurrent = 16L,
	dispidGetCurrentIndex = 17L,
	dispidFindFromCurrent = 18L,
	dispidFindFromStart = 19L,
	dispidInsertBefore = 20L,
	dispidInsertAfter = 21L,
	dispidSetCurrentIndex = 22L,
	//}}AFX_DISP_ID
	};
private:
	CStringList m_StringList;
	POSITION m_CurrentPosition;
};
