unit Unit1;

interface

uses
  DualAuto, WinProcs, Dialogs, Ole2;

type
  TDualInterface = class(TAutoObject)
  private
    { Private declarations }
  public
    // Gotta override the TAutoObject constructor
    constructor Create; override;
  automated
    { Automated declarations }
    function Foo(i: Integer): Integer;
    procedure Bar(s: String);
  end;

  // Dual interface dispatch driver!
  TDualDispatch = class(TAutoDispatch)
  public
    // declare new virtual functions ** Must be stdcall!!
    function Foo(i: Integer; var iRet: Integer): HResult; virtual; stdcall;
    function Bar(s: PWideChar): HResult; virtual; stdcall;
  end;


implementation

constructor TDualInterface.Create;
begin
  inherited Create;

  // kludge - destroy the existing TAutoObject and create my own!
  FAutoDispatch.Destroy;
  FAutoDispatch := TDualDispatch.Create(Self);
end;

function TDualInterface.Foo(i: Integer): Integer;
begin
  Result := i + 1;
end;

{*******************************************************************************
  TDualInterface.Bar - 5/15/96 11:52pm
 by:

********************************************************************************}
procedure TDualInterface.Bar(s: string);
begin
  ShowMessage(s);
end; {TDualInterface.Bar}

// The TDualDispatch interface implementation delegates the call to the
// real Foo function!

function TDualDispatch.Foo(i: Integer; var iRet: Integer): HResult;
begin
  // Delegate the call to the real Foo
  iRet := TDualInterface(FAutoObject).Foo(i);
end;

{*******************************************************************************
  TDualDispatch.Bar - 5/15/96 8:11pm
 by: John Lam

********************************************************************************}
function TDualDispatch.Bar(s: PWideChar) : HResult;
begin
  // Delegate the call to the real Bar
  TDualInterface(FAutoObject).Bar(WideCharToString(s));
  Result := S_OK;
end; {TDualDispatch.Bar}

procedure RegisterDaulInterface;
const
  AutoClassInfo: TAutoClassInfo = (
    AutoClass: TDualInterface;
    ProgID: 'Project1.DaulInterface';
    ClassID: '{062C7181-7DF1-11CF-896C-444553540000}';
    IID:     '{062C7182-7DF1-11CF-896C-444553540000}';
    Description: '';
    Instancing: acMultiInstance);
begin
  Automation.RegisterClass(AutoClassInfo);
end;

initialization
  RegisterDaulInterface;
end.