' Windows Scripting Host Script to correct the
' registered owner and company name in the Registry

Dim WSHShell
Set WSHShell = WScript.CreateObject("WScript.Shell")

ChangeOne "RegisteredOwner", "Owner"
ChangeOne "RegisteredOrganization", "Company"

Sub ChangeOne (valName, dispName)
  ' Read the old value from the Registry
  oldValue = WSHShell.RegRead("HKLM\SOFTWARE\Microsoft\" +_
    "Windows\CurrentVersion\" + valName)
  ' Prompt the user to input a new value
  newValue = InputBox("Old Value " + Chr(34) + oldValue + _
    Chr(34), "Change Registered "+dispName, oldValue)
  ' Was any change requested?
  If (newValue <> "") AND (newValue <> oldValue) Then
    ' If so, make the change...
    WSHShell.RegWrite "HKLM\SOFTWARE\Microsoft\Windows\" +_
      "CurrentVersion\"+valName, newValue
    ' ... and report the change
    WSHShell.Popup "Registered " + dispName + " changed " +_
      "from " + Chr(34) + oldValue + Chr(34) + " to " +_
      Chr(34) + newValue + Chr(34)
  Else
    ' If not, report that no change was made
    WSHShell.Popup "No change to registered " + dispName
  End If
End Sub