;PSET - Program to Send Printer Control Codes Entered on
;       the Command Line to the Default Printer (LPT1:)
CSEG    segment para public 'code'
        assume cs:CSEG, ds:CSEG, es:CSEG, ss:NOTHING
        org 100h                        ; .COM Format
PSET    proc
BEGIN:  mov     si,80h                  ; Set SI to location of DOS parameters
        cld                             ; Set direction flag to forward
        lodsb                           ; Get byte count to AX
        cbw                             ; Make it a word
        mov     cx,ax                   ; Move count to CX
        dec     cx                      ; Decrement it to remove blank
        add     si,cx                   ; Add to SI to point to end of string
        std                             ; Set direction flag to reverse
        mov     dx,1234h                ; Set up end-of-stack indicator
        call    MANAGER                 ; Call stack & register manager
LOAD:   lodsb                           ; Get each character in parameter
        cmp     al,20h                  ; Is this a blank?
        jne     MULT                    ; Nope, go convert it to binary
        call    MANAGER                 ; Call stack manager for each character
        loop    LOAD                    ; Loop after blank reached
MULT:   sub     al,30h                  ; Adjust for ASCII character bias
        mul     bl                      ; Multiply AL by BL
        add     dl,al                   ; Add AL to DL
        mov     al,bl                   ; Set up to multiply BL by 0A
        mov     bl,0Ah                  ; (10 decimal) for next (left) char
        mul     bl                      ; Multiply AL by BL
        mov     bl,al                   ; Move result back to BL for next char
LOOP:   loop    LOAD                    ; Loop back to get next character
        call    MANAGER                 ; Call stack manager after last char
CLEAR:  pop     dx                      ; Pop character off stack
        cmp     dx,1234h                ; Is this the end of the stack?
        je      END                     ; Yes, end program
        mov     ah,05h                  ; Set up for DOS printer call
        int     21h                     ; Call DOS
        jmp     CLEAR                   ; Continue clearing stack
END:    int     20h                     ; End program
        PSET    endp
MANAGER proc                            ; Stack and register manager
        pop     bx                      ; Pop IP of stack into BX for a second
        push    dx                      ; Push the DX register onto stack
        push    bx                      ; Now push IP back so return is clean
        mov     bl,1                    ; Store a 1 into BL for mult. right char
        xor     dx,dx                   ; Clear the DX register
        ret                             ; Return to caller
        MANAGER endp
        CSEG    ends
end     BEGIN
                                                                