TITLE   XDEL.ASM   SCANS CURRENT DIRECTORY ALLOWING FILE DELETION.
;                  COMMAND LINE SPECIFIES FILE MATCHING MASK
;
DOS      EQU       21H                             ;DOS  FUNC  INTERRUPT
VIDEO    EQU       10H                             ;BIOS VIDEO INTERRUPT

CSEG     SEGMENT
         ASSUME    CS:CSEG, DS:CSEG, ES:CSEG, SS:CSEG

         ORG       80H
PARM     LABEL     BYTE                            ;UNFORMATTED AREA OF PSP

         ORG       9EH
FNAME    LABEL     BYTE                            ;FILE NAME RETURNED IN DTA
                                                   ; WITHIN PSP BY 4EH CALL
         ORG       100H
ENTRY:   JMP       BEGIN                           ;SKIP OVER DATA

            DB	   "Copyright 1986 Ziff-Davis Publishing Co.",1Ah
APAGE       DB     0                               ;CURRENT VIDEO PAGE
            db     'ATTR='                         ;PATCH POINT TO PRESET
ATTR        DB     0                               ; SCREEN ATTRIBUTE
COUNT       DB     0                               ;COUNT FILE NAMES
DELIM       DB     9,' ,;='                        ;COMMAND LINE DELIMITERS

DRIVE_NO    DB     ?                               ;DISK DRIVE  (0=A, ETC)

DRIVE_SPEC  DB     3 DUP(0)                        ;DRIVE LETTER & ":"
PATH_SPEC   DB     '\',65 DUP(0),0                 ;CURRENT DIRECTORY
                                                   ; FILE NAME MASK
DELETE_PATH DB     14 DUP(0),0                     ;NAME OF FILE TO DELETE
MATCH_PATH  DB     'A:*.*',9 DUP(0),0              ;FILE MATCH STRING

INSTR       DB     13,10,10,'Home - first file match   ',9,9,9
            DB     'PgDn - next file match ',13,10
            DB     'F1   - delete last file shown',9,9,9
            DB     'ESC  - back to DOS',13,10
            DB     80 DUP(205),13,0

HDR         DB     9,9,9,'    DIRECTORY PURGE UTILITY',13,10
            DB     'Current Directory :',13,10,0
PATH_MSG    DB     16,' ',0                        ;RIGHT ARROW
NOT_FOUND   DB     13,10,'File not found',0
BAD_SPEC    DB     13,10,'Invalid drive / file specification',13,10
            DB     'Change directory before using XDEL',0

SPEC_ERROR:
         MOV       DX,OFFSET BAD_SPEC              ;ERROR MSG
         CALL      PRT_ASCIIZ                      ;PRINT ERROR
         INT       20H                             ;RETURN TO DOS

BEGIN:   MOV       AH,8                            ;GET CHAR/ATTR AT CURSOR POS
         INT       VIDEO                           ;BIOS CALL
         MOV       APAGE,BH                        ;BH = ACTIVE PAGE
         CMP       ATTR,0                          ;ATTRIBUTE PRESET?
         JNE       SCAN_CMD                        ;YES, USE SPECIFIED ATTR
         MOV       ATTR,AH                         ;NO, SAVE CURRENT ATTR

;
;SEARCH UNFORMATTED AREA OF PSP FOR FILE NAME SPECIFICATION
;TO USE IN FILE MATCH COMPARISON
;

SCAN_CMD:
         CLD                                       ;SET DIRECTION FLAG
         MOV       SI,1 + OFFSET PARM              ;UNFORMATTED PSP AREA
         MOV       DI,OFFSET DRIVE_SPEC            ;DRIVE SPEC AREA

SKIP_DELIM:
         CALL      PARM_SCAN                       ;GET NEXT PARM BYTE
         JE        SKIP_DELIM                      ;SKIP OVER LEADING DELIMS
         DEC       SI                              ;POINT TO 1ST BYTE OF SPEC

         CMP       AL,13                           ;CARRIAGE RETURN ?
         JZ        GET_DRIVE                       ;YES, NO PARM SPECIFIED

         CMP       BYTE PTR [SI + 1],':'           ;DRIVE SPEC PRESENT?
         JNZ       GET_DRIVE                       ;NO, GET DEFAULT DRIVE

         LODSW                                     ;GET DRIVE AND ":"
         AND       AL,0DFH                         ;CAPITALIZE DRIVE LETTER
         JMP       STORE_DRIVE                     ;SKIP DEFAULT DRIVE CHECK

GET_DRIVE:
         MOV       AH,019H                         ;GET CURRENT DRIVE (0=A,ETC)
         INT       DOS                             ; THRU DOS CALL
         ADD       AL,'A'                          ;CHANGE TO LETTER
         MOV       AH,':'                          ;DRIVE SPEC SEPARATOR

STORE_DRIVE:
         CMP       AL,'A'                          ;VALID RANGE OF DRIVES
         JB        SPEC_ERROR                      ; INVALID DRIVE
         CMP       AL,'Z'
         JA        SPEC_ERROR

         STOSW                                     ;SAVE DRIVE SPEC AND ":"
         MOV       DI,OFFSET DELETE_PATH           ;DELETE RTN PATH
         STOSW                                     ;LOAD DRIVE

         MOV       DI,OFFSET MATCH_PATH            ;FILE MATCHING PATH
         STOSW                                     ;LOAD DRIVE

         SUB       AL,'A'                          ;CHG DRIVE TO NUM (0=A, ETC)
         MOV       DRIVE_NO,AL                     ;SAVE DRIVE

         CMP       BYTE PTR [SI],13                ;CARRIAGE RETURN ?
         JE        GLOBAL_SCAN                     ;YES, SCAN *.*

         MOV       CX,12                           ;MAX LENGTH FILE SPEC
PARSE:
         CALL      PARM_SCAN                       ;GET NEXT PARM BYTE
         JE        PARSE                           ;SKIP DELIMS
         CMP       AL,13                           ;CARRIAGE RETURN?
         JE        END_SPEC                        ;YES, END OF FILE SPEC
         CMP       AL,'\'                          ;PATH SPECIFIED?
         JE        SPEC_ERROR                      ;YES, ERROR

         STOSB                                     ;MOVE BYTE TO MATCH PATH
         DEC       CX                              ;COUNT FILE SPEC LENGTH
         JCXZ      END_SPEC                        ;IF CX = 0, STOP BUILD
         JMP       PARSE

END_SPEC:
         MOV       BYTE PTR [DI],0                 ;TRAILING ZERO

GLOBAL_SCAN:
         CALL      GET_PATH                        ;GET PATH FOR DRIVE SPEC

RESTART:
         CALL      CLR_SCR                         ;CLEAR SCREEN
         MOV       DX,OFFSET HDR                   ;SCREEN TITLE LINE
         CALL      PRT_ASCIIZ                      ; AND PRINT
         MOV       DX,OFFSET PATH_MSG              ;DIRECTORY INFO MSG
         CALL      PRT_ASCIIZ                      ; AND PRINT
         MOV       DX,OFFSET DRIVE_SPEC            ;DRIVE/PATH/FILE
         CALL      PRT_ASCIIZ                      ; AND PRINT
         MOV       DX,OFFSET PATH_SPEC             ;PATH_SPEC
         CALL      PRT_ASCIIZ                      ; AND PRINT
         MOV       DX,OFFSET MATCH_PATH + 2        ;FILE SPEC
         CALL      PRT_ASCIIZ                      ; AND PRINT
         MOV       DX,OFFSET INSTR                 ;INSTRUCTION LINE
         CALL      PRT_ASCIIZ                      ; AND PRINT

         MOV       COUNT,0                         ;INITIALIZE FILE COUNTER
         MOV       DX,OFFSET MATCH_PATH            ;ADDRESS OF SEARCH MATCH
         MOV       CX,0                            ;ATTRIBUTE FOR FILES
         MOV       AH,04EH                         ;FIND FIRST MATCH
         INT       DOS                             ; THRU DOS FUNC CALL
         JC        ERROR_RTN                       ;CARRY SET = ERROR

FILE_LOOP:
         MOV       DX,OFFSET FNAME                 ;POINT TO FILE NAME
         CALL      PRT_ASCIIZ                      ; AND PRINT
                                                   ;CX = FILE NAME LENGTH
         ADD       COUNT,1                         ;INCREMENT COUNT

READ_KYBD:
         CALL      GET_KEY                         ;GET KEY INSTRUCTION
         CMP       AL,27                           ;ESCAPE KEY?
         JE        END_PGM                         ;YES, END PGM
;
; EXTENDED KEY TESTS
;
         CMP       AL,59                           ;FUNC KEY 1?
         JE        DEL_IT                          ;YES, DELETE FILE
         CMP       AL,71                           ;HOME KEY?
         JE        RESTART                         ;YES, RESTART
         CMP       AL,81                           ;PAGE DOWN?
         JE        SKIP_IT                         ;YES, SKIP TO NEXT FILE
         JMP       READ_KYBD                       ;NO, IGNORE KEY
DEL_IT:
         PUSH      CX                              ;SAVE FILE NAME LENGTH
         MOV       SI,OFFSET FNAME                 ;POINT TO FILE NAME
         MOV       DI,OFFSET DELETE_PATH + 2       ;DELETE PATH FILE SPEC
         MOV       CX,13                           ;BYTES TO MOVE
     REP MOVSB                                     ;MOVE FILE NAME
         POP       CX                              ;RESTORE FILE NAME LENGTH

         CALL      DEL_RTN                         ;DELETE FILE
         JC        SOUND_ALARM                     ;CARRY SET - NOT DELETED

         MOV       DL,017                          ;"LEFT POINTER" CHAR
         CALL      PRT_CHAR                        ; AND PRINT
         INC       CX                              ;INCREMENT STRING COUNT
         JMP       SKIP_IT                         ;SKIP TO NEXT FILE

SOUND_ALARM:
         MOV       DL,07                           ;CTRL-G "BEEP" CHAR
         CALL      PRT_CHAR                        ; PRINT
         JMP       READ_KYBD                       ;READ KEYBOARD AGAIN

SKIP_IT:
         CALL      SPACE_FILL                      ;POSITION FOR NEXT NAME
         CALL      NEXT_FILE                       ;FIND NEXT FILE MATCH
         JC        END_PGM                         ;CARRY SET = NO MORE FILES
         CMP       COUNT,80                        ;80 FILE NAMES DISPLAYED?
         JB        FILE_LOOP                       ;NO, SKIP SCROLL
         CALL      SCROLL_HALF                     ;SCROLL HALF OF WINDOW
         SUB       COUNT,40                        ;SUBTRACT 40 FROM FILE COUNT
         JMP       FILE_LOOP                       ;KEEP GOING

ERROR_RTN:
         MOV       DX,OFFSET NOT_FOUND             ;POINT TO MSG
         CALL      PRT_ASCIIZ                      ; AND PRINT
END_PGM:
         INT       20H                             ;RETURN TO DOS

;* * * * * * * * * * S U B R O U T I N E S * * * * * * * * * * * * * * *
;
;GET NEXT PARAMTER BYTE AND COMPARE AGAINST DELIMITER TABLE
;        ZERO FLAG INDICATES BYTE IN AL IS DELIMITER
;

PARM_SCAN:
         PUSH      CX
         PUSH      DI
         LODSB                                      ;GET BYTE AT DS:[SI]
         MOV       DI,OFFSET DELIM                  ;POINT TO DELIM STRING
         MOV       CX,5                             ;LENGTH OF DELIM STRING
   REPNE SCASB                                      ;SCAN DELIM UNTIL CX=0
                                                    ; OR AL=DS:[DI]
         POP       DI
         POP       CX
         RET

;
;GET CURRENT DIRECTORY PATH FOR DRIVE SPECIFIED
;

GET_PATH:
         PUSH      SI                              ;SAVE INDEX TO COMMAND LINE
         MOV       AH,047H                         ;GET CURRENT DIRECTORY
         MOV       DL,DRIVE_NO                     ;GET DRIVE NUMBER (0=A,ETC)
         INC       DL                              ;DL = (0=DEFAULT, 1=A, ETC)
         MOV       SI,OFFSET PATH_SPEC + 1         ;SAVE DIRECTORY TO DS:[SI]
         INT       DOS                             ;DOS CALL

         SUB       AL,AL                           ;ASCIIZ ZERO BYTE
         CMP       [SI],AL                         ;CHECK IF ROOT DIR
         JZ        ROOT_DIR                        ;IF SO, SKIP SEARCH

         MOV       DI,SI                           ;SCAN PATH FOR HEX 0
         MOV       CX,64                           ;BYTES TO SEARCH
   REPNZ SCASB                                     ;DO SEARCH FOR TRAILING ZERO
         DEC       DI                              ;DI POINTS TO END ZERO
         MOV       AL,'\'                          ;OVERLAY WITH BACK SLASH
         STOSB                                     ;APPEND TO PATH
ROOT_DIR:
         POP       SI                              ;RESTORE INDEX
         RET

;
;FINDS NEXT FILE NAME WHICH MATCHES MASK
;
NEXT_FILE:
         PUSH      CX
         MOV       DX,OFFSET MATCH_PATH            ;ADDRESS OF MATCH STRING
         MOV       CX,0                            ;ATTRIBUTE FOR FILES
         MOV       AH,04FH                         ;FIND NEXT MATCH
         INT       DOS                             ;DOS FUNC CALL
         POP       CX
         RET
;
;SPACES OUT FILE NAME TO LENGTH OF 16 BYTES (FIVE NAME PER LINE)
;
SPACE_FILL:
         CMP       CX,16                           ;PRINTED 16 BYTES?
         JAE       SPC_EXIT                        ;YES, EXIT
         MOV       DL,' '                          ;NO, PRINT SPACE AFTER NAME
         CALL      PRT_CHAR                        ;PRINT CHAR
         INC       CX                              ;INCREMENT CX (STRING COUNT)
         JMP       SPACE_FILL                      ;KEEP GOING
SPC_EXIT:
         RET
;
;PRINTS ASCIIZ STRING POINTED TO BY DS:DX
;  CX RETURNS NUMBER OF BYTES PRINTED
;
PRT_ASCIIZ:
         PUSH      SI
         PUSH      DX
         SUB       CX,CX                           ;INIT BYTE COUNT
         MOV       SI,DX                           ;SET SOURCE INDEX
ASC_LOOP:
         MOV       DL,BYTE PTR [SI]                ;POINT TO CHAR IN ASCIIZ
         CMP       DL,0                            ;FOUND TRAILING ZERO?
         JZ        ASC_EXIT                        ;YES, EXIT
         CALL      PRT_CHAR                        ;NO, PRINT CHAR
         INC       SI                              ;POINT TO NEXT BYTE
         INC       CX                              ;INCR BYTES PRINTED
         JMP       ASC_LOOP                        ;KEEP GOING
ASC_EXIT:
         POP       DX
         POP       SI
         RET
;
;PRINTS CHARACTER IN DL
;
PRT_CHAR:
         PUSH      AX
         MOV       AH,2                            ;PRINT CHAR IN DL
         INT       DOS                             ;DOS FUNC CALL
         POP       AX
         RET
;
; ACCEPT ONLY ESCAPE, AND ALL EXTENDED KEY CODES
;
GET_KEY:
         MOV       AH,0                            ;GET NEXT KEYBOARD CHAR
         INT       16H                             ;BIOS CALL
         CMP       AL,27                           ;ESCAPE KEY?
         JE        GET_EXIT                        ;YES, EXIT

         CMP       AL,0                            ;EXTENDED KEY?
         JNZ       GET_KEY                         ;NO, IGNORE
         XCHG      AH,AL                           ;SWAP SCAN CODE INTO AL

GET_EXIT:
         RET
;
;DELETES FILE NAME IN FIELD "FNAME"
;    CARRY FLAG SET   - FILE COULD NOT BE DELETED
;    CARRY FLAG CLEAR - FILE WAS SUCCESFULLY DELETED
;
DEL_RTN:
         MOV       DX,OFFSET DELETE_PATH           ;POINT TO DELETE PATH
         MOV       AH,041H                         ;DELETE FILE FUNC
         INT       DOS                             ;DOS CALL
         RET
;
;CLEARS ENTIRE SCREEN AND POSITIONS CURSOR IN UPPER LEFT CORNER
;
CLR_SCR:
         MOV       AH,2                            ;SET CURSOR POSITION
         MOV       BH,APAGE                        ;SET CURR PAGE
         MOV       DX,0                            ; UPPER LEFT CORNER
         INT       VIDEO                           ;BIOS CALL

         MOV       BH,ATTR                         ;ATTRIBUTE TO BH
         MOV       AX,0600H                        ;SCROLL UP BIOS FUNC
         MOV       CX,0                            ;UPPER LEFT WINDOW CORNER
         MOV       DX,1850H                        ;LOWER RIGHT CORNER 24 X 80
         INT       VIDEO                           ;BIOS CALL
         RET
;
;SCROLLS TOP HALF OF FILE DISPLAY AREA AND POSITIONS CURSOR ON BLANK LINE
;
SCROLL_HALF:
         MOV       AH,2                            ;SET CURSOR POSITION
         MOV       BH,APAGE                        ;SET CURR PAGE
         MOV       DX,0F00H                        ;PUT CURSOR ON LINE 15
         INT       VIDEO                           ;BIOS CALL

         MOV       BH,ATTR                         ;ATTRIBUTE TO BH
         MOV       AX,0608H                        ;SCROLL UP EIGHT LINES
         MOV       CX,0700H                        ;UPPER LEFT CORNER OF WINDOW
         MOV       DX,1850H                        ;LOWER RIGHT CORNER 24 X 80
         INT       VIDEO                           ;BIOS CALL
         RET

CSEG     ENDS
         END    ENTRY
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        