    /* setbit() - turn ON bit n in bitmap    */
void setbit(unsigned char *bitmap, unsigned n)
{
    bitmap[n/8] |= (1 << (n % 8));
}

    /* resetbit() - turn OFF bit n in bitmap */
void resetbit(unsigned char *bitmap, unsigned n)
{
    bitmap[n/8] &= (~(1 << (n % 8)));
}

    /* isbitset() - returns TRUE if bit n is ON, else FALSE */
int isbitset(unsigned char *bitmap, unsigned n)
{
    return (bitmap[n/8] & (1 << (n % 8)));
}

    /***** macro versions *************/
#define setbit(bitmap,n)    (bitmap[n/8] |= (1 << (n % 8)))
#define resetbit(bitmap,n)    (bitmap[n/8] &= (~(1 << (n % 8))))
#define isbitset(bitmap,n)    ((bitmap[n/8] & (1 << (n % 8))))
