PROGRAM Self_Modify;          { Compile to a .COM file before execution }

CONST
  StoredValue : STRING[80] = 'initial value of stored string';
  ProgramName : STRING[64] = 'SELFMOD.COM';

VAR
  F : FILE OF Byte;
  I : Integer;

BEGIN
  Assign(F, ProgramName);     { open .COM file }
  {$I-} Reset(F); {$I+}
  IF IOResult = 0 THEN        { check for i/o error }
    BEGIN
      {$I-} Seek(F, Ofs(StoredValue)-$100);
      {$I+}                   { get location of StoredValue }
      IF IOResult <> 0 THEN   { (a typed constant) in Cseg  }
        BEGIN
          WriteLn('Seek failed.');
          Close(F);
          Halt(1);            { abort with ErrorLevel=1 }
        END;
      WriteLn('Stored value was ->', StoredValue, '<-');
      Write('Enter new value  ->'); Read(StoredValue); WriteLn('<-');
      FOR I := Ofs(StoredValue) TO Ofs(ProgramName) DO
                               { write new value of    }
        Write(F, Mem[CSeg:I]); { StoredValue into file }
      Close(F);
    END
  ELSE
    BEGIN
      WriteLn('Could not open file ',ProgramName);
      Halt(2);                 { abort with ErrorLevel=2 }
    END;
END.
