;----------------------------------------------------------------------
;  CTRLCAP - Reverse the CapsLock and Ctrl key on left side.
;       MASM CTRLCAP;
;       LINK CTRLCAP;
;       EXE2BIN CTRLCAP.EXE CTRLCAP.COM
;----------------------------------------------------------------------
CSEG    SEGMENT PARA PUBLIC 'CODE'
        ASSUME  CS:CSEG                         ;Not sure of DS when resident

                ORG     100H                    ;SKIP TO END OF THE PSP
ENTPT:          JMP     SHORT INITIALIZE        ;COM FILE ENTRY ALWAYS AT 100H

        ;Change these codes to change two other keys
CTRL_DN         EQU     01DH                    ;Make for Ctrl
CAP_DN          EQU     03AH                    ;Make for CapsLock

COPYRIGHT       DB      "CTRLCAP 1.0 (c) 1988, Ziff Communications Corp."
                DB      13,10,"PC Magazine ",254," Robert L. Hummel"

NEW_INT         PROC    FAR                     ;Here is the new interrupt

                PUSHF                           ;Save flags
                CMP     AH,04FH                 ;If Kbd intercept fn
                JE      SWAP_0                  ; jump
                POPF                            ;Restore flags
                JMP     SHORT SPLICE            ;Continue to original
SWAP_0:
                POPF                            ;Discard flags
                PUSH    AX                      ;Save scan code
                AND     AL,07FH                 ;Eliminate high bit

                CMP     AL,CTRL_DN              ;If not Ctrl key
                JNE     SWAP_1                  ; jump

                POP     AX                      ;Restore scan code
                ADD     AL,(CAP_DN-CTRL_DN)     ; and change to other value
                JMP     SHORT SWAP_EXIT         ;Leave
SWAP_1:
                CMP     AL,CAP_DN               ;If not CapsLock
                POP     AX                      ; (restore scan code)
                JNE     SWAP_EXIT               ; then process normal

                SUB     AL,(CAP_DN-CTRL_DN)     ; else adjust value
SWAP_EXIT:
                STC                             ;Carry on=keep keystroke
SPLICE:
                DB      0EAH                    ;JMP FAR
OLD_INT         DD      0                       ; old interrupt 15h

NEW_INT         ENDP

;======================================================================
;       Initialization Procedure
;----------------------------------------------------------------------
INITIALIZE      PROC    NEAR
                ASSUME  DS:CSEG                 ;Set by loader.

                MOV     AH,9                    ;Display string fn
                MOV     DX,OFFSET COPYRIGHT
                INT     21H

                MOV     AX,3515H                ;Get current interrupt 15h
                INT     21H                     ;Result in ES:BX

                MOV     WORD PTR OLD_INT[0],BX  ;Save offset
                MOV     WORD PTR OLD_INT[2],ES  ;Save segment

                MOV     AX,2515H                ;Set interrupt 15h
                MOV     DX,OFFSET NEW_INT       ;Load DS:DX with our interrupt
                INT     21H

                MOV     AX,3100H                ;Terminate & stay resident
                MOV     DX,(OFFSET INITIALIZE-OFFSET CSEG + 15) SHR 4
                INT     21H

INITIALIZE      ENDP

CSEG    ENDS
        END     ENTPT
