; COMMON.INC
; (c) 1989, 1990 Ashok P. Nadkarni
;
; Common definitions for CMDEDIT

	IFNDEF	TSR
TSR		equ	1		;1 if we should TSR. If 0,
;					 used for debugging without TSRing
	ENDIF

STACK_SIZE 	equ	768		;Stack size after TSR'ing

LINEBUF_SIZE	equ	256		;Max size of line storage
;					 buffer. Do NOT change this
;					 since applications can specify
;					 buffers upto this size.

; Min size for various string stack buffers
DOSSIZE_MIN	equ	4		;DOS history, 2 for sentinel +
;					 2 for top of history sentinel
MACROSIZE_MIN	equ	5		;Macro buffer, 2 for sentinel +
;					 3 for separator
SYMSIZE_MIN	equ	5		;Symbol buffer, same as MACROSIZE_MIN
DIRSIZE_MIN	equ	2		;Directory stack, 2 for sentinel

TOGGLE_CURSOR	equ	1		;toggle cursor between 
;					 overwrite and insert modes

; Error codes for routine abort_processing. These codes must be in the
; same order as the error messages in table abort_msg_table in cmdedit.asm
E_TRUNCATE	equ	0		;Line too long
E_SIGNAL	equ	1		;User signal received
E_DIRSTK_EMPTY	equ	2		;Empty directory stack
E_DIRSTK	equ	3		;Other dir stack error
E_DIRSTK_DOS	equ	4		;Directory stack only for DOS
E_NESTED_MACRO	equ	5		;Nested macro def
E_NESTED_DELM	equ	6		;delm inside a macro
E_CTRL_BREAK	equ	7		;Ctrl-Break received

VAR_MARKER	equ	'%'
