/*+
    Name:	hldesc.c
    Date:	22-May-1988
    Author:	Kent J. Quirk
		(c) Copyright 1988 Ziff Communications Co.
    Abstract:	Allows user to describe the machine being tested.
    History:	09-Sep-88   kjq     Version 1.00
-*/

#include <stdio.h>
#include <stdlib.h>
#include <graph.h>
#include "hltimes.h"
#include "winmenu.h"

void usage()
{
	printf("Usage:  HLDESC [-pprog] -ffirst\n");
	printf("   Allows entry of descriptive data in the file\n");
	printf("   data in the file specified in the -f switch.\n");
	printf("   Normally, prog defaults to zero, but specifying it\n");
	printf("   will allow you to edit other descriptions as well.\n");
	exit(1);
}


#define MAXROW 8
#define LEFTEDGE 8
#define TOPROW 8

main(argc, argv)
int argc;
char *argv[];
{
    int origfg;
    long origbg;
    int i;
    int prog = 0;
    TIME_REC tr[8], *trp;
    char *text[8];
    char *f1;
    int c;
    int row;
    WINDOW *w;

    for (i=1; i<argc; i++)
    {
	if (argv[i][0] != '-')
	    usage();

	switch(tolower(argv[i][1])) {
	case 'p':
	    prog = atoi(argv[i]+2);
	    break;
	case 'f':
	    if (argv[i][2] != 0)
		f1 = argv[i]+2;
	    else
		f1 = NULL;
	    break;
	case 's':
	case 'a':		    /* ignore "batch" & "bench" modes */
	case 'b':
	    break;
	default:
	    printf("Invalid argument '%s'\n", argv[i]);
	case '?':
	    usage();
	}
    }
    
    if (f1 == NULL)
	usage();

    opentime(f1);
    for (i=0; i<MAXROW; i++)
    {
	trp = readtime(prog, i);
	if (trp == NULL)
	{
	    printf("Failure trying to read description data!\n");
	    exit(2);
	}
	tr[i] = *trp;
	text[i] = tr[i].desc;
    }
    closetime();

    origfg = _gettextcolor();               /* get default colors */
    origbg = _getbkcolor();
    w = draw_menu(text, "Describe current machine", 
	    "Use cursor keys to edit, F10 to finish, ESC to cancel.",
		    MAXROW, TOPROW, LEFTEDGE, sizeof(trp->desc));

    row = 0;
    for(;;)
    {
	switch (c = edit_line(text[row], sizeof(trp->desc)-1,
		    TOPROW+row, LEFTEDGE)) {
	case UP:
	case BACKTAB:
	    if (--row < 0)
		row = MAXROW-1;
	    break;
	case DOWN:
	case TAB:
	case DOIT:
	    if (++row >= MAXROW)
		row = 0;
	    break;
	case ESC:
	    close_window(w);
	    return(0);
	    break;
	case F10:
	    opentime(f1);
	    for (i=0; i<MAXROW; i++)
	    {
		tr[i].ticks = -2;
		savetime(prog, i, &tr[i]);
	    }
	    closetime();

	    close_window(w);
	    _settextcolor(origfg);
	    _setbkcolor(origbg);
	    return(0);
	    break;

	default:
	    break;
	}
    }
}
