
#include <stdio.h>

#include "luthor.h"
#include "basicdef.h"
#include "basictab.h"

char *tokenstring(int n);

int main(int argc,char **argv)
{
	int lextable,lexstream,t;

	if(argv[1]==NULL){
    	fprintf(stderr,"No input file name supplied\n");
        exit(1);
	}
    
    LexInit(0);		/* initialize the lex processor */
    lextable=LexSetObject(&BASICObject);
	if(lextable==LXE_ERROR){
    	fprintf(stderr,"Lex error %d\n",lexerror);
        exit(1);
	}
	
    lexstream=LexInputFile(lextable,argv[1]);
    if(lexstream==LXE_ERROR){
    	fprintf(stderr,"Lex error %d\n",lexerror);
        exit(1);
	}
    
    while((t=ThisToken(lexstream)) != EOF){
    	if(!t){
        	printf("token error!\n");
            exit(1);
		}
    	printf("%d\t ",t);
    	if(t==TK_EOL){
        	printf("\\n\t");
		} else {
        	printf("%s\t",ThisTokenText(lexstream));
		}
        printf("%s\n",tokenstring(t));
        if(!AdvanceToken(lexstream)){
        	printf("token error!\n");
            exit(1);
		}
	}
    printf("EOF\n");
    exit(0);
}

