
/* ---------------------------------------------------------------------*/
/*									*/
/*	MOUKEY v1.0 for C/C++						*/
/*	Keyboard routines						*/
/*									*/
/*	KEY.H: header file						*/
/*									*/
/*	May 1997							*/
/*									*/
/*	Copyright (c) 1997 Tanescu A. Horatiu				*/
/*									*/
/* ---------------------------------------------------------------------*/

#if !defined (__KEY_H)
#define __KEY_H

/* Macros used to work with key codes
 */

#define ASCIICODE(key)		((unsigned char)(key))
#define SCANCODE(key)		((unsigned char)(((unsigned int)(key) >> 8) & 0xFF))
#define MAKEKEY(ascii, scan)	((unsigned int)(((unsigned char)(ascii)) | \
				(((unsigned int)((unsigned char)(scan))) << 8)))
#define ISEXTENDED(key)		((!(unsigned char)key) || ((unsigned char)key == 0xE0))

#ifdef __cplusplus
extern "C" {
#endif

int  getkey(void);
int  checkkey(void);
int  shiftstatus(void);
void settypematic(unsigned char rate, unsigned char delay);
int  ungetkey(int key);
int  egetkey(void);
int  echeckkey(void);
int  eshiftstatus(void);

#ifdef __cplusplus
}
#endif

#ifdef __cplusplus

#include <dos.h>

int inline _getkey(void)
{
  _AH = 0x00; __emit__(0xcd, INT_BIOSKBD);
  return (_AX);
}

int inline _checkkey(void)
{
  _AH = 0x01; __emit__(0xcd, INT_BIOSKBD, 0x75, 0x02, 0x31, 0xC0);
  return (_AX);
}

int inline _shiftstatus(void)
{
  _AH = 0x02; __emit__(0xcd, INT_BIOSKBD);
  _AH = 0x00;
  return (_AX);
}

int inline _ungetkey(int key)
{
  _AH = 0x05; _CX = key; __emit__(0xcd, INT_BIOSKBD);
  return (_AX);
}

int inline _egetkey(void)
{
  _AH = 0x10; __emit__(0xcd, INT_BIOSKBD);
  return (_AX);
}

int inline _echeckkey(void)
{
  _AH = 0x11; __emit__(0xcd, INT_BIOSKBD, 0x75, 0x02, 0x31, 0xC0);
  return (_AX);
}

int inline _eshiftstatus(void)
{
  _AH = 0x12; __emit__(0xcd, INT_BIOSKBD);
  return (_AX);
}
#endif // __cplusplus

#endif // __KEY_H