/****************************************************************/
/*								*/
/* 	RX_PROC.C : A demonstration of IPC usage for a		*/
/*		    Receiving process				*/
/*								*/
/*   Copyrighted (c) 1989 Donnelly Software Engineering.	*/
/*								*/
/*	Refer to the comment block in TX_PROC.C for examples	*/
/*	illustrating compiling and linking.			*/
/*								*/
/****************************************************************/


#include <stdio.h>		/* standard i/o routines */
#include "pc-ipc.h"		/* contains defines and typedef */

main()				/* start of main program */
{

    char my_data[128];		/* a 128-byte data buffer */
    IPC_PARAM_BLOCK p_block;	/* a variable of type IPC_PARAM_BLOCK */
    unsigned int proc_1_id = 0;	/* storage for process ids */
    unsigned int proc_2_id;
    unsigned int read_cmnd;	/* read and wait if DV running */


/* determine if IPC is installed at the default vector */
	if ( !pc_ipc_installed(IPC_VECTOR) )
	    ipc_error(IPC_ERR_NOTINST);

/* Is there is a message for process 0? If so, then TX_PROC has already run */
	init_param_block(&p_block, proc_1_id, 0, IPC_CMND_INQUIRE, 0, 0L);
	pc_ipc(IPC_VECTOR, &p_block);

	if (( !p_block.error ) && (p_block.status & IPC_STAT_AVDATA))
	    {
	    init_param_block(&p_block, proc_1_id, 0, IPC_CMND_RDATA, 0,
						(void far *)(&proc_2_id));
	    pc_ipc(IPC_VECTOR, &p_block);

	    if ( p_block.error )
		ipc_error(p_block.error);

	    read_cmnd = IPC_CMND_RDATA;
	    }

/* No, get a second process id and send it to process 0 for TX_PROC to find */
	else
	    {
	    init_param_block(&p_block, 0, 0, IPC_CMND_REQID, 0, 0L);
	    pc_ipc(IPC_VECTOR, &p_block);

	    if ( p_block.error )	/* terminate if no ids left */
		ipc_error(p_block.error);

	    proc_2_id = p_block.my_id;
					/* send the new id to process 0 */
	    init_param_block(&p_block, proc_2_id, proc_1_id, IPC_CMND_SDATA,
			sizeof(unsigned int), (void far *)(&proc_2_id));
	    pc_ipc(IPC_VECTOR, &p_block);

	    if ( p_block.error )
		ipc_error(p_block.error);

	    read_cmnd = IPC_CMND_RDATAW;
	    }

/* Initialize the parameter block and retieve a message */
	init_param_block (&p_block, proc_2_id, 0, read_cmnd, 0, &my_data);
	pc_ipc(IPC_VECTOR, &p_block);

	if ( p_block.error )
	    ipc_error(p_block.error);

/* If a message was received, print it */
	if (p_block.status && IPC_STAT_AVDATA)
	    {
	    printf("Process-%d received %d bytes of data from Process-%d\n",
				p_block.my_id, p_block.size, p_block.to_id);
	    printf("\"%s\"\n", p_block.data_ptr);
	    }

	else
	  printf("No data available for Process-%d\n", p_block.my_id);

/* relinquish the process id if one was allocated */
	if (read_cmnd == IPC_CMND_RDATAW)
	    {
	    init_param_block(&p_block, proc_2_id, 0, IPC_CMND_DELID, 0, 0L);
	    pc_ipc(IPC_VECTOR, &p_block);
	    }

}	/* end of procedure main */
