{
    The RunTime to Pascal include file convertor.
    Copyright (C) Sandul Yura Valentinovich.
    (R) Wednesday, 5 March 2003 year.
    All rights reserved.
    This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your option) any
later version.
    This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
details.
    You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc., 675
Mass Ave, Cambridge, MA 02139, USA.
}
{=$A-,B+,D-,E-,F-,G-,I-,L-,N-,O-,P+,Q-,R-,S-,T-,V-,X-,Y-}
{=$M 65520,0,0}
Program RunTimeToPascal;
Var
  RunTimeFile : File;
  PascalFile  : Text;
  Buffer      : Byte;
  Count       : LongInt;
  Line        : String;
Begin
 Assign(RunTimeFile,'RunTime.Exe');
 Assign(PascalFile,'RunTime.Inc');
 ReSet(RunTimeFile,1);
 ReWrite(PascalFile);
 Str(FileSize(RunTimeFile),Line);
 WriteLn(PascalFile,'Const');
 WriteLn(PascalFile,'    RunTime : Array[1..'+Line+'] Of Byte = (');
 Line:='';
 Repeat
  BlockRead(RunTimeFile,Buffer,1,Count);
  If Count=0 Then Break;
  Line:=Line+'$'+HexStr(Buffer,2)+',';
  If Length(Line)=76 Then
  Begin
   WriteLn(PascalFile,Line);
   Line:='';
  end;
 Until False;
 If Line<>'' Then WriteLn(PascalFile,Copy(Line,1,Length(Line)-1)+');');
 Close(RunTimeFile);
 Close(PascalFile);
end.