//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVCOMBO.CPP                          |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Combo-box implementation             |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

#define uses_string
#define uses_colors
#define uses_combo
#define uses_dc
#define uses_dialog
#define uses_icons
#define uses_label
#define uses_lines
#define uses_system

#include "PVuses.h"

static Tcombo_list *combo_list = NULL;
static Tcombo *combo = NULL;

//Tprompt_item publics:

Tprompt_item::Tprompt_item( char *_prompt, int _xl ):
  Titem( _xl, 1 )
{
  prompt_len = 0;
  if( ( _prompt != NULL ) && *_prompt )
  {
    prompt_len = (char) ( smart_len( _prompt ) + 1 );
    put_in( NEW( Tlabel( _prompt, this ) ), -prompt_len, 0 );
  }
}

//Tcombo_item publics:

Tcombo_item::Tcombo_item( char *_prompt, int _xl ):
  Tprompt_item( _prompt, _xl ),
  Tlb_list()
{
}

Tcombo_item::Tcombo_item( char *_prompt, int _xl, Tlb_list *_list ):
  Tprompt_item( _prompt, _xl ),
  Tlb_list( _list )
{
}

//Tcombo_list publics:

Tcombo_list::Tcombo_list( uint &_data, int _xl, int _max_print, Tlb_list *_list ):
  Tlist_box( _data, _xl, _max_print, _list )
{
  if( i_sb_up_len==1 ) v_bar->drag( v_bar->x - 1, v_bar->y );
  set_state( isON_TOP, 1 );
  at( _data );
}

Tcombo_list::~Tcombo_list( void )
{
  combo_list = NULL;
}

//Tcombo_list protected

void Tcombo_list::set_palette( void )
{
  Tlist_box::set_palette();
  text_attr = pal_menus.normal;
  selected_attr = pal_menus.selected;
  disabled_attr = pal_menus.disabled;
}

boolean Tcombo_list::release_focus( void )
{
  if( Tlist_box::release_focus() ) return combo_list == NULL;
  return 0;
}

void Tcombo_list::event_handler( Tevent &ev )
{
  Tlist_box::event_handler( ev );
  switch( ev.code )
  {
#ifndef NOMOUSE
    case evMOUSE_UP:
      if( ev.INSIDE )
      {
        combo->set_index();
        combo->close_combo();
      }
      handled( ev );
      break;
    case evMOUSE_DOWN:
      if( !ev.INSIDE )
      {
        while( get_mouse(ev,0) );
        combo->close_combo();
      }
    case evMOUSE_REP:
      handled( ev );
      break;
#endif
    case evKEY_PRESS:
      switch( ev.ASCII )
      {
        case kESC:
          handled( ev );
          combo->close_combo();
          break;
        case kENTER:
          handled( ev );
          combo->set_index();
          combo->close_combo();
      }
  }
}

//Tcombo publics:

Tcombo::Tcombo( void ):
  Ticon( i_combo_closed, 0, 0 )
{
  open_yl = __combo_lines();
  open = 0;
}

void Tcombo::open_combo( void )
{
  int a, b;

  if( open ) return;
  set_title( i_combo_open );
  combo_list = init_combo_list();
  owner->owner->put_in( combo_list, owner->x + owner->xl - open_xl, owner->y + 1 );
  combo_list->make_global( 0, combo_list->yl, a, b);
  if( ( b + (char) ( combo_list->hsize > open_xl ) ) > scr_rows )
  {
    combo_list->drag( combo_list->x, owner->y - open_yl );
    combo_list->h_bar->drag( i_sb_left_len, -1 );
  }
  combo = this;
  open = 1;
  redraw();
}

void Tcombo::close_combo( void )
{
  Tcombo_list *c;

  if( open && ( combo_list != NULL ) )
  {
    set_title( i_combo_closed );
    c = combo_list; combo_list = NULL;
    owner->focus();
    DELETE( c );
    combo = NULL;
    open = 0;
    owner->owner->redraw();
  }
}

void Tcombo::set_index( void )
{
  ( (Tcombo_item *) owner )->set_data( combo_list->vcurrent );
}

void Tcombo::get_index( void )
{
  char s[256];

  ( (Tcombo_item *) owner )->get_data( s );
  ( (Tcombo_item *) owner )->add( s );
}

//Tcombo protected:

void Tcombo::initialize( void )
{
  Ticon::initialize();
  open_xl = owner->xl;
}

void Tcombo::event_handler( Tevent &ev )
{
  if( owner->state( isFOCUSED ) && ( ev.code == evKEY_PRESS ) && ( ev.ASCII == kDOWN ) && !open )
  {
    open_combo();
    redraw();
    handled( ev );
  }
  else
    Ticon::event_handler( ev );
}

void Tcombo::press( void )
{
  if( open ) close_combo(); else open_combo();
}

Tcombo_list * Tcombo::init_combo_list( void )
{
  return NEW( Tcombo_list(
    ( (Tcombo_item *) owner )->vcurrent,
    open_xl - i_sb_up_len,
    open_yl,
    (Tcombo_item *) owner)
  );
}

//Tcombo_box publics:

Tcombo_box::Tcombo_box( char *_prompt, uint &_data, int _xl ):
  Tcombo_item( _prompt, _xl + 2 )
{
  init( _data );
}

Tcombo_box::Tcombo_box( char *_prompt, uint &_data, int _xl, Tlb_list *_list ):
  Tcombo_item( _prompt, _xl + 2, _list )
{
  init( _data );
}

Tcombo_box::~Tcombo_box( void )
{
  if( data_txt != NULL ) FREE( data_txt );
}

uint Tcombo_box::cursor( void )
{
  return data_num;
}

void Tcombo_box::set_data( uint i )
{
  char s[256];

  gettxt( i, s );
  if( data_txt != NULL ) FREE( data_txt );
  data_txt = STRDUP( s );
  data_num = i;
  at( i );
  item_acted = this;
}

void Tcombo_box::get_data( char *s )
{
  strcpy( s, data_txt );
}

//Tcombo_box protected:

void Tcombo_box::draw( void )
{
  char mp, ta;
  char d[256];

#ifndef HGR
  if( !graph_flag )
  {
    selected_attr = rolb( selected_attr, 4 );
    text_attr = rolb( text_attr, 4 );
    bold_attr &= 0x0F;
    disabled_attr &= 0x0F;
    bold_attr |= (char) ( text_attr & 0xF0 );
    disabled_attr |= (char) ( text_attr & 0xF0 );
  }
#endif
  mp = (char) ( xl - 2 );
  direct_txt( i_left_line );
  ta = text_attr;
  if( state( isDISABLED ) )
    text_attr = disabled_attr;
  else
    if( state( isSELECTED ) )
      text_attr = bold_attr;
  strcpy( d, data_txt );
  d[mp] = 0;
  direct_txt( d );
  if( strlen( data_txt ) < mp ) mp -= strlen( data_txt ); else mp = 0;
  txtf( "|r%c ", mp );
  text_attr = ta;
  direct_txt( i_right_line );
}

void Tcombo_box::event_handler( Tevent &ev )
{
  Tcombo_item::event_handler( ev );
  switch( ev.code )
  {
    case evCOMMAND:
      switch( ev.CMD_CODE )
      {
        case cmDLG_RESET:
          set_data( data_num );
          break;
        case cmLABEL_FOCUSED:
          if( state( isFOCUSED ) )
          {
            combo->open_combo();
            handled( ev );
          }
          break;
      }
      break;
    case evMOUSE_UP:
      if( ev.INSIDE && state(isFOCUSED) )
      {
        combo->open_combo();
        handled( ev );
      }
      break;
  }
}

void Tcombo_box::ok_item( void )
{
  *dta = data_num;
}

//Tcombo_box private:

void Tcombo_box::init( uint &_data )
{
  combo = NEW( Tcombo );
  put_in( combo, xl, y );
  data_txt = NULL;
  data_num = _data;
  dta = &_data;
  put_in( NEW( Tline0( xl ) ), 0, 1 );
  put_in( NEW( Tline1( xl ) ), 0, -1 );
}

//PREFIXES

static int clines_ = 0;

/*
  Description:
    Specify open combo size. Call just before construct a combo item.
  Entry:
    cl - number of combo lines, default = 6.
*/
void _combo_lines( int cl )
{
  if( !clines_ ) clines_ = cl;
}

int __combo_lines( void )
{
  int result = 6;

  if( clines_ ) result = clines_;
  clines_ = 0;
  return result;
}

//CONSTRUCTORS FOR USE WITH DIALOG BOXES

static void put_combo_box( Tcombo_box *c )
{
  hspaces( c->prompt_len );
  put_item( c, c->xl + i_combo_open_len + 1, 2 );
  if( !fill() ) hspaces( -c->prompt_len );
}

/*
  Description:
    Construct combo box and insert it in the dialog box.
  Entry:
    t    - title, shortcut prefix '|~';
    data - buffer that holds current selection;
    _xl  - size of the combo box.
  Exit:
    Return pointer to the combo box.
*/
Tcombo_box *combo_box( char *t, uint &data, int _xl )
{
  Tcombo_box *c;

  c = NEW( Tcombo_box( t, data, _xl ) );
  put_combo_box( c );
  return c;
}

/*
  Description:
    Construct combo box and associate it with previously constructed
    list of items.
  Entry:
    t    - title, shortcut prefix '|~';
    data - buffer that holds current selection;
    _xl  - size of the combo box.
    _list- pointer to previously constructed list.
  Exit:
    Return pointer to the combo box.
*/
Tcombo_box *combo_box( char *t, uint &data, int _xl, Tlb_list *_list )
{
  Tcombo_box *c;

  c = NEW( Tcombo_box( t, data, _xl, _list ) );
  put_combo_box( c );
  return c;
}

/*
  Description:
    Construct text combo box and insert it in the dialog box.
  Entry:
    t    - title, shortcut prefix '|~';
    data - buffer that holds current string;
    len  - maximum valid length of the output string;
    size - number of characters to be displayed - size of the text edit box.
  Exit:
    Return pointer to the text combo box.
*/
/*
Tcombo *tcombo_box( char *t, char *data, int len, int size )
{
  Tcombo *c;
  Tinput *i;

  i = NEW( Tinput( t, data, len, size ) );
  c = NEW( Tcombo );
  i->put_in( c, size + 3, 0 );
  _input( i );
  local.x += i_combo_open_len;
  lwith( c );
  return c;
}
*/
