//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVCHECK.H                            |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Check-boxes & radio-buttons interface|
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

#ifndef _PVCHECK_H
#define _PVCHECK_H
class Tcluster: public Titem
{
  public:
    Tcluster( char *_prompt );
    virtual ~Tcluster( void );
    void set_prompt( char *_prompt );
    virtual void press( void ) = 0;
    virtual void press( boolean state ) = 0;
    virtual boolean pressed( void ) = 0;

  protected:
    uint shortcut;
    char *prompt;
    virtual void event_handler( Tevent &ev );
    void draw_cluster( char *box );
};

class Tcheck: public Tcluster
{
  public:
    Tcheck( char *_prompt, boolean &_data );
    virtual void press( void );
    virtual void press( boolean state );
    virtual boolean pressed( void );

  protected:
    boolean data;
    boolean *data_ptr;
    virtual void draw( void );
    virtual void ok_item( void );
};

class Tcheckb: public Tcheck
{
  public:
    boolean tmp_data;
    Tcheckb( char *_prompt, uint &_data, uint _bit );

  protected:
    uint bit;
    uint *_data_ptr;
    virtual void ok_item( void );
};

class Tcheckw: public Tcheck
{
  public:
    boolean tmp_data;
    Tcheckw( char *_prompt, word &_data, uint _bit );

  protected:
    uint bit;
    word *_data_ptr;
    virtual void ok_item( void );
};

class Tradio: public Tcluster
{
  public:
    int data;
    Tradio( char *_prompt, int &_data, int _value );
    virtual void press( void );
    virtual void press( boolean state );
    virtual boolean pressed( void );

  protected:
    int *data_ptr;
    int value;
    virtual void draw( void );
    virtual void event_handler( Tevent &ev );
    virtual void ok_item( void );
};

class Tshort_radio: public Tcluster
{
  public:
    short data;
    Tshort_radio( char *_prompt, short &_data, short _value );
    virtual void press( void );
    virtual void press( boolean state );
    virtual boolean pressed( void );

  protected:
    short *data_ptr;
    short value;
    virtual void draw( void );
    virtual void event_handler( Tevent &ev );
    virtual void ok_item( void );
};
#endif

//CONSTRUCTORS FOR USE WITH DIALOG BOXES

Tcheck *check( char *t, boolean &data );
Tcheckb *check( char *t, uint &data, uint bit );
Tcheckw *check( char *t, word &data, uint bit );
Tradio *radio( char *t, int &data, int value );
Tshort_radio *radio( char *t, short &data, int value );
