//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVLIST.H                             |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Dynamic lists interface              |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

#ifndef _PVLIST_H
#define _PVLIST_H

#define leINDEX      0xD5 //index out of range
#define leOVERFLOW   0xD6 //list runs out of range

#define loASSOCIATED 0x01 //list is associated w/ another list
#define loSORTED     0x02 //list is sorted

class Tlist;

typedef boolean (* Tlfilter) ( Tlist *l, uint i );

class Tlist
{
  public:
    char options;
    uint _vcount;
    uint _vcurrent;
    uint _vbeg_print;
    int _vmax_print;
    uint &vcount; //total number of items in the list
    uint &vcurrent; //index of the currently selected item
    uint &vbeg_print; //index of the topmost visible item
    int &vmax_print; //number of visible items
    char scroll_ahead;
    Tlist( void );
    Tlist( Tlist *_list );
    Tlist( uint &v_count, uint &v_current, uint &v_beg_print, int &v_max_print );
    virtual ~Tlist( void );
    virtual void clear( void ); //empty the list
    virtual uint add( void *data ) = 0; //add an item to the list
    virtual void ins( uint i, void *data ) = 0; //insert an item before the i-th item
    virtual void del( uint i ) = 0; //delete i-th item
    virtual void get( uint i, void *data ) = 0; //get the i-th item
    virtual void put( uint i, void *data ) = 0; //replace the i-th item
    virtual void sort( void ) = 0; //sort items in the list
    virtual void up( void ); //select previous item
    virtual void down( void ); //select next item
    virtual void pgup( void );
    virtual void pgdn( void );
    virtual void top( void ); //select the first item
    virtual void bottom( void ); //select the last them
    virtual void at( uint i ); //scroll to i-th item
    virtual void gettxt( uint i, char *t ) = 0; //get i-th item as a string
    virtual void *getptr( uint i ) = 0; //get ptr to i-th item
    virtual uint findf( Tlfilter p ); //find first
    virtual uint findn( void ); //find next
    virtual void error( int error_code ) = 0; //called on error

  protected:
    Tlfilter cur_filter;
    uint find_index;
    virtual void inc_count( void ); //called to increase count
    virtual void dec_count( void ); //called to decrease count
};
#endif

void cursor_up_left( uint &current, uint &beg_print, uint max_print, uint scroll_ahead );
void cursor_down_right( uint &current, uint &beg_print, uint max_print, uint count, uint scroll_ahead );
void cursor_top_home( uint &current, uint &beg_print );
void cursor_bottom_end( uint &current, uint &beg_print, uint max_print, uint count );
void cursor_at( uint i, uint &current, uint &beg_print, uint max_print, uint count );
