/* REXX: rcsfreeze.cmd */

/* Author:  Kai Uwe Rommel <rommel@ars.de>
 * Created: Sun Nov 12 1995
 *
 * $Id: rcsfreeze.cmd,v 1.4 1999/03/14 20:29:57 rommel Exp $
 * $Revision: 1.4 $
 */

/*
 * $Log: rcsfreeze.cmd,v $
 * Revision 1.4  1999/03/14 20:29:57  rommel
 * minor fixes
 *
 * Revision 1.3  1998/02/25 17:34:06  behm
 * added handling of redirection with contents of file "RCS"
 *
 * Revision 1.2  1998/02/25 17:11:07  behm
 * fixed problem with too many files, rcs cmd is started for every file
 *
 * Revision 1.1  1995/11/12 21:18:10  rommel
 * Initial revision
 * 
 */

/* This is a rewrite in REXX of the original bourne shell script
 * included with RCS, for use on OS/2 workstations.
 */

Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

tab = '09'X

now = Left(Date('w'),3)' 'Word(Date('n'),2)' 'Word(Date('n'),1)' ' ||,
 Time('n')' 'Left(Value('TZ',,'OS2ENVIRONMENT'),3)' 'Word(Date('n'),3)

If SysFileTree('RCS','dir','DO') = 0 & dir.0 = 1 & FileSpec('n',dir.1) = 'RCS'
Then Do
  rcsdir = 'RCS/'
  ext = ''
End
Else Do
  If SysFileTree('RCS','dir','FO') = 0 & dir.0 = 1 & FileSpec('n',dir.1) = 'RCS'
  Then Do
    rcsdir = LineIn('RCS')
    If Pos(Right(rcsdir, 1), '/\') = 0 Then rcsdir = rcsdir'/'
  End
  Else rcsdir = ''
  ext = ',v'
End

versionfile = rcsdir'.rcsfreeze.ver'
logfile = rcsdir'.rcsfreeze.log'
tmplogfile = rcsdir'.rcsfreeze.tmp'

If Stream(versionfile,'c','query exists') = ''
Then Do
  Call LineOut versionfile,'0'
  Call Stream versionfile,'c','close'
  Call Stream logfile,'c','open write'
  Call Stream logfile,'c','close'
End

versionnumber = LineIn(versionfile)
versionnumber = versionnumber + 1
If LineOut(versionfile,versionnumber,1) \= 0
Then exit
Call Stream versionfile,'c','close'

symrev = 'c_'versionnumber
Parse Arg symrevname .
If symrevname = ''
Then symrevname = symrev

Say 'rcsfreeze: symbolic revision number computed: 'symrev
Say 'rcsfreeze: symbolic revision number used:     'symrevname
Say 'rcsfreeze: the two differ only when rcsfreeze invoked with argument'
Say 'rcsfreeze: give log message, summarizing changes (end with EOF or single ''.'')'

Call SysFileDelete tmplogfile 
Call LineOut tmplogfile,'Version: 'symrevname'('symrev'), Date: 'now
Call LineOut tmplogfile,'-----------'

Do Forever
  Parse Pull line
  If line = '.'
  Then Leave
  Call LineOut tmplogfile,tab || line
End

Do Until Stream(logfile, 'S') = 'NOTREADY'
  Call LineOut tmplogfile,LineIn(logfile)
End

Call Stream tmplogfile,'c','close'
Call Stream logfile,'c','close'
Call SysFileDelete logfile

Do Until Stream(tmplogfile, 'S') = 'NOTREADY'
  Call LineOut logfile,LineIn(tmplogfile)
End

Call Stream logfile,'c','close'
Call Stream tmplogfile,'c','close'
Call SysFileDelete tmplogfile

Call SysFileTree rcsdir'*'ext,'dir','FO'

Do i=1 To dir.0
  name = FileSpec('n',dir.i)
  If Left(name,1) \= '.' 
  Then '@rcs -q -n'symrevname': 'rcsdir''name
End

/* end of rcsfreeze.cmd */
