REM Counts files/lines/bytes of code v1.1a for SIC v7.0a PD 2001.

REM $DYNAMIC
DEFINT A-Z

' get include file
REM $INCLUDE: 'bc7.inc'

' display header
COLOR 15, 0
PRINT "SIC code counter v1.1a:"
COLOR 14, 0

' loop through files
FOR FileTypes = 1 TO 4
   ' get file extension
   SELECT CASE FileTypes
   CASE 1
      FileSpec$ = "*.bi"
   CASE 2
      Filespec$ = "*.inc"
   CASE 3
      Filespec$ = "*.bas"
   CASE 4
      Filespec$ = "*.sic"
   END SELECT
   ' display file extension
   PRINT "Counting: ";Filespec$
   ' get first matching filename
   Filename$ = DIR$(Filespec$)
   ' loop through all filenames
   WHILE LEN(Filename$)
      ' open filename
      CLOSE
      OPEN Filename$ FOR INPUT AS #1
      ' increment number of files
      TotalFiles# = TotalFiles# + 1#
      ' loop through file contents
      WHILE NOT EOF(1)
         ' read line from file
         LINE INPUT #1, InputLine$
         ' increment number of lines
         TotalLines# = TotalLines# + 1#
         ' increment number of bytes
         TotalBytes# = TotalBytes# + CDBL(LEN(InputLine$)) + 2#
      WEND
      ' get next filename
      Filename$ = DIR$
   WEND
NEXT
' display totals
COLOR 15, 0
PRINT "Total: "
PRINT Format$(TotalFiles#,"#,##0;;"); " files."
PRINT Format$(TotalLines#,"#,##0;;"); " lines."
PRINT Format$(TotalBytes#,"#,##0;;"); " bytes."
' end program
COLOR 7, 0
PRINT "Program run ended."
END
