TITLE  'Window 2D - Set and Get 2D WINDOW * MAJOR CHANGE'
NAME   WINDOW2D
PAGE   55,132
;-----------------------------------------------------------------------|
;    ScanSoft          (C)1991 Cornel H Huth     ALL RIGHTS RESERVED    |
;-----------------------------------------------------------------------|
;     date:      27 Jan 91                                              |
; function:      Set & Get clipping window in 2D                        |
;   caller:      FAR call (QuickBASIC convention)                       |
;                SETWIN2D(vseg,voff)  'x0,y0,xsize,ysize                |
;                GETWIN2D(vseg,voff)  'MAJOR CHANGE used to rtn x1,y1   |
;    stack:     +06 = offset of data                                    |
;                08 = segment                                           |
;  returns:      nothing                                                |
;------------------------------------------------------------------------

PARMS           = 2
ARGseg          EQU [bp+08]
ARGoff          EQU [bp+06]

include EXTRNDAT.INC

dgroup          group _BSS,_DATA

WINDOW2D_TEXT   SEGMENT WORD PUBLIC 'CODE'
                ASSUME cs:WINDOW2D_TEXT,ds:dgroup,ss:dgroup

                PUBLIC  SETWIN2D
SETWIN2D        PROC    FAR

                push    bp
                mov     bp,sp
                push    si

                cld
                mov     bx,ARGoff
                mov     si,[bx]
                mov     bx,ARGseg
                mov     es,[bx]         ;es:si->x0,y0,xsize,ysize

                db 26h
                lodsw
                mov     X0clip2,ax
                db 26h
                lodsw
                mov     Y0clip2,ax

                db 26h
                lodsw
                add     ax,X0clip2
                dec     ax
                mov     X1clip2,ax
                db 26h
                lodsw
                add     ax,Y0clip2
                dec     ax
                mov     Y1clip2,ax

                pop     si
                pop     bp
                RET     PARMS*2

SETWIN2D        ENDP

                PUBLIC  GETWIN2D
GETWIN2D        PROC    FAR

                push    bp
                mov     bp,sp
                push    di

                cld
                mov     bx,ARGoff
                mov     di,[bx]
                mov     bx,ARGseg
                mov     es,[bx]         ;es:di->x0,y0,xsize,ysize

                mov     ax,X0clip2
                stosw
                mov     ax,Y0clip2
                stosw
                mov     ax,X1clip2
                sub     ax,X0clip2
                inc     ax
                stosw
                mov     ax,Y1clip2
                sub     ax,Y0clip2
                inc     ax
                stosw

                pop     di
                pop     bp
                RET     PARMS*2

GETWIN2D        ENDP

WINDOW2D_TEXT   ENDS
                END

