;ELEAVE.ASM - Routine to return an error level from a QuickBASIC
;program
;
;********** WARNING **********
;Do not run in the QB environment
;
;By David Cleary

.Model Medium, Basic

.Code

   Extrn       B$CEND:Proc             ;QB termination proceedure

   Level       DW 0
   OldIntOfs   DW 0
   OldIntSeg   DW 0

ELeave Proc , ELevel:Ptr Word

   Mov   BX, ELevel                    ;Get the level passed in
   Mov   AX, [BX]
   Mov   CS:Level, AX                  ;Save it in Level

   Mov   AX, 3521h                     ;Call DOS to get its int vector
   Int   21h
   Mov   CS:OldIntOfs, BX              ;ES:BX points to old vector
   Mov   CS:OldIntSeg, ES

   Mov   AX, 2521h                     ;Now set our new int vector
   Mov   DX, Offset IntTrap
   Push  DS
   Push  CS
   Pop   DS                            ;Save DS and move CS into it
   Int   21h
   Pop   DS                            ;Restore DS
   Call  B$CEND                        ;Call BASIC to end

IntTrap:
   Cmp   AH, 4Ch                       ;Wait for function 4C
   Jne   ChainOld                    ;If not, chain to original vector

   Sti                               ;It is 4C, so turn interrupts on
   Mov   AX, 2521h                     ;Restore original vector
   Mov   DX, CS:OldIntOfs
   Mov   DS, CS:OldIntSeg
   Call  CS:DWord Ptr OldIntOfs   ;We need to call it instead of chain

   Mov   AX, CS:Level
   Mov   AH, 4Ch                       ;Call INT 21h function 4Ch with
                                       ;our level
   Int   21h

ChainOld:
   Jmp   CS:DWord Ptr OldIntOfs     ;This is our chain to the original

ELeave Endp

End
