
SUB Top.Menu (sel, sel$(), fgc, bgc, hlc, topline, dis.time, dis.date, scn.blank, msg$, bgc$)

'========================================================================
'Initilize Routine Varables
'========================================================================
        DIM a(20)     ' maximum number of top selections allowed
        month.data$ = "JanFebMarAprMayJunJulAugSepOctNovDec"
start:  S$ = ""
        a = 0
      
'========================================================================
' Clear The Screen Using The Character in bgc$
' Using The Colors Specified in fgc,bgc this will print the bgc$
' Character to all locations on the screen.
'========================================================================
        COLOR fgc, bgc
        FOR i = 1 TO 25
         LOCATE i, 1
         PRINT STRING$(80, bgc$);
        NEXT
     
'========================================================================
'Initilize Line# 25 (The Help Line)
'This will init the Help Line to reverse colors specified in fgc,bgc.
'
'Line 25 is where the Help messages are displayed for the Selections
'
'The Message Strings are passed via the SEL$(x,10) string of each selection
'========================================================================
       LOCATE 25, 1
       COLOR bgc, fgc
       PRINT SPACE$(80);
       COLOR fgc, bgc

'========================================================================
'Read the Selection Names that where passed in array SEL$(x,0)
'Store the length of each one in the array A().
'Get the 1st character of each SEL$(x,0), and build a string of them,
'this string is used to make top row selections based on letters.
'Read them until SEL$(x,0) is a Nul (0) length.
'========================================================================
       i = -1
       DO
          i = i + 1
          a(i) = LEN(sel$(i, 0))
          z$ = LTRIM$(sel$(i, 0))
          S$ = S$ + UCASE$(LEFT$(z$, 1))
       LOOP WHILE sel$(i, 0) <> ""
        
'========================================================================
' Setup the SEL variable to the correct value based on the number of
' selections that are to be displayed in the menu.
'========================================================================'
        sel = i - 1
   
'========================================================================
' Print the Message thats in MSG$ on the top line of the menu.
' If no message (MSG$=""), then make top line a line
' else center the message in MSG$ on the top line.
'========================================================================
       LOCATE topline + 1, 3
       COLOR fgc, bgc
       t = INT((75 - LEN(msg$)) / 2)
       IF t * 2 + LEN(msg$) < 75 THEN f$ = STRING$((75 - (t * 2 + LEN(msg$))), "") ELSE f$ = ""
       PRINT "" + STRING$(t, "") + msg$ + f$ + STRING$(t, "") + "";
      
'========================================================================
'Initilize 2nd line of Menu
'Print blank line as 2nd line
'then display Selection Names on line 2
'The names are in array SEL$(x,0)
'========================================================================
       LOCATE topline + 2, 2            'print blank line
       COLOR 0, 0
       PRINT " ";
       COLOR fgc, bgc
       PRINT "" + SPACE$(75) + "";
       '-----------------------------------------------------------------
       LOCATE topline + 2, 5            'print selection Names
       COLOR fgc, bgc
       FOR i = 0 TO sel
         PRINT sel$(i, 0);
       NEXT
  
'========================================================================
'Print 3rd line of Menu ( bottom of box)
'========================================================================
       LOCATE topline + 3, 2
       COLOR 0, 0
       PRINT " ";
       COLOR fgc, bgc
       PRINT "" + STRING$(75, "") + "";

'========================================================================
' Setup varables
'========================================================================
       subsel = 1
       subnum = 1
       zold = 2
       S = 0
       x = 5
'========================================================================
' Display submenu for the new Selection Name of SEL number
'========================================================================
  GOSUB dis.sub

'========================================================================
'Display New Selection Name highlited on selection bar
'========================================================================'
lp:    oldx = x                         'update variables
          x = 5
       '-----------------------------------------------------------------
       FOR i = 0 TO S                   'Calculate new Selection position
         x = x + LEN(sel$(i, 0))
       NEXT
       '-----------------------------------------------------------------
       x = x - LEN(sel$(i - 1, 0))      'fix  x  to equal location
                                        'start of NEW selection Name
       '-----------------------------------------------------------------
       COLOR fgc, bgc                   'put OLD selection Name back to
       LOCATE topline + 2, oldx         'original color
       PRINT sel$(olds, 0);
       '-----------------------------------------------------------------
       COLOR hlc, fgc                   'Select NEW selection Name
       LOCATE topline + 2, x            'with highlite color
       PRINT sel$(S, 0);
                                                     
'========================================================================
' Print the message for the New Selection Name centered on line 25
' The string is taken from SEL$(x,10)
' Based on the current value of S.
'========================================================================'
       t = INT((80 - LEN(sel$(S, 10))) / 2)
       IF t * 2 + LEN(sel$(S, 10)) < 78 THEN f$ = STRING$((78 - (t * 2 + LEN(sel$(S, 10)))), "") ELSE f$ = ""
       LOCATE 25, 1
       COLOR bgc, fgc
       PRINT SPACE$(t) + sel$(S, 10) + f$ + SPACE$(t);
       COLOR fgc, bgc

'========================================================================'
' Wait for KEY to be pressed and....
' Display Current TIME if variable Dis.Time is not equal to 0.
' Display Current DATE if variable Dis.Date is not equal to 0.
' if screen blank is ON (scn.blank=1) then blank screen if no key is
' pressed for 3 minutes
'========================================================================'
get.key: blk.time = VAL(MID$(TIME$, 4, 2))

         DO
           a$ = INKEY$
       '-----------------------------------------------------------------
         IF dis.date = 0 THEN GOTO dtime          'Display Date
           month$ = MID$(month.data$, (((VAL(DATE$) - 1) * 3) + 1), 3)
           LOCATE topline + 1, 4
           PRINT CHR$(16) + month$ + " " + MID$(DATE$, 4, 2) + "," + MID$(DATE$, 9, 2) + CHR$(17)
       '-----------------------------------------------------------------
dtime:   IF dis.time = 0 THEN GOTO chk.blank      'Display Time
           tx = VAL(LEFT$(TIME$, 2))
           am$ = "Am"
           IF tx > 12 THEN tx = tx - 12: am$ = "Pm"
           t$ = CHR$(16) + RIGHT$(STR$(tx), 2) + ":" + MID$(TIME$, 4, 2) + " " + am$ + CHR$(17)
          
           LOCATE topline + 1, 69
           PRINT t$
       '-----------------------------------------------------------------
chk.blank: IF scn.blank = 0 THEN GOTO key.loop    'blank screen
           IF VAL(MID$(TIME$, 4, 2)) > blk.time + 2 THEN GOTO blk.scrn
          
key.loop: LOOP WHILE a$ = ""

'========================================================================'
'Process the key that was pressed
'========================================================================''
         IF LEN(a$) < 2 THEN GOTO reg.key       'if the key is an
                                                'extended key (len>1)
                                                'then process as cursor key
                                                'else check for other key
       '-----------------------------------------------------------------
         a = ASC(RIGHT$(a$, 1))                 'check for cursor keys
         IF a <> 77 AND a <> 75 AND a <> 72 AND a <> 80 GOTO get.key
         olds = S
         IF a <> 77 AND a <> 75 GOTO get.updnkey
         IF a = 77 THEN S = S + 1               'check for left/right keys
         IF a = 75 THEN S = S - 1
         IF S > sel THEN S = 0
         IF S < 0 THEN S = sel
         c = S
         subsel = 1
         subnum = 1
         GOSUB dis.sub
         GOTO lp
       '-----------------------------------------------------------------
get.updnkey:                                    'check for up/down cursor 
         IF a = 80 THEN subsel = subsel + 1
         IF a = 72 THEN subsel = subsel - 1
         GOSUB update.sub
         GOTO lp
        
       '-----------------------------------------------------------------
reg.key: a$ = UCASE$(a$)                        'else make the key
                                                'Upper Case
       '-----------------------------------------------------------------
       IF a$ = CHR$(27) THEN sel = -1: EXIT SUB 'check for escape key
                                                'if the key is 'ESC' then
                                                'return with SEL= -1 (neg.1)
       '-----------------------------------------------------------------
ret:   IF a$ <> CHR$(13) GOTO test.num          'if key is ENTER then
       sel = (S * 10) + subnum: EXIT SUB        'return with selection
                                                'number in SEL
       '-----------------------------------------------------------------
                                                'else test for number Key
test.num:                                       'if not a valid # key test
       q = VAL(a$)                              'for letter key
       IF q >= 1 AND q <= cv AND q <= 9 AND q > 0 THEN
       subsel = q
       GOSUB update.sub
       a$ = CHR$(13): GOTO ret
       END IF
      
       '-----------------------------------------------------------------
test.ltr: IF c <> 0 THEN                       'test for first letter key
            c = c + 1                          'if c<>0 then add 1 to c
            c = INSTR(c, S$, a$)               'and test for match
          IF c <> 0 GOTO tr                    'this allows multilble
         END IF                                'selections with the same
            c = INSTR(S$, a$)                  'letter to be selected as
          IF c = 0 GOTO get.key                'round-robin type
tr:    olds = S
       S = c - 1
       subsel = 1
       subnum = 1
       GOSUB dis.sub                           'go display new Sub menu
       GOTO lp                                 'and go display new Selection
                                               'Name

'========================================================================'
'* * * * * * * * Subroutine To Display NEW Sub Menu * * * * * * * * * *
' Clear old submenu box to back ground character (BGC$)
' and display NEW sub menu
'
'========================================================================'
dis.sub:                                       'init variables
        i = 0
        a = 0
        xtemp = x
      
       '-----------------------------------------------------------------
       'clear old submenu box to back ground character
       
        COLOR fgc, bgc
        FOR i = 1 TO cv + 2
         LOCATE topline + 4 + i, zold - 1
         PRINT STRING$(aold + 7, bgc$)
        NEXT
      
       '-----------------------------------------------------------------
       'fix the 'shadow' line of the top box
      
        LOCATE topline + 4, 1
        COLOR fgc, bgc
        PRINT bgc$;
        COLOR 0, 0
        PRINT SPACE$(77);
        COLOR fgc, bgc
        PRINT STRING$(2, bgc$);

       '-----------------------------------------------------------------
       'find the length of the longest submenu title to be displayed
       'and store in A. If there is no Submenu for this Selection then
       'return, Else Display NEW Submenu
      
       i = 1
       
       DO WHILE (sel$(S, i) <> "") AND (i < 10)
       IF LEN(sel$(S, i)) > a THEN a = LEN(sel$(S, i))
         i = i + 1
       LOOP
       cv = 0
       IF i = 1 THEN RETURN                     'no Submenu
      
       '-----------------------------------------------------------------
       'Display new SubMenu
      
       aold = a                                 'init variables
       cvold = cv
       cv = i - 1
     
       cvold = cv
       x = 5
                                                'calculate cursor position
       FOR i = 0 TO S
         x = x + LEN(sel$(i, 0))
       NEXT

                                                'fix cursor position to
                                                'start of selection string
       x = x - LEN(sel$(i - 1, 0))
      
       '-----------------------------------------------------------------
       'if starting position + longest string found > 77 then adjust
       'start position.
       'if starting pos. < 4 then set it to 4.
       '-----------------------------------------------------------------
      
       IF x + a > 77 THEN z = 72 - a ELSE z = x - 3
       IF z < 4 THEN z = 4
       zold = z
      
       '-----------------------------------------------------------------
       'Print NEW SubMenu
      
       COLOR fgc, bgc
       LOCATE topline + 4, z
       PRINT "" + STRING$((x - z) - 1, "");
       LOCATE topline + 4, x
       PRINT "" + SPACE$(LEN(sel$(S, 0)) - 2) + "";
       b = x + LEN(sel$(S, 0)) - 1
       n = z + a + 3
       xx = (n) - (b - 1)
       IF xx < 1 THEN xx = 0
       PRINT STRING$(xx, "") + "";
      
       FOR i = 1 TO cv
         LOCATE topline + i + 4, z - 1
         COLOR 0, 0
         PRINT " ";
         COLOR fgc, bgc
         PRINT "";
         PRINT LTRIM$(STR$(i)) + ". " + sel$(S, i) + SPACE$(a - (LEN(sel$(S, i)) - 1)) + "";
       NEXT
      
       LOCATE topline + i + 4, z - 1
       COLOR 0, 0
       PRINT " ";
       COLOR fgc, bgc
       PRINT "" + STRING$(a + 4, "") + "";
       LOCATE topline + i + 5, z - 1
       COLOR 0, 0
       PRINT STRING$(a + 6, " ");
       x = xtemp


'========================================================================'
'* * * * * * * * Subroutine To Display NEW title in Submenu * * * * * * *
' restore previous title to normal colors
' and display NEW tile in High-lite Color (HLC)
'========================================================================'
update.sub:
       COLOR fgc, bgc
       IF cv = 0 THEN RETURN
       IF subsel > cv THEN subsel = 1
       IF subsel < 1 THEN subsel = cv
       '-----------------------------------------------------------------
                                                'restore previous title
       LOCATE topline + subnum + 4, z + 1
       PRINT LTRIM$(STR$(subnum)) + ". " + sel$(S, subnum);
       '-----------------------------------------------------------------
                                                'print new title
       LOCATE topline + subsel + 4, z + 1
       COLOR hlc, fgc
       PRINT LTRIM$(STR$(subsel)) + ". " + sel$(S, subsel);
       subnum = subsel
       COLOR fgc, bgc
       RETURN

'========================================================================'
'* * * * * * * * Subroutine To Blank the Screen * * * * * * *
'========================================================================'
blk.scrn:
       SOUND 600, 3
       SOUND 400, 3
       COLOR 0, 0
       CLS
       x = 1: y = 1
blk1:  RANDOMIZE z
       ox = x: oy = y
       LOCATE ox, oy
       COLOR 0, 0
       PRINT SPACE$(19);

blk2:  x = INT(RND * 25)
       y = INT(RND * 80)
      
       IF x > 25 OR y > 60 OR x < 1 OR y < 1 THEN GOTO blk2:
       COLOR fgc, bgc
       LOCATE x, y
       PRINT "...Press Any Key...";
       t = VAL(MID$(TIME$, 8, 1))
tlp:   IF t = VAL(MID$(TIME$, 8, 1)) THEN GOTO tlp
       a$ = INKEY$
       IF a$ = "" GOTO blk1
       GOTO start

END SUB

