;RM82TS8,16,24,32,40,48
; updated 11/20/90

;============================================================================
;   Copyright (C) Copr. 1990 by Sidney J. Kelly
;           All Rights Reserved.
;           Sidney J. Kelly
;           150 Woodhaven Drive
;           Pittsburgh, PA 15228
;           home phone 412-561-0950 (7pm to 9:30pm EST)
;============================================================================

DOSSEG
.model medium, BASIC
.code

;-------------------------far data area-------------------------------------
EVEN
N_Curs          DW      0
N_Curs_Blk      DW      0

;============================================================================
; DECLARE SUB CURSET (Mode%)
; Input:
;       Mode = 0  turn off cursor
;            NOTE on a VGA with ANSI.SYS installed it might not be possible
;            to turn off all attributes of the cursor.
;       Mode = 1  turn on normal cursor
;       Mode = 2  turn on half block
;       Mode = 3  turn on full block
; Returns:
;       Nothing
; Purpose:
;       Selects attractive cursor sizes over the default QBASIC format.
;       Complicated because of need to overcome cursor emuation on VGA/EGA
;       With an EGA/VGA if want a full block cursor, cannot rely on cursor
;       emulation, must adjust for actual display box.
;============================================================================

EVEN
CURSET Proc FAR BASIC MODE:Ptr
	Cmp     N_Curs,0           ; check if we have done this before
	JNE     Installed          ; yep, we have so don't do it again

	Xor     BX,BX              ; set ES to Ram BIOS area
	Mov     ES,BX
	Mov     N_Curs,0B0Ch       ; Assume VGA, EGA or Mono
	Mov     N_Curs_Blk,060Ch

EGA_test:
	Mov     AX,1200h           ; have to do this full scale search
	Mov     BX,10h             ; to override cursor emulation
	Int     10h                ; if want full height block cursor
	Cmp     BL,10h             ; EGA changes BL from 10h
	JE      CGA_test
        Test    ES:Byte Ptr [487h],1000b  ;EGA active?, bit 3 of 0040:0087 set?
     	JNZ     CGA_test           ; if bit set, then EGA is inactive
        Jmp     short Installed    ; EGA/VGA active so jump ahead
				   ; and use default information
CGA_test:
	Mov     BX,ES:[0463h]      ; look a port info stored in RAM bios
				   ; at 0000:0463h
	Cmp     BL,0B4h            ; test port address for a mono
	JE      Installed          ; correct assumption
	Mov     N_Curs,0607h       ; use CGA cursor format for normal and
	Mov     N_Curs_Blk,0307h   ; for half block too

Installed:
	Mov     BX, MODE           ; read Mode% from stack
	Mov     AX, [BX]           ; get from indirect BX
	And     AL,3               ; keep within 0 to 3 range
	Mov     CX,N_Curs          ; Load CX with cursor format
	Or      AL,AL              ; determine action
	JNZ     Not_Off            ; AL <> 0

Turn_Off:
	Mov     AX,300H            ; read current cursor values
				   ; fully set AX because so many routines
				   ; use Int 10h in unusual ways
	Xor     BX,BX              ; for page 0
	Int     10h                ; (a work around for a VGA clone problem)
	Or      CH,20h             ; turn off cursor (set bit five of CH)
	Jmp     Short Doit         ; doit

Not_Off:
	Cmp     AL,1               ; merely asked to turn on?
	JE      Doit               ; yep so do it
	Cmp     AL,2               ; half block?
	JNE     Full_Block         ; nope, full block

Half_Block:
	Mov     CX,N_Curs_Blk      ; get half block format
	Jmp     Short  Doit        ; set it

Full_Block:
	XOR     CH,CH              ; AL must have been 3

Doit:
	Mov     AX,100h            ; set cursor size
				   ; fully set AX because so many routines
				   ; use Int 10h in unusual ways
	Int     10h                ; call video routine
	Ret                        ; MASM does clean up
CURSET  ENDP
END
