PAGE 66,132
TITLE RBBS-PC MultiLink Interface Copyright 1985 by D. Thomas Mack
;--------------------------------------------------------------------;
;ROUTINE: RBBSML              AUTHOR:  D. Thomas Mack                ;
;                                      10210 Oxfordshire Road        ;
;                                      Great Falls, Virginia  22066  ;
;                                                                    ;
;DATE:  October 7, 1985       VERSION: 1.0                           ;       
;                                                                    ;
;FUNCTION: This routine supports calls from the IBM (MICROSOFT)      ;
;          BASIC Version 2.0 or Microsoft Quick BASIC Version 1.0    ;
;          compilers to the MultiLink User Interface.  The call is:  ;
;                                                                    ;
;            CALL RBBSML (AX%,BX%)                                   ;
;                                                                    ;
;          where AX% and BX% are 16-bit binary data items (i.e.      ;
;          integer variables) and should be set for the desired      ;
;          function as described in the MultiLink manual.            ;
;                                                                    ;
;          The value for AX, as defined in your MultiLink manual,    ;
;          should be computed as                                     ;
;                                                                    ;
;             AX% = 256*function-code + value-for-AL                 ;
;                                                                    ;
;          and similarly BX% should be computed as                   ;
;                                                                    ;
;             BX% = value-for-BX                                     ;
;                                                                    ;
;          as shown in the MultiLink manual for BASIC programs.      ;
;          for Basic programs.  A MultiLink "status code" is         ;
;          returned in AX%.                                          ;
;--------------------------------------------------------------------;
RBBS_MLTI SEGMENT BYTE PUBLIC 'CODE'
          ASSUME CS:RBBS_MLTI
          PUBLIC RBBSML
RBBSML    PROC   FAR           ;LONG CALL
          PUSH   BP            ;SAVE CALLERS BASE POINTER REGISTER -- BP 
          MOV    BP,SP         ;SETUP TO ADDRESS OFF OF BASE POINTER REGISTER
          MOV    DI,[BP]+8     ;GET ADDRESS OF AX% PARAMETER
          MOV    AX,[DI]       ;PUT VALUE IN AX REGISTER
          MOV    DI,[BP]+6     ;GET ADDRESS OF BX% PARAMETER
          MOV    BX,[DI]       ;PUT VALUE IN BX REGISTER
          INT    7FH           ;CALL MultiLink USER INTERFACE
          MOV    DI,[BP]+8     ;GET ADDRESS OF AX% PARAMETER
          XOR    AH,AH         ;CLEAR GARBAGE IN AH REGISTER
          MOV    [DI],AX       ;PUT RETURN CODE IN AX% PARAMETER
          POP    BP            ;RESTORE CALLERS BASE POINTER REGISTER-- BP
          RET    4             ;RETURN AND REMOVE THE 2 PARAMETERS FROM STACK
RBBSML    ENDP
RBBS_MLTI ENDS
          END
