comment #

   (C) Copyright 1996 Charon Software, All Rights Reserved
   MCLOCK.ASM, assembled with MASM 6.10

   v1.0, 03/16/92: initial version, based on VIDCLOCK 1.3
   on-screen clock TSR displays on mono screen, assumes dual monitors

   v2.1, 02/01/96: first release by Charon Software

#


ResLength equ (Install - Main + 100h + 0Fh) shr 4


Sseg          segment byte stack 'prog'    ; dummy stack segment
Sseg          ends


Cseg          segment byte public 'prog'
              assume  cs:Cseg, ds:Cseg, ss:Sseg

              org     100h


Main          proc    far
              jmp     Install
Main          endp


; ---------------------- INT 1Ch (timer interrupt tail) -----------------------


MClock        proc           far
              pushf
              call dword ptr cs:OldClock    ; let old clock handler process it
              dec            cs:CLOCKTIME   ; time to update display?
              jz             OurClock       ;   yes, go for it
              iret

OldClock  dw ?, ?      ; original INT 1Ch vector

OurClock:     push           ax
              push           bx
              push           cx
              push           dx
              push           si
              push           di
              push           ds
              push           es
              mov            ax,cs          ; set DS to CS
              mov            ds,ax
              xor            ax,ax          ; set ES to BIOS data area
              mov            es,ax
              mov            dx,ax
              mov            al,es:[0449h]  ; current video mode
              cmp            al,3           ; text mode?
              jbe            ModeOk         ;   yep, continue
              cmp            al,7           ; text mode?
              je             ModeOk         ;   yep, continue
              jmp            ExitClock      ; go exit

ModeOk:       mov            ax,es:[046Ch]  ; lsw of time (3-byte)
              mov            dl,es:[046Eh]  ; msb of time (3-byte)
              shr            dx,1
              rcr            ax,1
              mov            di,32771
              div            di             ; compute hours
              mov            bh,al          ; save 'em
              mov            ax,dx          ; prepare remainder for minutes
              xor            dx,dx
              mov            di,546
              div            di             ; compute minutes
              mov            bl,al          ; save 'em
   NOSECONDS  db 0F8h                       ; *** self-modified code ("clc")
              jc             UpdMinutes     ;   skip seconds if flag says so
              mov            ax,dx          ; prepare remainder for seconds
              mov            dl,9
              div            dl             ; compute seconds
UpdSeconds:   cmp            al,60          ; too high?
              jb             GotSeconds     ;   no, it's fine
              sub            al,60
              inc            bl
              jmp            UpdSeconds
GotSeconds:   aam                           ; convert to BCD
              add            ax,"00"        ; convert to ASCII
              xchg           al,ah
              mov word ptr   TIMEMSG+6,ax
UpdMinutes:   cmp            bl,60          ; too high?
              jb             MinOk          ;   no, skip
              sub            bl,60
              inc            bh
              jmp            UpdMinutes
MinOk:        mov            al,bl
              aam                           ; convert to BCD
              add            ax,"00"        ; convert to ASCII
              xchg           al,ah
              mov word ptr   TIMEMSG+3,ax
GotSec:       mov            al,bh          ; hours
              cmp            al,24          ; too large?
              jb             GetHour0       ;   no
              xor            al,al          ; zap to zero
GetHour0:     mov            si,MPLACE      ; 12/24-hour flag, and more...
              or             si,si          ; 24-hour time?
              jz             GetHour        ;   yes, got it
              mov            di,"ma"        ; assume morning
              cmp            al,12          ; is it morning?
              jae            AfterNoon      ;   no, it's after noon
              or             al,al          ; is it 12:xx am?
              jnz            PlaceTime      ;   no, got it
              mov            al,12
              jmp            PlaceTime
AfterNoon:    mov            di,"mp"        ; flag it after noon
              je             PlaceTime      ;   got it if noon
              sub            al,12          ; convert to 12-hour time
PlaceTime:    mov word ptr   ds:TIMEMSG[si],di ; place "am"/"pm" indicator
GetHour:      aam                           ; convert to BCD
              add            ax,"00"        ; convert to ASCII
              xchg           al,ah
              cmp            al,"0"         ; leading zero?
              jne            GotHour        ;   nope, skip
              mov            al," "         ; make it blank
GotHour:      mov word ptr   TIMEMSG,ax
              cld
              mov            di,0B000h      ; mono video segment
              mov            es,di          ;
              xor            di,di          ; ...and offset
              mov            ah,7           ; color (white on black)
              mov            si,offset TIMEMSG
              xor            cx,cx
              mov            cl,TIMELEN
DisplayTime:  lodsb                         ; get a chr
              stosw                         ; display it with color
              loop           DisplayTime    ;   go for another
ExitClock:    mov            CLOCKTIME,9    ; restart clock display countdown
              pop            es
              pop            ds
              pop            di
              pop            si
              pop            dx
              pop            cx
              pop            bx
              pop            ax
              iret                          ; return



; ------------------ INT 2Fh (multiplex interrupt) -----------------------



MuxHandler:   cmp            ah,0D9h        ; is it for us?
              je             OurMux         ;   yep, go process it
NormMux:      db 0EAh      ; *** self-modifying code: JMP FAR PTR xxxx:yyyy
    MOFS      dw ?         ; original INT 2Fh vector
    MSEG      dw ?

OurMux:       or             al,al          ; status request?
              jnz            OM1            ;   no, skip
              dec            al             ; AL=0FFh to show we're here
              iret                          ;   go directly home
OM1:          cmp            al,1           ; "remove self" request?
              jne            OM9            ;   no, exit
              xor            ax,ax
              mov            es,ax
              cli                           ; interrupts off
              mov            ax,cs:OldClock ; restore old INT 1Ch vector
              mov            es:[0070h],ax
              mov            ax,cs:OldClock+2
              mov            es:[0072h],ax
              mov            ax,cs:MOFS     ; restore old INT 2Fh vector
              mov            es:[00BCh],ax
              mov            ax,cs:MSEG
              mov            es:[00BEh],ax
              sti                           ; interrupts on
              push           cx
              push           di
              mov            cx,0B000h      ; video segment
              mov            es,cx
              xor            cx,cx
              mov            di,cx          ; video offset
              mov            cl,cs:TIMELEN  ; length of clock display
              mov            ax,0720h       ; space in color (white on black)
              cld                           ; set direction forward
              rep            stosw          ; clear the clock
              pop            di
              pop            cx
              push           cs
              pop            es             ; put current segment in ES
OM9:          iret                          ; return



; ---------------- DATA required by interrupt handlers --------------------



MPLACE    dw 0               ; offset from TIMEMSG for "am" or "pm" indicator
                             ; also a flag: 0: 24hr; 5: 12hr,nosec; 8: 12hr,sec
CLOCKTIME db 1               ; ticks til next screen update
TIMELEN   db 10              ; chars in time display
TIMEMSG   db "00:00:00xm"    ; current time

MClock        endp



; ------------------ INSTALLATION routine ---------------------------------



Install       proc           near
              mov            dx,offset HeaderMsg
              mov            ah,9
              int            21h            ; display copyright/header message
              mov            ax,0D900h      ; query status of our handler
              int            2Fh            ; ...on the multiplex interrupt
              mov            INSTALLED,al   ; save results for later
              xor            ax,ax
              mov            es,ax
              mov            ch,ah
              mov            cl,ds:[0080h]  ; get command line length
              or             cx,cx          ;
              jz             Inform         ;   if null, tell 'em about us
              cld
              mov            si,0081h       ; ptr to command line
Parse:        lodsb                         ; get a chr
              cmp            al,"/"         ; slash?
              je             ParseNext      ;   yes, ignore
              cmp            al,"-"         ; hyphen?
              je             ParseNext      ;   yes, ignore
              cmp            al," "         ; space or control?
              jbe            ParseNext      ;   yes, ignore
              cmp            al,"z"         ; alpha chr?
              ja             Inform         ;   no, bad parm
              cmp            al,"a"         ; alpha chr?
              jb             Parse1         ;   no, skip
              xor            al,32          ; convert to lowercase
              jmp            Parse2
Parse1:       cmp            al,"Z"         ; alpha chr?
              ja             Inform         ;   no, bad parm
              cmp            al,"A"         ; alpha chr?
              jb             Inform         ;   no, bad parm
Parse2:       cmp            al,"M"         ; use military time format?
              jne            Parse2a        ;   no
              mov            MPLACE,1
              jmp            ParseNext
Parse2a:      cmp            al,"I"         ; install clock?
              jne            Parse2b        ;   no
              mov            PINSTALL,1
              jmp            ParseNext
Parse2b:      cmp            al,"S"         ; display seconds?
              jne            Parse2d        ;   no
              mov            NOSECONDS,0F9h ; *** self-modifying code ("stc")
              jmp            ParseNext
Parse2d:      cmp            al,"R"         ; remove clock?
              jne            Inform         ;   no
              mov            PREMOVE,1
              jmp            ParseNext
ParseNext:    loop           Parse

NoParse:      cmp            NOSECONDS,0F8h ; seconds display?
              je             Setup1         ;   yes, skip
              sub            TIMELEN,3
Setup1:       cmp            MPLACE,0       ; military clock?
              jnz            Setup2         ;   yes
              mov            MPLACE,5       ; assume no seconds
              cmp            NOSECONDS,0F8h ; no seconds display?
              jne            SetupDone      ;   right, skip out
              mov            MPLACE,8
              jmp            SetupDone
Setup2:       sub            TIMELEN,2
              mov            MPLACE,0

SetupDone:    cmp            PREMOVE,0      ; remove clock?
              jne            Remover        ;   yes
              cmp            PINSTALL,0     ; install clock?
              jne            Installer      ;   yes
              jmp            Inform         ;   go tell 'em about us

Remover:      mov            dx,offset NotHereMsg
              cmp            INSTALLED,0    ; is the clock installed?
              jz             Done           ;   no, done!
              mov            ax,0D901h      ; tell clock to remove itself
              int            2Fh            ; (returns clock seg in ES)
              mov            ah,49h         ; free up our memory
              int            21h
              mov            dx,offset RemoveMsg
Done:         mov            ah,9
              int            21h            ; display message
              mov            ax,4C00h       ; terminate with no error code
              int            21h

Installer:    cmp            INSTALLED,0    ; is the clock installed?
              jz             InstallOk      ;   no, go ahead
              mov            dx,offset AlreadyMsg
              jmp            Done

InstallOk:    mov            es,ds:[002Ch]
              mov            ah,49h         ; release our copy of environment
              int            21h
              xor            ax,ax          ; point to BIOS data area
              mov            es,ax
              mov            cx,ax
              mov            CLOCKTIME,1    ; set clock to go
              cli                           ; interrupts off
              mov            ax,es:[0070h]  ; get & save the old INT 1Ch vector
              mov            cs:OldClock,ax
              mov            ax,es:[0072h]
              mov            cs:OldClock+2,ax
              mov            ax,es:[00BCh]  ; get & save the old INT 2Fh vector
              mov            cs:MOFS,ax
              mov            ax,es:[00BEh]
              mov            cs:MSEG,ax
              mov            es:[0072h],cs  ; install new INT 1Ch handler
              mov word ptr   es:[0070h],offset cs:MClock
              mov            es:[00BEh],cs  ; install new INT 2Fh handler
              mov word ptr   es:[00BCh],offset cs:MuxHandler
              sti                           ; interrupts on
              mov            dx,offset InstallMsg
              mov            ah,9
              int            21h            ; display installation message
              mov            dx,ResLength   ; size of interrupt handler (parag)
              mov            ax,3100h       ; terminate and stay resident
              int            21h

Inform:       mov            dx,offset InformMsg
              mov            ah,9
              int            21h            ; display information message
              mov            ax,4C00h       ; exit with error code
              int            21h
Install       endp



; --------------- DATA used only by installation routine ------------------



PINSTALL   db 0               ; whether to install ourselves
PREMOVE    db 0               ; whether to remove ourselves
INSTALLED  db 0               ; whether we're already installed

InstallMsg db 13,10,"MCLOCK installed.",13,10,"$"
RemoveMsg  db 13,10,"MCLOCK removed.",13,10,"$"

AlreadyMsg db 13,10,"Error: a 2MON utility is already installed.",13,10,"$"
MissMsg    db 13,10,"Error: Missing parameter.",13,10,"$"
NotHereMsg db 13,10,"Error: MCLOCK was not installed.",13,10,"$"

HeaderMsg  db "MClock 2.1: Mono clock for dual-monitor systems",13,10
           db 13,10
           db "(C) Copyright 1996 Charon Software, All Rights Reserved",13,10
           db 13,10,"$"

InformMsg  db 13,10
           db "This utility continuously displays the time, without affecting normal",13,10
           db "operation of the computer.  Display is done to the mono adapter.",13,10
           db 13,10
           db "MClock options:",13,10
           db 13,10
           db "/I        install the clock",13,10
           db "/R        remove the clock",13,10
           db "/M        use military (24 hour) time format",13,10
           db "/S        don't display seconds",13,10
           db "$"



Cseg          ends
              end            Main
