Comment *

        BURNOUT by Chris Dunford - demo program to
        access/change/display BRNDEV parameters.

        To use, just type:

            BURNOUT parameters

        where the parameters are anything that's legal as a BRNDEV
        option (as described in the documentation).  For example:

            BURNOUT 5000
            BURNOUT 5000 H- F7

        Preparation:
            MASM burnout;
            LINK burnout;     [ignore NO STACK message]
            EXE2BIN burnout burnout.com

        Revised 23-Dec-1987 because I lost the source for the original.

*

; ---------------------------------------------------------
; DEFINITIONS section
;

; DOS functions we'll use
PRINT   equ 9                           ; Print a string$
FOPEN   equ 3DH                         ; Open a file/device
FREAD   equ 3FH                         ; Read from a file/device
FWRITE  equ 40H                         ; Write to a file/device
EXIT    equ 4CH                         ; Exit to DOS

; A couple of ASCII characters
LF      equ 10
CR      equ 13

; Macro to access DOS functions
DOS macro func
        mov ah,func
        int 21H
endm


code segment
assume cs:code, ds:code, es:code

; Where the commandline parameters will go (in the PSP)

org 80H
parm_len    label byte                  ; Parameter length attribute

org 81H
parms       label byte                  ; Parameter text

; Program entry point
org 100H
burnout:
        jmp start                       ; Jump to code


; ------------------------------------------------------------------
; DATA section
;

; BURNOUT system device name (ASCIIZ format)
devname         db 'BRNDEV',0

; BRNDEV's reset and execute characters
reset           db '@'
execute         db '#'

; Message displayed if BRNDEV isn't installed
not_installed$  db 'Burnout device is not installed',CR,LF,'$'

; Status report message, followed IMMEDIATELY by the buffer
; into which the BRNDEV status report is read.  These are
; displayed in one operation, so don't separate the two.
status$         db 'Current status: '
buffer          db 15 dup (0)

; -------------------------------------------------------------
; CODE section
;

start:

; See if BRNDEV is installed
        mov dx,offset devname           ; File name is 'BRNDEV'
        mov al,2                        ; Open for read/write
        DOS fopen
        jnc rewind                      ; If no carry, BRNDEV is installed

; BURNOUT isn't installed
        mov dx,offset not_installed$    ; Display error message
        DOS print
        mov al,1                        ; Exit with errorlevel 1
        jmp bye

; It's installed.  Send a '@' to the device.  This prepares
; the device for accepting new operating parameters and it
; places the current BRNDEV status into BRNDEV's I/O buffer.
; If there are no command line options, we'll go directly
; to the READ portion, and the status report will be current.
rewind:
        mov bx,ax
        mov dx,offset reset
        mov cx,1
        DOS fwrite

; If there are command line parameters, send them to the device.

        ; No options if parm length is zero
        mov al,parm_len
        or al,al
        jz get_status

        ; Write options to the device
        cbw                             
        mov cx,ax                       ; CX = parameter length
        mov dx,offset parms
        DOS fwrite

        ; Send a '#' to force parsing of the options we just sent.
        ; This also updates the status report in the BRNDEV i/o buffer.
        mov dx,offset execute
        mov cx,1
        DOS fwrite

; Read and display current BRNDEV status
get_status:

        ; Read from device into our buffer
        mov dx,offset buffer
        mov cx,255
        DOS fread

        ; Add an LF and a '$' to what BRNDEV sent
        mov di,dx                           ; DI -> start to status report
        add di,ax                           ; DI -> end of report (past CR)
        mov word ptr [di],'$' shl 8 + LF    ; Put LF + '$' there for DOS fn 9

        ; Display the results
        mov dx,offset status$
        DOS print

        ; Errorlevel 0
        xor al,al

; Common exit.  AL should have errorlevel at this point.
bye:
        DOS exit

code ends
end burnout
