'********** 123TOASC.BAS
'Convert Lotus 123 versions 1A to 2.1
' And Symphony 1.1 to DOS ASCII file
'Version 1.0 -
'Version 1.01 - Display Percent sign.
'               Display Formula results properly.
'Version 1.02 - Global Format & Width calcs
'Version 1.02b- General Format Fix & VP-Planner Fix
'Author - Larry Hupman
'Some Convert Routines Taken from:
'Read123 Copyright (c) 1988, Ziff Communications Co.
'PC Magazine * Ethan Winer * Martin Valley
'December 13, 1988 Volume 7 Number 21
DEFINT A-Z
DECLARE SUB GetFormat (Format, row, Column)

COMMON SHARED StoreCol()
COMMON SHARED ChkStore()
COMMON SHARED Cellwidth()
DIM SHARED StoreCol(1 TO 255)
DIM SHARED ChkStore(1 TO 255)
DIM SHARED Cellwidth(1 TO 255)
DIM SHARED Row2
DIM SHARED Column
DIM SHARED Colnum
DIM SHARED length
DIM SHARED Col2
DIM SHARED row
DIM SHARED Filename$
DIM SHARED Aspace$
DIM SHARED Filenum                      'the file number to use
DIM SHARED Cellfmt AS STRING * 1        'allows reading one byte
DIM SHARED info$
DIM SHARED Extra
DIM SHARED Globewidth
DIM SHARED Declen AS SINGLE

Aspace$ = " "
Filename$ = ""
Filename2$ = ""

CLS
Cmdline$ = UCASE$(COMMAND$)
IF LEN(Cmdline$) < 1 THEN GOTO Start
ON ERROR GOTO Start
test$ = LEFT$(Cmdline$, 1)
Place = 1

WHILE test$ <> Aspace$
	IF Place > LEN(Cmdline$) THEN GOTO OUTNAME1
	Filename$ = Filename$ + test$
	IF test$ = "." THEN FILE$ = LEFT$(Filename$, LEN(Filename$) - 1)
	Place = Place + 1
	test$ = MID$(Cmdline$, Place, 1)
WEND

OUTNAME1:

IF LEN(FILE$) < 1 THEN GOTO Start
FILE$ = ""
Place = Place + 1
test$ = MID$(Cmdline$, Place, 1)
ON ERROR GOTO SecondHeader

WHILE test$ <> Aspace$
	IF Place > LEN(Cmdline$) THEN GOTO OUTNAMES
	Filename2$ = Filename2$ + test$
	IF test$ = "." THEN FILE$ = LEFT$(Filename$, LEN(Filename$) - 1)
	Place = Place + 1
	test$ = MID$(Cmdline$, Place, 1)
WEND

OUTNAMES:
Filename2$ = LTRIM$(RTRIM$(Filename2$))
IF LEN(Filename2$) < 1 THEN GOTO SecondHeader
CLS
LOCATE 1, 1
PRINT "123TOASC           Version 1.02b      April 19, 1990             By:Larry Hupman"
LOCATE 3, 53
PRINT "{NOTE: To Exit, Press Enter}"
LOCATE 5, 1
PRINT "Enter name of Lotus file to read: "; Filename$
LOCATE 7, 1
PRINT "Enter name of Ascii File to write: "; Filename2$


GOTO CommandStart

Start:
Row2 = 0
DO
   VIEW PRINT 1 TO 24
   CLS
   LOCATE 9, 1
   ON ERROR GOTO ErrorHandler
   FILES "*.W??"
header:
   VIEW PRINT 1 TO 8
   CLS 2
   LOCATE 1, 1
   PRINT "123TOASC           Version 1.02b      April 19, 1990             By:Larry Hupman"
   LOCATE 3, 53
   PRINT "{NOTE: To Exit, Press Enter}"
   LOCATE 5, 1
   INPUT "Enter name of Lotus file to read: ", Filename$
   IF LEN(Filename$) < 1 THEN
   SYSTEM
   END IF
   Filenum = 1                      'obtain the next available file handle
   OPEN Filename$ FOR BINARY AS #1   'open the file for Binary access
   GET 1, , Opcode        'get the next opcode
   IF EOF(1) THEN
	  BEEP: BEEP
	  PRINT : PRINT "*** "; Filename$; " does not exist! ***"
	  INPUT "PRESS ANY KEY TO CONTINUE", i$
	  RESET
	  KILL Filename$
	  GOTO Start
   END IF
   GET 1, , length        'and the length of the data that follows
   GET 1, , Integ   'Integ holds the version number
   'PRINT Opcode
   'PRINT Integ
   'INPUT i$
   IF Integ < 1028 OR Integ > 1030 AND Integ <> 2571 AND Integ <> 8711 THEN   'test this if you want
	  BEEP: BEEP
	  PRINT : PRINT "*** "; Filename$; " is NOT a Lotus File! ***"
	  INPUT "PRESS ANY KEY TO CONTINUE", i$
	  RESET
	  GOTO Start
   END IF
LOOP UNTIL LEN(Filename$)
RESET
SecondHeader:
DO
   VIEW PRINT 1 TO 24
   CLS
   LOCATE 1, 1
   PRINT "123TOASC           Version 1.02b      April 19, 1990             By:Larry Hupman"
   LOCATE 3, 53
   PRINT "{NOTE: To Exit, Press Enter}"
   LOCATE 5, 1
   PRINT "Enter name of Lotus file to read: "; Filename$
   LOCATE 7, 1
   INPUT "Enter name of Ascii File to write: ", Filename2$
   IF LEN(Filename2$) < 1 THEN
	  SYSTEM
   END IF
LOOP UNTIL LEN(Filename2$)
 
CommandStart:
Filenum = 1                      'obtain the next available file handle
OPEN Filename$ FOR BINARY AS #1   'open the file for Binary access
OPEN Filename2$ FOR OUTPUT AS #2
Extra = 0
ok = 1

DO UNTIL Opcode = 1                     'until the Lotus "End of File" Opcode

   GET 1, , Opcode        'get the next opcode
   'PRINT Opcode
   'pRINT "hi"
   GET 1, , length        'and the length of the data that follows
   SELECT CASE Opcode           'handle the data according to its type
	   CASE 0
	   GET 1, , Integ   'Integ holds the version number
	   IF Integ < 1028 OR Integ > 1030 AND Integ <> 2571 AND Integ <> 8711 THEN   'test this if you want
		BEEP: BEEP
		PRINT : PRINT : PRINT Filename$; " is NOT a Lotus File!"
		PRINT #2, "NOT a Lotus File !"
		END
	   END IF
	   SELECT CASE Integ              '  information in this record
		  CASE 1028
			   Version = 1028 ' Version 1A
		  CASE 1029
			   Version = 1029 ' Symphony 1.0
		  CASE 1030
			   Version = 1030 ' Version 2, Symphony 1.1, VP Planner
		  CASE 2571
			   Version = 2571 'Quattro
		  CASE 8711
			   Version = 8711 'Twin
	  END SELECT
	
	 CASE 7
	  Dummy$ = SPACE$(length)        'skip over the unwanted record
	  
	  GET Filenum, , one1
	  GET Filenum, , one2
	  GET Filenum, , GlobeFormat
	  GlobeFormat$ = HEX$(GlobeFormat)
	  IF LEN(GlobeFormat$) = 1 THEN
		 GlobeFormat1$ = "0"
	  ELSE
		 GlobeFormat1$ = LEFT$(GlobeFormat$, 1)
	  END IF
	  IF GlobeFormat1$ = "7" THEN
		 GlobeFormat2$ = "0"
	  ELSE
		 GlobeFormat2$ = RIGHT$(GlobeFormat$, 1)
	  END IF
	  GET Filenum, , Globewidth

	  Testwidth = Globewidth
	  Dummy$ = SPACE$(length - LEN(one1) - LEN(one2) - LEN(Globewidth) - LEN(GlobeFormat))
	  GET Filenum, , Dummy$


	 CASE 8                  ' COLW1 - Contains width of column in window one
	  Dummy$ = SPACE$(2)        'skip over the unwanted record
	 
	  GET Filenum, , Dummy$
	  Colnum = ASC(Dummy$)
	  Dummy$ = SPACE$(1)        'skip over the unwanted record
	
	  GET Filenum, , Dummy$
	  Cellwidth(Colnum + 1) = ASC(Dummy$)
		 

	 CASE 12                   'Blank - NOTE: Lotus saves blank cells only
							   '  if they are formatted or protected
	 GetFormat Format, row, Column
	 Globewidth = Testwidth
	 IF Cellwidth(Column + 1) < 1 THEN
		Blanknum = Globewidth
	 ELSE
		Blanknum = Cellwidth(Column + 1)
	 END IF
	 Dummy$ = ""
	 FOR i = 1 TO Blanknum
		 Dummy$ = Dummy$ + Aspace$
	 NEXT i
	 PRINT #2, Dummy$;

	 CASE 13                   'Integer
	 GetFormat Format, row, Column
	 IF Cellwidth(Column + 1) = 0 THEN Cellwidth(Column + 1) = Globewidth
	 GET Filenum, , Integ
	 IF Testwidth = 0 THEN Globewidth = LEN(Integ)
	 Integ$ = ""
	 Integ$ = RTRIM$(LTRIM$(STR$(Integ)))
	 IF Format >= 242 AND Format <= 249 OR Format = 121 THEN
		 Number# = Integ
		 GOSUB MakeDate
	 END IF
	 IF Format < 242 AND Format <> 121 OR Format > 249 THEN
		Number# = 0
		GOSUB SetFormat
		set$ = LTRIM$(RTRIM$(set$))
		PRINT #2, USING set$; Integ;
		PRINT #2, " ";
	 END IF

	 CASE 14
	 GetFormat Format, row, Column
	 GET Filenum, , Number#
	 Number$ = ""
	 Number$ = LTRIM$(STR$(Number#)) + Aspace$
	 IF Testwidth = 0 THEN Globewidth = LEN(Number#)
	 IF Format >= 242 AND Format <= 249 OR Format = 121 THEN
		 GOSUB MakeDate
	 END IF
	 IF Format < 242 AND Format <> 121 OR Format > 249 THEN
		 GOSUB SetFormat
		 IF Format1$ = "B" THEN Number# = Number# * 100
		 PRINT #2, USING set$; Number#;
		 IF Format1$ = "B" THEN   'Percent Formulas
			PRINT #2, "%";
		 ELSE
			PRINT #2, " ";
		 END IF
	 END IF

	 CASE 15                   'Label
	 GetFormat Format, row, Column
	 IF Testwidth = 0 THEN Globewidth = length - 7
	 IF Cellwidth(Column + 1) = 0 THEN Cellwidth(Column + 1) = Globewidth
	 info$ = SPACE$(length - 6)     'create a string to hold the label
									' is subtracted to exclude the
									'  Format, Column, Row, and 0 bytes
									'  that were included in the original
									'  length byte (already gotten by the
									'  GetFormat routine)
	 GET Filenum, , info$           'get the label text
	 GET Filenum, , Cellfmt$        'gobble up the trailing CHR$(0) byte
	 IF LEN(info$) = 1 THEN info$ = info$ + Aspace$
	 IF Extra > 0 THEN
		IF Extra > LEN(info$) THEN
			Extra = Extra - LEN(info$)
		ELSE
			Extra = 0
		END IF
		IF LEN(RTRIM$(LTRIM$(info$))) = 0 THEN
			ok = 0
		ELSE
			ok = 1
		END IF
	 END IF
	 IF LEFT$(info$, LEN(info$) - (LEN(info$) - 1)) = "\" THEN 'Repeating Symbol
		info2$ = RIGHT$(info$, LEN(info$) - 1)
		info$ = ""
		FOR i = 1 TO Cellwidth(Column + 1)
		   info$ = LTRIM$(info$) + info2$
		NEXT i
		
	 ELSEIF ASC(LEFT$(info$, LEN(info$) - (LEN(info$) - 1))) = 34 THEN 'Right Justified
		rinfo$ = ""                                    ' Label
		info$ = RIGHT$(info$, LEN(info$) - 1)
		IF LEN(info$) > Cellwidth(Column + 1) THEN
			   Extra = LEN(info$) - Cellwidth(Column + 1)
		END IF
		IF LEN(info$) < Cellwidth(Column + 1) THEN
			FOR i = 1 TO (Cellwidth(Column + 1) - LEN(info$) - 2)
				rinfo$ = rinfo$ + Aspace$
			NEXT i
		END IF
		info$ = rinfo$ + info$ + Aspace$
		IF (Cellwidth(Column + 1) - LEN(info$)) MOD 2 = 1 THEN info$ = info$ + Aspace$
	 ELSEIF ASC(LEFT$(info$, LEN(info$) - (LEN(info$) - 1))) = 94 THEN 'Centered
		rinfo$ = ""                                      'Label
		info$ = RIGHT$(info$, LEN(info$) - 1)
		IF LEN(info$) > Cellwidth(Column + 1) THEN
			   Extra = LEN(info$) - Cellwidth(Column + 1)
		END IF
		IF LEN(info$) < Cellwidth(Column + 1) THEN
			FOR i = 1 TO INT(((Cellwidth(Column + 1) - LEN(info$)) / 2))
				rinfo$ = rinfo$ + Aspace$
			NEXT i
		END IF
		info$ = rinfo$ + info$ + rinfo$
		IF (Cellwidth(Column + 1) - LEN(info$)) MOD 2 = 1 THEN
			info$ = info$ + Aspace$
		END IF
	 ELSE
		info$ = RTRIM$(RIGHT$(info$, LEN(info$) - 1))     'Left Justified Labels
		IF LEN(info$) > Cellwidth(Column + 1) THEN
			   Extra = LEN(info$) - Cellwidth(Column + 1)
		END IF
		IF LEN(info$) < Cellwidth(Column + 1) THEN
			FOR i = 1 TO (Cellwidth(Column + 1) - LEN(info$))
				info$ = info$ + Aspace$
			NEXT i
		END IF
		IF (Cellwidth(Column + 1) - LEN(info$)) MOD 2 = 1 THEN info$ = info$ + Aspace$
		IF ChkStore(Column + 1) = length - 7 AND ChkStore(Column + 1) <> StoreCol(Column + 1) THEN StoreCol(Column + 1) = length - 7
		ChkStore(Column + 1) = length - 7
		IF StoreCol(Column + 1) <= length - 7 THEN StoreCol(Column + 1) = length - 7
	 END IF
	 IF ok = 1 THEN PRINT #2, info$;


	 CASE 16                   'Formula
	 GetFormat Format, row, Column
	 GET Filenum, , Number#         'get the cell's value
	 IF Testwidth = 0 THEN Globewidth = LEN(Number#)
	 IF Cellwidth(Column + 1) = 0 THEN Cellwidth(Column + 1) = Globewidth
	 GET Filenum, , length          'get length of formula "text"
	 SEEK Filenum, SEEK(Filenum) + length   'skip over the formula
					'the formula is "tokenized" in reverse
					'Polish notation - not a pretty story
   
	  IF Format >= 242 AND Format <= 249 OR Format = 121 THEN
		 GOSUB MakeDate
	  END IF
	  IF Format < 242 AND Format <> 121 OR Format > 249 THEN
		IF Testwidth = 0 THEN Globewidth = LEN(Number#)
		GOSUB SetFormat
		IF Format1$ = "B" THEN Number# = Number# * 100
		PRINT #2, USING set$; Number#;
		IF Format1$ = "B" THEN   'Percent Formulas
			PRINT #2, "%";
		ELSE
			PRINT #2, " ";
		END IF
	  END IF
	 
	  CASE ELSE                 'anything else merely relates to the way the
				'  spreadsheet operates (recalc order, print
				'  ranges, and so forth)
	  Dummy$ = SPACE$(length)        'skip over the unwanted record
	  GET Filenum, , Dummy$

   END SELECT


   Cntr = Cntr + 1
LOOP
	  LOCATE 17, 1
	  PRINT
	  PRINT "Conversion Done!"
	  PRINT
	  PRINT "Number of Rows Processed ="; row

CLOSE
Leaving:
SYSTEM



SetFormat:
	 Declen = 0
	 Longwidth = 0
	 IF Cellwidth(Column + 1) = 0 THEN Cellwidth(Column + 1) = Globewidth
	 IF Cellwidth(Column + 1) > 25 THEN
		Longwidth = Cellwidth(Column + 1)
		Cellwidth(Column + 1) = 25
		FOR i = 1 TO Longwidth - 25
			PRINT #2, Aspace$;
		NEXT i
	 END IF
	 Format$ = HEX$(Format)

	 IF LEN(Format$) = 1 THEN
		Format1$ = "0"
	 ELSE
		Format1$ = LEFT$(Format$, 1)
	 END IF
	 IF Format1$ = "7" THEN
		 Format2$ = "0"
	  ELSE
		 Format2$ = RIGHT$(Format$, 1)
	  END IF
	 IF Format1$ = "F" OR Format1$ = "7" AND Format2$ = "F" THEN
		Format1$ = GlobeFormat1$
		Format2$ = GlobeFormat2$
	 END IF
	 IF Format2$ = "0" AND Format1$ = "7" THEN
		IF Number# <> 0 THEN
			IF Number# - INT(Number#) > 0 THEN
				Declen = Number# - INT(Number#)
				Declen = LEN(LTRIM$(RTRIM$(STR$(Declen)))) - 1
				IF Declen > 6 THEN Declen = 6
				Format2$ = STR$(Declen)
				Format2$ = LTRIM$(RTRIM$(Format2$))
			END IF
		END IF
	 END IF
	 set$ = Aspace$
	 FOR i = 1 TO (Cellwidth(Column + 1)) - 4
		set$ = "#" + LTRIM$(set$)
		IF i = 1 THEN
			IF Format2$ = "1" THEN
			   set$ = "." + LTRIM$(set$)
			   i = i + 1
			END IF
		END IF
		IF i = 2 THEN
			IF Format2$ = "2" THEN
			   set$ = "." + LTRIM$(set$)
			   i = i + 1
			END IF
		END IF
		IF i = 3 THEN
			IF Format2$ = "3" THEN
			   set$ = "." + LTRIM$(set$)
			   i = i + 1
			END IF
		END IF
		IF i = 4 THEN
			IF Format2$ = "4" THEN
			   set$ = "." + LTRIM$(set$)
			   i = i + 1
			END IF
		END IF
		IF i = 5 THEN
			IF Format2$ = "5" THEN
			   set$ = "." + LTRIM$(set$)
			   i = i + 1
			END IF
		END IF
		IF i = 6 THEN
		   IF Format2$ = "6" THEN
			   set$ = "." + LTRIM$(set$)
			   i = i + 1
		   END IF
		END IF
	 NEXT i
	 set$ = LTRIM$(RTRIM$(set$))
	 IF Format1$ <> "B" AND Format1$ <> "8" AND Format1$ <> "0" AND Format1$ <> "7" THEN
		 set$ = "," + LTRIM$(set$)
	 ELSE
		 set$ = "#" + LTRIM$(set$)
	 END IF
	
	 IF Format1$ = "2" OR Format1$ = "A" THEN
		set$ = "$$" + LTRIM$(set$)
	 ELSE
		set$ = "##" + LTRIM$(set$)
	 END IF
	 IF Longwidth <> 0 THEN Cellwidth(Column + 1) = Longwidth
RETURN



MakeDate:
	 IF Format >= 242 AND Format <= 249 OR Format = 121 THEN
		Number# = INT(Number#)
		month = INT(Number# - INT(Number# / 365.25) * 365.25)
		IF month > 0 AND month <= 31 THEN
		   month$ = "Jan"
		   Day$ = STR$(month)
		   'PRINT month: INPUT i$
		END IF
		IF month > 31 AND month <= 59 THEN
		   month$ = "Feb"
		   Day$ = STR$(month - 31)
		END IF
		IF month > 59 AND month <= 90 THEN
		   month$ = "Mar"
		   Day$ = STR$(month - 59)
		END IF
		IF month > 90 AND month <= 120 THEN
		   month$ = "Apr"
		   Day$ = STR$(month - 90)
		END IF
		IF month > 120 AND month <= 151 THEN
		   month$ = "May"
		   Day$ = STR$(month - 120)
		END IF
		IF month > 151 AND month <= 181 THEN
		   month$ = "Jun"
		   Day$ = STR$(month - 151)
		END IF
		IF month > 181 AND month <= 212 THEN
		   month$ = "Jul"
		   Day$ = STR$(month - 181)
		END IF
		IF month > 212 AND month <= 243 THEN
		   month$ = "Aug"
		   Day$ = STR$(month - 212)
		END IF
		IF month > 243 AND month <= 273 THEN
		   month$ = "Sep"
		   Day$ = STR$(month - 243)
		END IF
		IF month > 273 AND month <= 304 THEN
		   month$ = "Oct"
		   Day$ = STR$(month - 273)
		END IF
		IF month > 304 AND month <= 334 THEN
		   month$ = "Nov"
		   Day$ = STR$(month - 304)
		END IF
		IF month > 334 AND month <= 365 THEN
		   month$ = "Dec"
		   Day$ = STR$(month - 334)
		END IF
		IF INT(Number# / 365.25) MOD 4 = 0 THEN
		IF month > 0 AND month <= 31 THEN
		   month$ = "Jan"
		   Day$ = STR$(month)
		   'PRINT month
		END IF
		IF month > 31 AND month <= 60 THEN
		   month$ = "Feb"
		   Day$ = STR$(month - 31)
		END IF
		IF month > 60 AND month <= 91 THEN
		   month$ = "Mar"
		   Day$ = STR$(month - 60)
		END IF
		IF month > 91 AND month <= 121 THEN
		   month$ = "Apr"
		   Day$ = STR$(month - 91)
		END IF
		IF month > 121 AND month <= 152 THEN
		   month$ = "May"
		   Day$ = STR$(month - 121)
		END IF
		IF month > 152 AND month <= 182 THEN
		   month$ = "Jun"
		   Day$ = STR$(month - 152)
		END IF
		IF month > 182 AND month <= 213 THEN
		   month$ = "Jul"
		   Day$ = STR$(month - 182)
		END IF
		IF month > 213 AND month <= 244 THEN
		   month$ = "Aug"
		   Day$ = STR$(month - 213)
		END IF
		IF month > 244 AND month <= 274 THEN
		   month$ = "Sep"
		   Day$ = STR$(month - 244)
		END IF
		IF month > 274 AND month <= 305 THEN
		   month$ = "Oct"
		   Day$ = STR$(month - 274)
		END IF
		IF month > 305 AND month <= 335 THEN
		   month$ = "Nov"
		   Day$ = STR$(month - 305)
		END IF
		IF month > 335 AND month <= 366 THEN
		   month$ = "Dec"
		   Day$ = STR$(month - 335)
		END IF
		END IF
		Day$ = RTRIM$(LTRIM$(Day$))
		IF VAL(Day$) < 1 THEN Day$ = "1"
		Day2$ = Day$
		IF VAL(Day$) < 10 THEN Day$ = "0" + LTRIM$(STR$(VAL(Day2$)))
		Day$ = RTRIM$(LTRIM$(Day$))
		IF Cellwidth(Column + 1) > 10 THEN
			FOR i = 1 TO (Cellwidth(Column + 1)) - 10
				PRINT #2, " ";
			NEXT i
		END IF
	   
	   
		PRINT #2, Day$ + "-" + month$ + "-" + RTRIM$(LTRIM$(STR$(INT(Number# / 365.25)))) + " ";
	   
END IF
RETURN






ErrorHandler:
  IF ERR = 53 THEN
	  PRINT
	  PRINT "No files with WKS or WK1 extensions in this Directory."
	  RESUME header
  ELSEIF ERR = 64 THEN
	  PRINT
	  PRINT "File Name you Typed was Too Long.  Try Again"
	  RESUME header
  ELSE
	  PRINT "Unrecoverable Error--"; ERR
	  CLOSE
	  SYSTEM
  END IF

SUB GetFormat (Format, row, Column)
	  chko = 0
	  Col2 = Column
	  GET Filenum, , Cellfmt$: Format = ASC(Cellfmt$)
	  GET Filenum, , Column
	  GET Filenum, , row
	  IF row <> Row2 THEN
		LOCATE 12, 25: PRINT "Converting Row "; row; " of "; Filename$
		Col2 = -1
		ok = 1
		Extra = 0
		WHILE Row2 < row        'Write out any blank rows
		  PRINT #2,
		  Row2 = Row2 + 1
		WEND

	  END IF
	  Row2 = row
	  IF row = Row2 THEN
		 WHILE Col2 + 2 < Column + 1      'write out blank columns
				 IF Cellwidth(Col2 + 2) = 0 THEN Cellwidth(Col2 + 2) = Globewidth
				 info$ = ""
				 IF Extra < Cellwidth(Col2 + 2) THEN
					FOR i = 1 TO (Cellwidth(Col2 + 2) - Extra)
						info$ = info$ + " "
					NEXT i
					Extra = 0
					ok = 1
				END IF
				IF Extra >= Cellwidth(Col2 + 2) THEN     ' Allow for cells
					Extra = Extra - Cellwidth(Col2 + 2)  ' to "bleed" into
					ok = 0                               'other cells
				END IF
				IF ok = 1 THEN PRINT #2, info$;
				Col2 = Col2 + 1
		 WEND
	  END IF
	  IF chko = 1 THEN Column = Column - 1
END SUB

