//------------------------------------------------------------------------
// Last update: 22 Feb 2000
// see help file for info on this parser

#include <stdlib.h>
#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <mem.h>
#include <dos.h>
#include <conio.h>
#include "parse.h"
#include "labels.h"
#include "farvars.h"
#define DELIMITER 1
#define VARIABLE 2
#define NUMBER 3
#define FORMULA 4
#define TEXT 5
#define FUNCTION 6
//------------------------------------------------------------------------
static unsigned int emmhandle;
static unsigned int pageframe;
static unsigned int f_emmpage;
//------------------------------------------------------------------
//Store a string in expanded memory
// buf = the string
// line = the c # of the line in mem
//        each line resides within a field of 300 bytes
void Parse::StoreString(char *buf, unsigned int line)
{

	long int sheet_mem = (long int ) line*300L;
	unsigned int emmpage = sheet_mem /16200L;      //16200 = 54*300
	unsigned pos_w = (line%54)*300;    //pos to write into

  asm {
	 push es
	 push si
	 push di

	 mov bx, emmpage
	 cmp bx, f_emmpage
	 jz  h1          //the page is already mapped in  from previous time.
	 mov f_emmpage, bx
	 mov ah, 44h
	 mov dx, emmhandle
	 mov al, 0
	 int 67h }             //map into physical page 0
	 //our logical page is mapped into say $e000
	 //store the string at the correct location in phisical mem
h1:asm{
	 cld
	 mov cx, 150    //300 bytes
	 mov di, pos_w
	 mov es, pageframe
	 mov si, buf
	 rep movsw
	 pop di
	 pop si
	 pop es }

}
//------------------------------------------------------------------
//Fetch a string from expanded memory
//each string resides within a field of 300 bytes
//Entry:
// 	buf = the string
// 	line = the c # of the line to fetch
//Exit:
void Parse::FetchString(char *buf, unsigned int line)
{


	long int sheet_mem = (long int ) line*300L;
	unsigned int emmpage = sheet_mem /16200;      //16200 = 54*300
	unsigned pos_w = (line%54) *300;    //pos to write into

	asm {
	 push ds
	 push es
	 push si
	 push di
	 mov bx, emmpage
	 cmp bx, f_emmpage
	 jz h1 				//the page is already mapped in from previous time
	 mov f_emmpage, bx
	 mov ah, 44h
	 mov dx, emmhandle
	 mov al, 0
	 int 67h }             //map into physical page 0
	 //our logical page is mapped into say $e000
	 //store the string at the correct location in phisical mem
h1:asm{
		cld
		mov cx, 150       //300 bytes
		mov si, pos_w
		mov di, buf
		push ds
		pop es
		mov ds, pageframe
		rep movsw        //get from ds:[si]
							  //store in es:[di]

		pop di
		pop si
		pop es
		pop ds
		}

		return;
}
//------------------------------------------------------------------


//-------------------------------------------------------------------
//deallocates the 96 pages that were previously allocated
void Parse::DeallocatePages()
{
	if(allocated)
	{
		asm{
			mov dx, emmhandle
			mov ah, 45h     //deallocate
			int 67h
			}
	 }
}

//----------------------------------------------------------------------
int Parse::IsEMMInstalled()
{
	unsigned int pages;
	char *EMM_dev_name = {"EMMXXXX0"};
	int result =0;

	f_emmpage =65535;    //dummy value to make it different from
								//mempage
asm{
	push es
	push di
	push si

	mov ah, 35h    //Dos Function 35h Get Interrupt
	mov al, 67h    //Int 67h vector
	int 21h

	mov di, 000ah  //es:000A must point to the device name

	mov si, EMM_dev_name
	mov cx, 3
	rep cmpsb       //compare strings
	jne ex
	//there is an EMM driver installed. Is it version 4
	mov ah, 46h
	int 67h      //get version
	cmp al, 40h    //Earlier than 4.0
	jb ex         //old version
	//its EMM manager version 4 or above
	//are there enough pages?
	mov ah, 42h
	int 67h         //get page count
	or ah, ah       //ah = 0?
	jnz ex           //error
	cmp bx, 125      //are there 125 pages available?
	jb ex          //no expended mem left


	mov ah, 43h
	mov pages, bx
	//grab all available expanded memory
	//bx = the number of pages
	int 67h
	or ah, ah
	jnz ex;
	mov emmhandle, dx      // store handle
	//ask the driver where the physical addr of the page frame is.
	mov ah, 41h
	int 67h
	or ah, ah
	jnz ex;
	mov pageframe, bx}	//store page frame segment

	result++;         //set flag: pages successfully allocated

	y100 = (pages * 54) /52;   //=total # of lines in sheet
	if(y100>800) y100 = 800;   //the same again in the clipboard
ex:
asm{
	pop si
	pop di
	pop es }


	allocated = result;
	return result;
}
//-------------------------------------------------------------------------

//-----------------------------------------------------------------------
int Parse::RightTrim(char *buf)
{
	int len, t, found;
	char *p, *p2;

	len = strlen(buf);
	if(!len) return 0;
	p = &buf[len-1];
	found =0;
	for(t = len; t> 0; t--){
		if(!isspace(*p)) {found = 1; break;}  //found a non-space
		p--;
	}
	if(!found)    //no non-spaces found, (string is all spaces)
	{              //so del string
		buf[0] =0;
		return 0;
	}

	if(p == &buf[len-1]) return len; //no space at beginning of string to cut

	len = (p - buf) +1;
	buf[len] =0;         //cut suffix white spaces from buf
	return len;
}
//------------------------------------------------------------------------
//Format a double floating point number and store it in a string
//Entry:
//  buf = the result stored here
//  num = the number to format
//  decplaces = the r # of digits after the decimal point
//              this can be from 0 upwards
//              if 0 no decimal point is displayed.
//              the result is always rounded
//  commas = 1 if commas are to be included in the string
int Parse::Number(char *buf, double num, int decplaces, int commas)
{

	int pos, d = decplaces;
	int success =1;                 // assume job was successful
	char temp[20], *p;
	p = temp+10;

	itoa(d, p, 10);         //convert decplaces to a single char digit 0-9
	if(decplaces <0 || decplaces >9)
	{
		d = 0;
		success =0;
		strcpy(temp, "%.2lf");
	}
	else
	{
		strcpy(temp, "%.2lf");  //format template
		temp[2] = *p;           //insert the user's digit specifier
	}

	sprintf(buf, temp, num);

	if(commas)
	{
		pos = strcspn(buf, ".");
		while (pos > 3)
		{
			pos -= 3;
			if (buf[pos - 1] != '-')
			{
				movmem(&buf[pos], &buf[pos + 1], strlen(buf) - pos + 1);
				buf[pos] = ',';
			}
		}
	}

	return success;  //0 = if not successful
}
//-------------------------------------------------------------------------




//-------------------------------------------------------------------------
enum double_ops {LT=1, LE, GT, GE, EQ, NE};
char relops[7] = {LT, LE, GT, GE, EQ, NE, 0};
//-------------------------------------------------------------------------
//Add extra function names to this list
char function_list[][12] =
{
	"ABS",
	"ACOS",
	"IF",
	"Pmtc",
	"Sum",
	"Choose",
	"Irate",
	"Type",      //return the type of the cell -1 = error, 0 = blank
					//1 = text 2 = numeric
	"Eff",
	"COS",
	"SIN",
	"TAN",
	"LN",
	"LOG",
	"EXP",
	"Str",
	"Strcat",
	"Strcmp",
	"Bigdays",
	"Today",
	"Easter",
	"Getdate",
	"Int",
	"NPV",
	"IRR",
	"Pv",
	"Fv",
	"Term",
	"CTerm",

	"Count",
	"Min",
	"Max",
	"Avg",
	"DDB",
	"SLN",
	"SYD",
	"SQRT",
	"VAR",
	"STD",
	"RATE",
	"ROUND",
	"RAND",
	"StrCat1",
	"PI",
	"Mod",
	"Nom",   //Eff to nominal rate
	"\0"    //end of list marker
};

//--------------------------------------------------------------------------

//--------------------------------------------------------------------------
//initialise the array of pointers to NULLs
Parse::Parse()
{
	unsigned int t, f, y;
	char ch;
	char buf[10];
	f = 1; //assume scccess opening file
	Cell j;
	errnum =0;

	if(!IsEMMInstalled())
	{
		clrscr();
		gotoxy(12, 6);
		printf("Matrix needs at least 2MBs of expanded memory to run.\n");
		gotoxy(12,7);
		printf("If Matrix is running under Windows 95/98 right click on\n");
		gotoxy(12, 8);
		printf("this program's icon, then go to the properties setting\n");
		gotoxy(12, 9);
		printf("and click on the memory tab, then set the Expanded \n");
		gotoxy(12, 10);
		printf("(EMS) memory to 'Auto', then run Matrix again.\n");
		gotoxy(12, 11);
		printf("\n");
		exit(1);

	}

	//create blank file
	memset(packed, '!', 282);
	packed[282] =0;

	//for(t = 0; t<(y100*26*2); t++) StoreString(packed, t);

	for(t = 0; t<(y100*26); t++)
	{
		itoa(t/26+1, &j.cell_name[1], 10);
		j.cell_name[0] = (t%26) +'A';
		j.answer.type =0;                   //type blank
		j.answer.errnum =0;
		Store(&j);
	}



ex:
	row = 1;  //current row, col in the spreadsheet array
	col = 1;  //there are 26 columns and 100 rows

	num_funcs = 0;

	while(function_list[num_funcs][0]) num_funcs++;
	//leave sheet file open for use by other functions
}
//-------------------------------------------------------------------------
//free the memory that was reserved, nulling the array of pointers
Parse::~Parse()
{
	DeallocatePages();       //free EMM memory
}
//-------------------------------------------------------------------------
// This function rounds a number to a certain number of digits
// after the decimal point
// Enter:
//  v = number to round
//  p = percision
// Example:
//  x = Percision(12.453, 2);        x = 12.45
double Parse::Precision(double v, int p)
{
	double dec[10] = {1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
	double x, result;


	x= v * dec[p] +.5;
	modf(x, &result);  result = result / dec[p];

	return result;
}
//------------------------------------------------------------------------
//Search the function names list to see if there is a function name
//matching the one in the entry var: name
// if so return the r # of that function
// else return 0
int Parse::FindFunction(char *name)
{
	int t, result =0;
	char temp[20];
	strcpy(temp, name);


	for(t = 0; t < num_funcs; t++)
	{
		if(!stricmp(name, &(function_list[t][0]))) //if match found
		{
			result = t+1;
			break;
		}

	}

	return result;
}
//-------------------------------------------------------------------------
//Store the cell in the file at the position indicated
//by its name. And set the sheet array to indicate its type
void Parse::Store(Cell *i, int clip)
{
	unsigned int base=0;
	if(clip) base = y2600;

	unsigned int lt, l, cx, cy;
	char *p;
	char *endptr;
	ScreenCell *sc;

	lt = 282;
	memset(packed, ' ', 282);
	packed[282] =0;


	switch(i->answer.type)
	{
		case 0:  //blank
			strcpy(i->answer.text, " ");
			strcpy(i->input, "Empty");
			i->answer.numeric = 0.0L;
			i->answer.errnum  =0;
			break;

		case 2:  //numeric
			strcpy(i->answer.text, " ");
			i->answer.errnum =0;
			break;

		case 1:  //text
			i->answer.numeric =0.0L;
			i->answer.errnum =0;
			break;

		default:
			strcpy(i->answer.text, "Error");
			i->answer.numeric = 1.0L;
	}

	if(i->answer.type <0) packed[0] = '-';
	packed[1] = abs(i->answer.type)+ '0';
	sprintf(&packed[2], "%2d", abs(i->answer.errnum));
	sprintf(&packed[4], "%.9lf", i->answer.numeric);
	l = strlen(packed);
	packed[l] = ' ';
	strcpy(&packed[34], i->answer.text);
	l = strlen(packed);
	packed[l] = ' ';
	strcpy(&packed[154], i->input);


	memcpy(&ce, i, sizeof(Cell));
	//given a cell name, compute index
	cx = toupper(*(i->cell_name)) - 'A';
	p = &(i->cell_name[1]);
	cy = (atoi(p)-1);

	StoreString(packed, base+(cy*26)+cx);

	ce.answer.type = packed[1]- '0';
	if(packed[0] == '-') ce.answer.type = -ce.answer.type;


	strcpy(ce.input, &packed[154]);
	packed[154] =0;
	strcpy(ce.answer.text, &packed[34]);
	packed[34] =0;
	ce.answer.numeric = strtod(&packed[4], &endptr);
	packed[4] =0;
	ce.answer.errnum = atoi(&packed[2]);
	ce.cell_name[0] = 'A'+ cx;
	itoa(cy+1, &(ce.cell_name[1]), 10);

	sc = sheet[base+(cy*26)+cx];       //get pointer to this cells properties
	sc->u.type = ce.answer.type;  //set the type
	sheet(base+(cy*26)+cx, sc);        //store the updated properties for this cell

}
//-------------------------------------------------------------------------
//Delete a cell from the sheet
void Parse::Delete(Cell *i)
{

	i->answer.type =0;
	i->answer.errnum =0;
	Store(i);

}
//-------------------------------------------------------------------------
//find and return a cell from the file sheet
Cell *Parse::Find(char *cell_name, int clip)
{

	unsigned int base=0;
	if(clip) base = y2600;
	ScreenCell *sc;
	char *p, *endptr;
	unsigned int cx, cy, l, t, loc, lt = 282;

	memset(packed, ' ', 282);
	packed[282] =0;

	if(errnum) return NULL;
	cx = toupper(*(cell_name)) - 'A';
	p = cell_name+1;
	if(*p == '$') p++;      //skip past absolute reference to a row number
	cy =(atoi(p) -1);

	if(cy*26+cx >=(y100*26) || (cy*26+cx) <0)
	{
		serror(7);              //Cell out of range
		return NULL;
	}


	FetchString(packed, base+(cy*26)+cx);

	ce.answer.type = packed[1]- '0';
	if(packed[0] == '-') ce.answer.type = - ce.answer.type;


	if(packed[154])
	{
		strcpy(ce.input, &packed[154]);
	}
	else
		strcpy(ce.input, " ");
	packed[153] =0;
	strcpy(ce.answer.text, &packed[34]);
	packed[34] =0;
	ce.answer.numeric = strtod(&packed[4], &endptr);
	packed[4] =0;
	ce.answer.errnum = atoi(&packed[2]);
	ce.cell_name[0] = 'A'+ cx;
	itoa(cy+1, &(ce.cell_name[1]), 10);

	sc = sheet[base+(cy*26)+cx];       //get pointer to this cells properties
	sc->u.type = ce.answer.type;  //set the type
	sheet(base+(cy*26)+cx, sc);        //store the updated properties for this cell


	//if(!ce.answer.type) ce.input[0] =0;  //if empty cancle formula

	return &ce;

}
//-------------------------------------------------------------------------

Cell *Parse::eval_exp(char *linebuf1, int c, int r)
{

	Cell *adr, j;
	assumetext =0;        //don't default expression line to text yet


	adr = eval_exp0(linebuf1, c, r);
	if(adr ==NULL) goto h;
	if(assumetext)
	{
		adr = eval_exp0(linebuf1, c, r);
		adr->answer.type = 1;              //text type
		adr->answer.errnum =0;
		strcpy(adr->answer.text, linebuf1);
	}

	else
	{
		if(errnum)
		{
h:			j.answer.type = -1;   //type: error
			j.answer.errnum = errnum;
			strcpy(j.answer.text, "Error");
			strcpy(j.input, linebuf1);  //save org input at cell loc
			j.cell_name[0] = 'A'+ c-1;   //store name of cell
			itoa(r, &(j.cell_name[1]), 10); //tempbuf = ie., "B12"
			this->Store(&j); //reserve room for new cell

		}
	}

	return &ce;
}

/*------------------------------------------------------------------------*/
//Parser entry point
//Entry:
// linebuf1 holds the expression input from the user
// r, c = the r # of the rol and col of the spreadsheet cell
//        that the expression and it value are to be stored in
//
// Exit:
//  returns a pointer to the cell struct in the spreadsheet that
//  contains both the original input expression and its parsed value
//  errnum > 0 if error occurs while parsing, in which case the
//             appropriate message is in  errorMessage[]

Cell *Parse::eval_exp0(char *linebuf1, int c, int r)
{
	char tempbuf[160], *p;
	int t=0;
	Answer answer;
	Cell j;
	if(c ==4)
	{
		col =0;   //debugging
	}


top:
	errnum =0;
	answer.numeric =0;
	answer.type =0;
	answer.errnum =0;
	prog = linebuf1;
	col = c-1;
	row = r-1;
	tempbuf[0] = 'A'+ col;
	itoa(r, &(tempbuf[1]), 10); //tempbuf = ie., "B12"
	strcpy(&(j.cell_name[0]), tempbuf);
	strcat(tempbuf, "=");

	while(linebuf1[t] == 32) t++;

	if(linebuf1[t] == '=')
	{
		prog+=(t+1); //move past '='
	}
	strcpy(j.input, prog);  //the expression on the right of the '=' for
									//cell (col, row)

	strcat(tempbuf, prog);   //tempbuf =ie., "A1 = 34*12"
	prog = tempbuf;
	answer.type = checkType();      //check if exp blank, text or numeric
	if(answer.type ==2)  //if numeric
	{
		massage();  //try to smoothe data to prevent data errors
		massage2();  //change any '=' into '=='
		get_token();
		if(!*token)
		{
			serror(3);     //no expression present
			return NULL;
		}
		eval_exp1(&answer);
		if(errnum)
			return NULL;

		if(*token)
		{
			assumetext =0;
			if(errnum) return NULL;   //don't overwrite previous error
			serror(1); //last token must be null (syntax error)
			return NULL;
		}

		j.answer.numeric = answer.numeric;
		j.answer.type = answer.type;
		j.answer.errnum =0;
		if(answer.type == 1)
		{
			strcpy(j.answer.text, answer.text);
		}
	}

	else //CheckType() return type as text
	{    //copy the input line into answer.text
		p= tempbuf;
		while(*p != '=') p++;
		p++;
		while(*p == ' ') p++;
		strcpy(j.answer.text, p);
		if(*p==0) j.answer.type =0;
		else j.answer.type =1;

	}
	j.answer.errnum =0;
h:
	this->Store(&j); //new cell

	return &ce;
}
//-------------------------------------------------------------------------
//Process an assignment
void Parse::eval_exp1(Answer *answer)
{
	//int slot;
	char ttok_type;
	char temp_token[80], *p;
	char pos[40];

	if(errnum) return;
	if(tok_type == VARIABLE)
	{
		//save old token
		strcpy(temp_token, token);
		ttok_type = tok_type;
		//compute the index of the variable
		col = toupper(*token) - 'A';
		p = &(token[1]);
		row = atoi(p) -1;
		//slot = row *26+col;
		strcpy(pos, token);   //temporary save the cell name

		get_token();
		if(*token != '=')
		{
			putback();  //return current token
			//restore old token - not assignment
			strcpy(token, temp_token);
			tok_type = ttok_type;
		}
		else
		{   //An expression beginning something like "A1 = ..."
			 //was found. We have found the index in the array for that
			 //variable to be stored. We must now evaluate the right half
			 //of the expression (the part after the "=" sign) and assign
			 //the result to the variable on the left of the "=" sign.
			Cell j;
			strcpy(&(j.input[0]), prog); //copy rest of expression after "="
												  //into j.input
			get_token();
			eval_exp2(answer);  //evaluate right half of expression
			if(errnum)
				return;


			j.answer.numeric = answer->numeric;
			j.answer.type = answer->type;
			if(answer->type == 1)  //if its text
				strcpy(j.answer.text, answer->text);

			//j.answer.type = tok_type;
			strcpy(&(j.cell_name[0]), pos);
			j.answer.errnum =0;
			Store(&j);   //create room, and store the expression
			return;
		}

	} //end of if tok_type == VARIABLE

	eval_exp2(answer);  //it wasn't a variable
}
//-------------------------------------------------------------------------
//Process relation operators
void Parse::eval_exp2(Answer *value)
{
	Answer partial_value;
	char op;

	if(errnum) return;
	//------
	if(tok_type ==TEXT)
	{
		strcpy(value->text, token);
		value->type =1;
		value->errnum =0;
		value->numeric = 0.0L;
		get_token();          //get next token at end of closing quote
		return;
	}
	//------
	eval_exp22(value);
	if(errnum) return;    //an expression error occurred

	if(!value->type) //reference to an empty cell, default to numeric
	{
		value->numeric = 0.0L;
		value->type =2;
	}

	op = *token;

	if(!op) return;
	if(strchr(relops, op))
	{
		get_token();
		eval_exp22(&partial_value);
		if(errnum) return;
		//if reference to an empty cell default type to numeric
		if(!partial_value.type)
		{
			partial_value.type =2;
			partial_value.numeric = 0.0L;
		}

		if(partial_value.type !=2)
		{
			errnum = 5;     //type mismatch
			value->errnum = 5;
			value->type = -1;
			return;
		}

		if(partial_value.type != value->type)
		{
			errnum =5;     //type mismatch
			value->errnum =5;
			value->type = -1;
			return;
		}

		switch(op)
		{
			case LT:
				value->numeric = value->numeric < partial_value.numeric;
				break;

			case LE:
				value->numeric = value->numeric <= partial_value.numeric;
				break;

			case GT:
				value->numeric = value->numeric > partial_value.numeric;
				break;

			case GE:
				value->numeric = value->numeric >= partial_value.numeric;
				break;

			case EQ:
				value->numeric = value->numeric == partial_value.numeric;
				break;

			case NE:
				value->numeric = value->numeric != partial_value.numeric;
				break;
		}

	}

}
//-------------------------------------------------------------------------
//Add or aubtract two terms
void Parse::eval_exp22(Answer *answer)
{
	char op;
	Answer temp;

	if(errnum) return;
	eval_exp3(answer);
	if(errnum)
		return;


	if(answer->type != 2) return;

	while((op = *token) == '+' || op == '-')
	{
		get_token();
		eval_exp3(&temp);
		if(temp.type !=2) return;
		switch(op)
		{
			case '-':
				answer->numeric = answer->numeric - temp.numeric;
				break;

			case '+':
				answer->numeric = answer->numeric + temp.numeric;
				break;
		}
	}

}
//--------------------------------------------------------------------------
//Multiply or divide two factors
void Parse::eval_exp3(Answer *answer)
{
	char op;
	Answer temp;

	if(errnum) return;
	eval_exp4(answer);
	if(errnum)
		return;


	if(answer->type !=2) return;
	while((op = *token) == '*' || op == '/')
	{
		get_token();
		eval_exp4(&temp);
		if(errnum) return;
		if(temp.type !=2) return;
		switch(op)
		{
			case '*':
				answer->numeric = answer->numeric * temp.numeric;
				break;

			case '/':
				if(temp.numeric == 0)  //trap division by zero error
				{
					serror(10);
					return;
				}
				answer->numeric = answer->numeric / temp.numeric;
				break;

		}

	}
}
//--------------------------------------------------------------------------

int matherr (struct exception *a)
{
  par->errnum =10;
  //if (a->type == DOMAIN)
	 //if (!strcmp(a->name,"sqrt")) {
	 //	a->retval = sqrt (-(a->arg1));
	 //return 1;
	 //}
  return 0;
}

//-------------------------------------------------------------------------
/* This example installs a signal handler routine for SIGFPE,
	catches an integer overflow condition, makes an adjustment
	to AX register, and returns.  This example program MAY cause
	your computer to crash, and will produce runtime errors
	depending on which memory model is used.
*/


//-----------------------------------------------------------------------
//Process an exponent
void Parse::eval_exp4(Answer * answer)
{
	Answer temp;
	double x, y;
	int t;

	if(errnum) return;
	eval_exp5(answer);
	if(errnum)
		return;

	if(answer->type !=2) return;

	x = answer->numeric;
	if(*token == '^')
	{
		get_token();
		eval_exp4(&temp);  //recursively call the function
		if(errnum) return;
		if(temp.type !=2) return;
		y = temp.numeric;
		if(temp.numeric==0.0)
		{
			answer->numeric = 1.0;
			return;
		}
		//this is the same as the power function
		//ie., 45.6^3  (answer = 45.6, temp =3)

		if(x <0 && y != (long int) y) {serror(10); return;}
		if(y< -300 || y > 300) {par->errnum =10; return;}
		answer->numeric = pow(x,y);

	}
}
//--------------------------------------------------------------------------
//Evaluate a unary + or -
void Parse::eval_exp5(Answer *answer)
{
	char op;

	if(errnum) return;
	op = 0;
	if((tok_type == DELIMITER) && *token == '+' || *token == '-')
	{
		op = *token;
		get_token();
	}

	eval_exp6(answer);
	if(errnum) return;
	if(answer->type !=2) return;
	if(op == '-') answer->numeric = -(answer->numeric);

}
//--------------------------------------------------------------------------
//Process a parenthesised expression
void Parse::eval_exp6(Answer *answer)
{
	if(errnum) return;
	if((*token == '('))
	{
		get_token();
		eval_exp2(answer);  //recursively call eval_exp2
		if(errnum) return;
		if(*token != ')')
		{
			serror(2); //there must be a closing parenthesis
			return;
		}
		get_token();

	}
	else atom(answer);  //not a parenthesised expression
}
//--------------------------------------------------------------------------
//Get the value of a number or a cell variable or text
void Parse::atom(Answer *answer)
{
	int i;

	if(errnum) return;

	switch(tok_type)
	{
		case VARIABLE:
			Cell *j;
			j = Find(token);
			if(errnum == 6)   //reference in expression to a cell not allocated
			{
				errnum =0;
				answer->numeric =0.0;
				answer->type = 2;  //numeric type
				get_token();
				return;
			}
			if(j == NULL)
			{
				assumetext =1;  //flg: restart parsing expression as text
				return;
			}
			answer->numeric = j->answer.numeric;
			answer->type = j->answer.type;
			if(j->answer.type == 1)  //if its text
				strcpy(answer->text, j->answer.text);
			else if(!j->answer.type)  //if cell reference is blank default return val to numeric
			{
				  answer->type = 2;
				  answer->numeric = 0.0L;
				  answer->text[0] =0;
				  answer->errnum =0;
			}
			get_token();
			return;

		case NUMBER:
			answer->type = 2;
			answer->numeric = atof(token);
			get_token();
			if(*token == '%')
			{
				answer->numeric /=100;
				get_token();
			}
			return;


		case TEXT:
			answer->type = 1;
			strcpy(answer->text, token);
			if(!*prog) return;
			get_token();     //maybe I should leave this out
			return;

		case FUNCTION:
			i = FindFunction(token);
			switch(i)
			{
				case 1:
					Abs(answer);
					return;

				case 2:
					Acos(answer);
					return;

				 case 3:
					If(answer);
					return;

				case 4:
					Pmtc(answer);
					return;

				case 5:
					Sum(answer);
					return;

				case 6:
					Choose(answer);
					return;

				case 7:
					Irate(answer);
					return;

				case 8:
					Type(answer);   //the type of the cell
					return;

				case 9:
					Eff(answer);
					return;

				case 10:
					Cos(answer);
					return;

				case 11:
					Sin(answer);
					return;

				case 12:
					Tan(answer);
					return;

				case 13:
					Ln(answer);
					return;

				case 14:
					Log(answer);
					return;

				case 15:
					Exp(answer);
					return;

				case 16:
					Str(answer);
						return;
				case 17:
					Strcat(answer);
					return;

				case 18:
					Strcmp(answer);
					return;

				case 19:
					Bigdays(answer);
					return;

				case 20:
					Today(answer);
					return;

				case 21:
					Easter(answer);
					return;

			  case 22:
					GetDate(answer);
					return;

			  case 23:
				  Int(answer);
				  return;

			  case 24:
				  Npv(answer);    //Net present value
				  return;

			  case 25:
				 Irr(answer);		//Internal Rate of Return on investment
				 return;

			  case 26:
				Pv(answer);      //present value
				return;

			  case 27:
				Fv(answer);      //future value
				return;

			 case 28:
				Term(answer);
				return;

			 case 29:
				CTerm(answer);
				return;

				case 30:
					Count(answer);
					return;

				case 31:
					Min(answer);
					return;

				 case 32:
					Max(answer);
					return;

				case 33:
					Avg(answer);
					return;

				case 34:
					Ddb(answer);
					return;

				case 35:
					Sln(answer);
					return;

				case 36:
					Syd(answer);
					return;

				case 37:
					Sqrt(answer);   //the type of the cell
					return;

				case 38:
					Var(answer);
					return;

				case 39:
					Std(answer);
					return;

				case 40:
					Rate(answer);
					return;

				case 41:
					Round(answer);
					return;

				case 42:
					Rand(answer);
					return;
			  case 43:
					Strcat1(answer);
					return;
			  case 44:
					Pi(answer);
					return;

			 case 45:
				Mod(answer);
				return;

			 case 46:
				Nom(answer);
				return;

			  //-- add more functions here

			  //--
				case 0:
					serror(4);   //Function not supported
					return;
			}



		default:
			serror(1);          //syntax error
	}

}
//--------------------------------------------------------------------------
//this was org 66. we changed it to 99
// to preserve it
//Process an if expression
//example: IF(45*6>6, 10, 11)
void Parse::eval_exp66(Answer *answer1, Answer *answer2, Answer *answer3)
{

	if(errnum) return;

	if(*token != '(')
	{
	  serror(1);       //syntax eror
	  return;
	}
	get_token();
	eval_exp2(answer1);  //recursively call eval_exp2
	if(errnum) return;
	//get_token();
	if(*token != ',') {serror(1); return;}
	get_token();
	eval_exp2(answer2);
	if(errnum) return;
	if(*token != ',') {serror(1); return;}
	get_token();
	eval_exp2(answer3);
	if(errnum) return;
	get_token();

}
//--------------------------------------------------------------------------
//Process an if expression
//example: @IF(@TYPE(Z1) = 2, Z1+1, 0)
void Parse::eval_exp99(Answer *answer1, Answer *answer2, Answer *answer3)
{
	int quote =0, lb =0;        //left brace

	if(errnum) return;

	if(*token != '(')
	{
	  serror(1);       //syntax eror
	  return;
	}
	get_token();
	eval_exp2(answer1);  //recursively call eval_exp2
	if(errnum) return;
	//get_token();
	if(*token != ',') {serror(1); return;}
	if(answer1->numeric) //if its true
	{
		get_token();
		eval_exp2(answer2);
		if(errnum) return;
		if(*token != ',') {serror(1); return;}
		//keep scanning until we get  the closing brace ')'
nxt:	get_token();
		if(*token == 0 && *prog == 0){serror(1); return;}
		else if(*token == 39 || *token == 34) quote = !quote;
		else if(*token == '(' && quote ==0 ) lb++;
		else
			if(*token == ')' && quote ==0)
			{
				lb--;
				if(lb == -1) goto ex;
			}
		goto nxt;
	}

	else   //the condition is false to skip past the first
	{      //answer and position the token pointer to the begining
			 //of the second answer. Then evaluate it and return it.
		//keep scanning until we get  the closing brace ')'
nxt1:	get_token();
		if(*token == 0 && *prog ==0){serror(1); return;}
		else if(*token == 39 || *token == 34) quote = !quote;
		else if(*token == '(' && quote ==0 ) lb++;
		else if(*token == ')' && quote ==0) lb--;
		else
			if(*token == ',' && quote ==0 && lb ==0)
			{
				get_token();
				eval_exp2(answer3);
				if(errnum) return;
				goto ex;
			}

		goto nxt1;

	}  //end of else



ex:
	get_token();

}
//-------------------------------------------------------------------------
//Return a token to the input stream
//rewind the prog pointer by the amount equal to the length of the
//current token
void Parse::putback()
{
	char *t;

	t = token;
	for(; *t; t++) prog--;

}
//--------------------------------------------------------------------------
//copy the error message to the error buffer
//the user can displayer it later if he wants to.
void Parse::serror(int error)
{
	int i;
	if(errnum) return;
	i = abs(error)-1;
	static char *e[] = {
		"Syntax Error",								//-1
		"Unbalanced Parantheses",              //-2
		"No Expression Present",               //-3
		"Function not supported",              //-4
		"Expression type mismatch",            //-5
		"Cell not allocated",                  //-6
		"Cell out of range",                   //-7
		"Insufficient memory for new cell",    //-8
		"Error", 			                     //-9
		"Number out of range"                  //10
	  };

	  errnum = i+1;
	  strcpy(errorMessage, e[errnum-1]);

}
//--------------------------------------------------------------------------
//Fetch the next token
void Parse::get_token()
{
	char *temp;

	if(errnum) return;
	tok_type =0;
	temp = token;
	*temp = '\0';

	if(!*prog) return; //reached end of expression

	while(isspace(*prog)) ++prog; //skip over white space
	//----------------------------
	if(strchr("!<>=", *prog))  //is or might be a relation operator
	{
		switch(*prog)
		{
			case '=':
				if(*(prog+1) == '=')
				{
					prog++;
					prog++;
					*temp = EQ;
					temp++;
					*temp = EQ;
					temp++;
					*temp = '\0';
				}
				break;

			case '!':
				if(*(prog+1) == '=')
				{
					prog++;
					prog++;
					*temp = NE;
					temp++;
					*temp = NE;
					temp++;
					*temp = '\0';
				}
				break;

			case '<':
				if(*(prog+1) == '=')
				{
					prog++;
					prog++;
					*temp = LE;
					temp++;
					*temp = LE;
				 }
				 else
				 {
					 prog++;
					 *temp = LT;
				 }
				 temp++;
				 *temp = '\0';
				break;

			case '>':
				if(*(prog+1) == '=')
				{
					prog++;
					prog++;
					*temp = GE;
					temp++;
					*temp = GE;
				}
				else
				{
					prog++;
					*temp = GT;
				}
				temp++;
				*temp = '\0';
				break;

		}  //end of switch

		if(*token)
		{
			tok_type = DELIMITER;
			return;
		}
	}  //end of if


	//----------------------------
	if(strchr(",+-*/%^=()", *prog))
	{
		tok_type = DELIMITER;
		//advance to next char
		*temp++ = *prog++;
	}
	else if(isalpha(*prog))
	{
		while(!isdelim(*prog)) *temp++ = *prog++;
		tok_type = VARIABLE;
	}
	else if(isdigit(*prog))
	{
		while(!isdelim(*prog)) *temp++ = *prog++;
		tok_type = NUMBER;
	}

	else if(*prog == '@')
	{
		prog++; //'@' found assume its the start of a function name

		if(isalpha(*prog))
		{
			while(!isdelim(*prog)) *temp++ = *prog++;
			tok_type = FUNCTION;
		}

	}
	else if(*prog == 34)
	{
		prog++;
		while(*prog != 34 && *prog != 0) *temp++ = *prog++;
		tok_type = TEXT;
		if(*prog) prog++; //skip past closing quote
	}
	else if(*prog == 39)
	{
		prog++;
		while(*prog != 39 && *prog != 0) *temp++ = *prog++;
		tok_type = TEXT;
		if(*prog) prog++;  //skip past closing single quote
	}
	else if(*prog == '$')  //absolute references to a cell column
	{
		prog++;
		if(isalpha(*prog))
		{
			while(!isdelim(*prog)) *temp++ = *prog++;
			tok_type = VARIABLE;
		}
	}




	*temp = '\0';
}
//--------------------------------------------------------------------------
int Parse::isdelim(char c)
{

	if(strchr(" !,+-<>'/*%^=()", c) || c==9 || c== '\r' || c == 0)
		return 1;
	return 0;
}
//--------------------------------------------------------------------------
//if there is a decimal point in the string see if there is a
//digit to the left of it.
//if no digit to left see if there is  digit to the right
//if a digit to the right insert a '0' to the left
void Parse::massage()
{
	int t, found=0;
	char *p, *c, *v;
	char buf[160];

	if(errnum) return;
	p = prog;
top:
	c = strchr(p, '.');
top1:
	if(c)  //if '.' found
	{
		if(c == p) goto lookright;  //no digit to left of '.' look right
		if(!(isdigit(*(c-1)))) goto lookright; //no digit to left, look right
	}
h:	if(found) //if any '.' found in lookright convert the 1's back into '.'s
	{
		for(; *p;p++)
		{
			if(*p == 1) *p = '.';
		}

	}
	return;

//found a '.' but no digit to the left of it. If there is a digit
//to the right of it then insert a '0' to the left of it
lookright:
	  if(isdigit(*(c+1)))
	  {
		  v = c;
		  *c = 0;
		  strcpy(buf, prog);  //copy left half just before '.'
		  strcat(buf, "0\1"); //write marker code 1, replacing '.'
		  strcat(buf, c+1);   //add right half after '.'
		  strcpy(prog, buf);
		  found++;
		  c = v;

	  }
	  //no digit to the left or right of this instance of '.'
	  //look for another '.' in the expression
	  c = strchr(c+1, '.');
	  goto top1;

}
//-------------------------------------------------------------------------
//for all but the first '=' change any other '=' into '=='
void Parse::massage2()
{
	int t, quote=0, found =0;
	char *p, *c;
	char temp[160];

	if(errnum) return;
	strcpy(temp, prog);
	p = prog;
	c= strchr(p, '=');
	if(c)
	{
		c++;
		p = temp+(c-p);
		for(;*c; c++)
		{
			*p++ = *c;
			if(*c == 39 || *c == 34) quote = !quote;
			if((*c == '=') && (quote == 0))
			{
				if(*(c+1) != '=' && (*(c-1) != '<') && (*(c-1) != '>') && (*(c-1) != '=') && (*(c-1) != '!'))
				{
					*p++ = '=';
					found++;
				}
			}

		} //end for

		*p = '\0';
		if(found) strcpy(prog, temp);
	}//end if(c)

}

//-------------------------------------------------------------------------
//test the expression to see if it is
// blank, text or numeric
//The string must have an '=' in it, example "A1 ="
//the string can end at the '=' (then it is accepted as blank)
int Parse::checkType()
{
	char *p, *temp, *c;
	int t;

	if(assumetext) return 1;
	p = strchr(prog, '=')+1;
	while(isspace(*p)) ++p; //skip over white space
	if(!*p) return 0;       //exp is blank
	if(*p == 39 || *p == 34) return 1; //expression is text
	if(isalpha(*p))
	{
		temp = token;
		while(!isdelim(*p)) *temp++ = *p++;
		*temp = '\0';
		if(*(token+1) == '$')
		{
			if(isdigit(*(token+2))) return 2;
		}
		t = isdigit(*(token+1));
		if(!t) return 1; //its probably a label,
														 //therefore it counts as text
	}
	return 2;  //assume its numeric
}
//-------------------------------------------------------------------------
void Parse::Abs(Answer *answer)
{
	int x;

	if(errnum) return;
	 get_token();
	 eval_exp6(answer);
	 if(errnum) return;

	 //was there a type mismatch?
	 if(answer->type != 2)
	 {
		 answer->type = 5;  //type mismatch
		 return;
	 }
	 x = (int) answer->numeric;
	 answer->numeric = (double) ::abs(x);
	 answer->type = 2;      //numeric
}
//-------------------------------------------------------------------------
void Parse::Acos(Answer *answer)
{

	double d, e;

	if(errnum) return;
	get_token();
	eval_exp6(answer);
	if(errnum) return;


	//answer must be numeric
	if(answer->type != 2)
	{
		errnum = 5;
		return;
	}
	d = answer->numeric;
	e = acos(d);
	answer->numeric = e;

}
//-------------------------------------------------------------------------
//the if function. Example:
// " @IF(45 >= 5*8, 10, 5)"
//if 45 is greater than or equal to 5*8 return 10, else return 5

void Parse::If(Answer *answer)
{
	Answer cond, answer1, answer2;

	if(errnum) return;
	get_token();
	eval_exp99(&cond, &answer1, &answer2);
	if(errnum) return;
	if(cond.type ==0) cond.type =2;
	if(cond.type !=2) {serror(1); return;}			//syntax error

	if(cond.numeric)   //if the @if() condition was true accept the 1st answer
	{
	  answer->type = answer1.type;
	  if(answer1.type == 1)  //if its text
		 strcpy(answer->text, answer1.text);

		//answer->numeric = answer1.numeric;
		//------
	  else //the 1st answer in the @if() is either was empty=0, 2=numeric or -1 error
	  {
			if(answer1.type == 2) answer->numeric = answer1.numeric;
			else
			{
				if(answer1.type ==0)  //if 1st answer refers to an empty cell
				{                     //give the org cell a numeric answer of 0
					answer->type=2;
					answer->numeric =0.0L;
				}
				else  //the 1st answer is an error. Give the org cell the same
				{
					answer->type = -1;
					answer->errnum = ce.answer.errnum;  //error
					errnum = ce.answer.errnum;
					strcpy(answer->text, answer2.text);
				}

			}
	  }

		//------

	}
	else     //the @if() condition was false, accept the 2nd answer
	{
	  answer->type = answer2.type;
	  if(answer2.type == 1)  //if its text
		 strcpy(answer->text, answer2.text);
	  else //the second answer in the @if() is either was empty=0, 2=numeric or -1 error
	  {
			if(answer2.type == 2) answer->numeric = answer2.numeric;
			else
			{
				if(answer2.type ==0)  //if second answer refers to an empty cell
				{                     //give the org cell a numeric answer of 0
					answer->type=2;
					answer->numeric =0.0L;
				}
				else  //the second answer is an error. Give the org cell the same
				{
					answer->type = -1;
					answer->errnum = ce.answer.errnum;  //error
					errnum = ce.answer.errnum;
					strcpy(answer->text, answer2.text);
				}

			}
	  }


	}
}
//-------------------------------------------------------------------------
//----------------------------------------------------------------------
// This function calculates the amount of the monthly payment
// of a loan
// it gets its parameters from the expression in the string *prog
// for example:
// Principal            = 4667
// nominal interest     = 0.13772
// # of payments        = 48
// compounding per year = 12
// An example of the values in the PMTC function are:
// =@PMTC(4667, 0.13772, 48, 12)  returns 127.00

void Parse::Pmtc(Answer *answer)
{
	double x, y, i;

	Answer principal, interest, terms, x12;
	int t;

	if(errnum) return;
	get_token();
	eval_exp66(&principal, &interest, &terms);
	if(errnum) return;
	if(!*token){ serror(1); return;}
	if(*token == ')') {serror(1); return;}

	//token now contains the forth parameter. the x12 para
	//make sure there was a comma separating the 3rd and 4th parameters
	t= strlen(token)+1;
	while(*(prog-t) == ' ') t++; //skip any spaces
	if(*(prog -t) != ',') {serror(1); return;}
	eval_exp2(&x12);
	if(errnum) return;
	if(*token != ')') {serror(1); return;}



	//We now have all the parameters.
	//Check that their values are all numeric
	i = principal.type + interest.type + terms.type + x12.type;
	if(i != 8) { serror(5); return;}  //type mysmatch


	i = interest.numeric;
	if(x12.numeric ==0.0)
	{
h:
		serror(10);
		return;
	} //# out of range
	x = i / x12.numeric+1;
	y = -1 * terms.numeric;
	if(x <=0.0) goto h;
	{

		if( y ==0) y = 1;
	}
	x = 1- pow(x, y);

	answer->numeric = (principal.numeric *(i / x12.numeric)) / x;
	answer->numeric = Precision(answer->numeric, 2); //round up to 2 digits
																	 //after decimal point
	answer->type = 2;
	get_token();

}
//----------------------------------------------------------------------
//add up all the numeric cells in a range
//ie., =@SUM(A1:C4)
void Parse::Sum(Answer *answer)
{
	int x1, y1, x2, y2, l, t, cx, cy, s;
	char *p, cell_name[6];
	Cell *j;
	double acc = 0.0L;

	get_token();
	if(!*token == '(') {serror(1); return;}
	get_token();
	p = token;
	//we now should have a string like 'D1:D8'  pointed to by p
	x1 = toupper(*token) - 'A';
	s =0;
	if(token[1] =='$') s=1;   //its the second $ (ie., A$12)
	y1 = atoi(&token[1+s]) -1;
	p = strchr(token, ':');
	if(p == NULL) {serror(1); return;}     //syntax error
	p++;
	while(*p == ' ' || *p=='$') p++;  //skip any spaces after ':' and before the sceond
									//cell reference
	if(!*p) {serror(1); return;}
	x2 = toupper(*p) -'A';

	p++;
	if(*p=='$') p++;
	y2 = atoi(p) -1;

	get_token();     //get the current token pointed to by prog
	if(*token !=')') {serror(1); return;}

	get_token(); //move forward (most likely to the null terminator)


	//make sure cell references are legal
	if(x1< 0 || x1 > 25 || x2 < 0 || x2 > 25 || y1 <0 || y1 >=y100 || y2 < 0 || y2 >= y100)
	{
		answer->type =-1;
		answer->errnum =7;  //cell out of range
		serror(7);
		return;
	}

	//if range twisted retwist back to normal
	if(x2 < x1)
	{
		t = x1;
		x1 = x2;
		x2 = t;
	}
	if(y2 <y1)
	{
		t = y1;
		y1 = y2;
		y2 = t;
	}
	//add up all the numeric cells in the range x1, y1, x2, y2
	//for each row scan from column to column, adding up horizontally first
	//then vertically
	for(cy = y1; cy<= y2; cy++)  //for each row
	{
		for(cx = x1; cx<= x2; cx++) //for each column
		{
			cell_name[0] = cx+'A';
			itoa(cy+1, &cell_name[1], 10);
			j = Find(cell_name);
			if(j->answer.type == 2)
			{
				acc+=j->answer.numeric;
			}
		}
	}

	answer->type =2;
	answer->errnum =0;
	answer->numeric = acc;
	errnum =0;
}
//-----------------------------------------------------------------------
void Parse::AutoCalc()
{
	Cell *j;
	ScreenCell *sc;
	int cx, cy;
	char exp[128], cell_name[6];

	for(cy = 0; cy<= (y100-1); cy++)  //for each row
	{
		for(cx = 0; cx<= 25; cx++) //for each column
		{
			sc = sheet[cy*26+cx];
			if(sc->u.type)
			{
				cell_name[0] = cx+'A';
				itoa(cy+1, &cell_name[1], 10);
				errnum =0;
				j = Find(cell_name);
				strcpy(exp, j->input);
				j = eval_exp(exp, cx+1, cy+1);
			}
		}
	}
	//------
	for(cx = 0; cx<=25; cx++)  //for each col
	{
		for(cy = 0; cy<= (y100-1); cy++) //for each row
		{

			sc = sheet[cy*26+cx];
			if(sc->u.type)
			{
				cell_name[0] = cx+'A';
				itoa(cy+1, &cell_name[1], 10);
				errnum =0;
				j = Find(cell_name);
				strcpy(exp, j->input);
				j = eval_exp(exp, cx+1, cy+1);
			}
		}
	}

}
//-----------------------------------------------------------------------
//This functions receives a reference.
//it changes the reference in the string according to the following rules:
//Entry:
// x1, y1, x2, y2 are the c coordinates referring to a block range.
//	distx, disty are contain column and row relative distances. There
//	are either negative or positave distances to use on the cell reference
// absol = 0	adjust both col and row if not absolute
//         1   adjust both if within range, regardless of absolute
//
//	buf = the column letter.  If there is an absolute column prefix it will be
// at buf-1
//	Exit:
// 	ax = the r len of the reference
//    ax = -1 if error

char *Parse::AdjustReference(char *buf, int x1, int y1, int x2, int y2,
					int distx, int disty, int absol)
{
	int t, i, l, l1, l2, num, oldnum, chr;

	char tempbuf[160], *p;
	char tempbuf2[160];
	char numstr[10];
	p = buf-1;      //get the adr of the char before 'A'
	strcpy(tempbuf, p);
	l1 =1;    //its the beginning of column letter
	l2 = 2;  //pos in str of the 1st digit of the number if no '$'
	if(tempbuf[2] == '$') l2 =3; //pos of 1st digit
	strcpy(tempbuf2, &tempbuf[l2]);
	t =0;
	while(isdigit(tempbuf2[t])) t++; //scan past digit

	tempbuf[1] = toupper(tempbuf[1]);

	num = atoi(&tempbuf[l2]);
	oldnum = num;
	//l1 = pos of column letter in tempbuf
	//l2 = pos of 1st digit of row number

	switch(absol)
	{


		case 0:  //adjust both if not absolute
			if(tempbuf[0] != '$')
			{
				i = tempbuf[1] + distx;
				if(i < 'A') i +=26;   //if small than 'A' loop around to 'Z'
				else
					if(i > 'Z')  i-=26; //if greater than 'Z' loop around to 'A'
				tempbuf[1] = i;
			}
			if(tempbuf[2] != '$')
			{
				i = num + disty;
				if(i < 1) i +=y100;   //if small than 1 loop around to 100
				else
					if(i > y100)  i-=y100; //if greater than 100 loop around to 1
				num =i;
			}
			break;



		case 1:  //adjust both regardless of absolute
			chr = tempbuf[1] -'A';
			if((chr >= x1) && (chr <=x2))
			{
				i = tempbuf[1] + distx;
				if(i < 'A') i +=26;   //if small than 'A' loop around to 'Z'
				else
					if(i > 'Z')  i-=26; //if greater than 'Z' loop around to 'A'
				tempbuf[1] = i;
			}
			if(((num-1) >= y1) && ((num-1) <= y2))
			{
				i = num + disty;
				if(i < 1) i +=y100;   //if small than 1 loop around to 100
				else
					if(i > y100)  i-=y100; //if greater than 100 loop around to 1
				num =i;
			}
			break;

		default:
			return NULL;	//in case of error
	} //end of switch()

	itoa(num, numstr, 10);       //put number in string

	strcpy(&tempbuf[l2], numstr); //enter number into string
	i = strlen(&tempbuf[1]);      //get len of first part of string
	strcat(&tempbuf[1], &tempbuf2[t]); //add second part after last digit
	strcpy(buf, &tempbuf[1]);
	p = buf+i;

	return p;  //pos of next char after last digit of num

}
//----------------------------------------------------------------------
//Adjust cell references. (See previous function for details)
//Exit:
//	ax = null if error
// else ax = the len of the buf
int Parse::AdjustReferences(char *prog, int x1, int y1, int x2, int y2,
										int distx, int disty, int absol)
{
	int count, t, quote=0;
	char *p, *c, prevchar; int chr;
	char tempbuf[160];

	//if(errnum) return;
	tempbuf[0] =' ';
	strcpy(&tempbuf[1], prog);
	c = tempbuf+1;
	count = 0;
	for(;*c; c++)
	{
		count++;       //r len
		if(*c == 39 || *c == 34) quote = !quote;
		if(!quote)
		{
			if(((*c >='A') && (*c<= 'Z')) || ((*c >= 'a') && (*c <='z')))
			{
				prevchar = *(c-1);
				chr = *(c+1); //look ahead to the next char. If its a '$'
								  //or a digit the letter it might be a column letter
				if(chr == '$' || isdigit(chr))
				{
					//if its strcat1 skip it
					if(count>1)
					{
						//if the previous char was also a letter its not a column
						//name because there are only a letters columns in Matrix
						//so don't adjust it. skip it
						if(((prevchar >='A') && (prevchar<= 'Z')) || ((prevchar >= 'a') && (prevchar <='z')))
							continue;
					}

					c = AdjustReference(c, x1, y1, x2, y2, distx, disty, absol);
					//c now = the adr of the next pos after the last
					//digit of the cell reference
					if(c == NULL) return 0;  //in case of error
				}
			}
		}
	} //end for


	strcpy(prog, &tempbuf[1]);
	return strlen(prog);
}

//-------------------------------------------------------------------------
//Syntax: @CHOOSE(3, A1, B2)
//chooses the third cell in the range A1 to B2, which is A2
void Parse::Choose(Answer *answer)
{
	int index, maxindex;
	int x, y, x1, y1, x2, y2, l, t, cx, cy, s, r, c;
	char *p, cell_name[6];
	Cell *j;

	get_token();
	if(*token != '(') {serror(1); return;}
	get_token();          //get the index
	eval_exp2(answer);   //evaluate the index parameter
	if(errnum) return;
	if(answer->type != 2){ serror(1); return;}
	index = (int) answer->numeric;
	//check that index is within range later
	if(*token != ',') {serror(1); return;}  //syntax error
	get_token();
	x1 = toupper(token[0]) - 'A';
	t = 1;
	if(token[1] == '$') t++;
	y1 = atoi(&token[t])-1;
	if(x1 < 0 || x1 > 25) {serror(7); return;}  //out of range
	if(y1 <0 || y1 > y99) {serror(7); return;}
	get_token(); //should be seperating comma between pars of block range
	if(*token != ',') {serror(1); return;}
	get_token();     //should be end par of cell block
	x2 = toupper(token[0]) - 'A';
	t = 1;
	if(token[1] == '$') t++;
	y2 = atoi(&token[t])-1;
	if(x2 < 0 || x2 > 25) {serror(7); return;}  //out of range
	if(y2 <0 || y2 > y99) {serror(7); return;}

	//if range twisted retwist back to normal
	if(x2 < x1)
	{
		t = x1;
		x1 = x2;
		x2 = t;
	}
	if(y2 <y1)
	{
		t = y1;
		y1 = y2;
		y2 = t;
	}
	//check that index is within range
	x = (x2 - x1)+1;   //r num of cols in range
	y = (y2 - y1)+1;   //r num of rows in range
	maxindex = y*x;
	if(index > maxindex) {serror(7); return;}
	index--;
	c = index % x;  //the relative col & row within the user's range
	r = index / x;
	cx = x1+c;
	cy = y1+r;
	cell_name[0] = cx+'A';
	itoa(cy+1, &cell_name[1], 10);
	j = Find(cell_name);
	answer->type = j->answer.type;
	answer->errnum = j->answer.errnum;
	answer->numeric = j->answer.numeric;
	if(j->answer.type ==1)
	{
		strcpy(answer->text, j->answer.text);
	}
	errnum = j->answer.errnum;
	get_token();
	if(*token != ')') {serror(1); return;}
	get_token();

}
//-------------------------------------------------------------------------
//Syntax: @Irate(4667.00, 48, 12, 127.00)
//returns the nominal interest rate (interpreted as APR by the Americans)
//In the above example the 4 parameters are:
// amount borrowed, num of repayments, times compounded per year, and
// fixed payment amount
void Parse::Irate(Answer *answer)
{
	double p, x, y, i, app, lastopr, ny, np, stp, Pmt, result;
	Answer principal, terms, x12, interest, pmt;
	int t;

	if(errnum) return;
	get_token();
	eval_exp66(&principal, &terms, &x12);
	if(errnum) return;
	if(!*token){ serror(1); return;}
	if(*token == ')') {serror(1); return;}

	//token now contains the forth parameter. the x12 para
	//make sure there was a comma separating the 3rd and 4th parameters
	t= strlen(token)+1;
	while(*(prog-t) == ' ') t++; //skip any spaces
	if(*(prog -t) != ',') {serror(1); return;}
	eval_exp2(&pmt);
	if(errnum) return;
	if(*token != ')') {serror(1); return;}



	//We now have all the parameters.
	//Check that their values are all numeric
	i = principal.type + terms.type + x12.type + pmt.type;
	if(i != 8) { serror(5); return;}  //type mysmatch
	//-----
	p = principal.numeric;

	app = pmt.numeric ; //app = the payment we are to target
	i = .001;

	stp = 0.01;
	lastopr = 1;  //last operation on stp: -1 = smaller, +1 = bigger


top:

		i = i + (stp* lastopr);
		//calculate payment
		x = (i/x12.numeric+1);
		y = -1 *terms.numeric;
		x = 1 - pow(x, y);
		Pmt = (p * (i/x12.numeric)) /x;
		//round payment
		if((Pmt >= (app -.0001 )) &&  (Pmt <= (app + .0001))) goto found;

		if(Pmt <  app)
		{

			if(lastopr == -1)
			{
				stp = stp /2;
				lastopr = 1;
				goto top;
			}

			stp = stp * 2;
			goto top;
		}

		if( Pmt > app)
		{
			 if(lastopr == 1)
			 {
				 stp = stp /2;
				 lastopr = -1;
				 goto top;
			 }

			 lastopr = -1;

			 goto top;
		}


found:
		//i = i * 100;

	answer->numeric = i;
	answer->errnum =0;
	//-----
	answer->type = 2;
	get_token();
}
//-------------------------------------------------------------------------
//Syntax:
//	@Type(A4)
//return a number indicating the type of the cell being referenced
//the number is either  -1 = error, 0 = blank, 1 = text, 2 = numeric
//example:
//@if(@Type(A3) = 2, a3, ' ')
//This means if a3 is numeric return its numeric value, else
//return a blank string

void Parse::Type(Answer *answer)
{
	int t, cx, cy;
	char cell_name[6];
	Cell *j;

	get_token();
	if(*token != '(') {serror(1); return;}
	get_token();
	cx = toupper(token[0]) - 'A';
	t = 1;
	if(token[1] == '$') t++;
	cy = atoi(&token[t]);
	if(cx <0 || cx >25 || cy <1 || cy > y100) {serror(1); return;}
	cell_name[0] = 'A' +cx;
	itoa(cy, &cell_name[1], 10);

	j = Find(cell_name);
	answer->type = 2;	//numeric
	answer->numeric = j->answer.type;
	get_token();
	if(*token != ')') {serror(1); return;}
	get_token();
}
//-------------------------------------------------------------------------
//convert from nominal interest rate into effective interest rate
//
void Parse::Eff(Answer *answer)
{
	double apr, x, y;

	get_token();
	if(*token != '(') {serror(1); return;}
	get_token();
	eval_exp2(answer);   //evaluate the nominal rate parameter
	if(errnum) return;
	if(answer->type != 2){ serror(1); return;}

	apr = answer->numeric;
	//check that index is within range later
	if(*token != ',') {serror(1); return;}  //syntax error
	get_token();

	eval_exp2(answer);   //evaluate the x12 parameter
	if(errnum) return;
	if(answer->type != 2){ serror(1); return;}

	x = 1 +(apr /answer->numeric);
	y = answer->numeric;
	answer->numeric = (pow(x, y) -1);

	if(*token != ')') {serror(1); return;}
	get_token();
}
//-------------------------------------------------------------------------
void Parse::Cos(Answer *answer)
{
	double d, e;

	if(errnum) return;
	get_token();
	eval_exp6(answer);
	if(errnum) return;


	//answer must be numeric
	if(answer->type != 2)
	{
		errnum = 5;
		return;
	}
	d = answer->numeric;
	e = cos(d);
	answer->numeric = e;

}
//-------------------------------------------------------------------------
void Parse::Sin(Answer *answer)
{
	double d, e;

	if(errnum) return;
	get_token();
	eval_exp6(answer);
	if(errnum) return;


	//answer must be numeric
	if(answer->type != 2)
	{
		errnum = 5;
		return;
	}
	d = answer->numeric;
	e = sin(d);
	answer->numeric = e;

}
//-------------------------------------------------------------------------
void Parse::Tan(Answer *answer)
{
	double d, e;

	if(errnum) return;
	get_token();
	eval_exp6(answer);
	if(errnum) return;


	//answer must be numeric
	if(answer->type != 2)
	{
		errnum = 5;
		return;
	}
	d = answer->numeric;
	e = tan(d);
	answer->numeric = e;


}
//-------------------------------------------------------------------------
void Parse::Ln(Answer *answer)
{
	double d, e;

	if(errnum) return;
	get_token();
	eval_exp6(answer);
	if(errnum) return;


	//answer must be numeric
	if(answer->type != 2)
	{
		errnum = 5;
		return;
	}
	d = answer->numeric;
	e = log(d);
	answer->numeric = e;

}
//-------------------------------------------------------------------------
void Parse::Log(Answer *answer)
{
	double d, e;

	if(errnum) return;
	get_token();
	eval_exp6(answer);
	if(errnum) return;


	//answer must be numeric
	if(answer->type != 2)
	{
		errnum = 5;
		return;
	}
	d = answer->numeric;
	e = log10(d);
	answer->numeric = e;


}
//-------------------------------------------------------------------------
void Parse::Exp(Answer *answer)
{
	double d, e;

	if(errnum) return;
	get_token();
	eval_exp6(answer);
	if(errnum) return;


	//answer must be numeric
	if(answer->type != 2)
	{
		errnum = 5;
		return;
	}
	d = answer->numeric;
	e = exp(d);
	answer->numeric = e;

}
//-------------------------------------------------------------------------
//Convert a number into a string
//Syntax:
//	@Str(1212.567, 2, 1)
//this says convert the number 12.56 into a string with only 2 digits
//after the decimal point and commas separating thousands if necessary
//The result is '1,212.57'
void Parse::Str(Answer *answer)
{
	double num;
	int decplaces, commas;

	if(errnum) return;
	get_token();
	if(*token != '('){serror(1); return;}
	get_token();
	eval_exp2(answer);
	if(errnum) return;
	if(answer->type != 2) {serror(5); return;}  //type mismatch
	num = answer->numeric;

	if(*token != ',') {serror(1); return;}
	get_token();
	eval_exp2(answer);    //get decplaces
	if(errnum) return;
	if(answer->type != 2) {serror(5); return;}  //type mismatch
	decplaces = (int) answer->numeric;
	if(decplaces < 0 || decplaces >9) decplaces =9;

	if(*token != ',') {serror(1); return;}
	get_token();
	eval_exp2(answer);    //get commas flg
	if(errnum) return;
	if(answer->type != 2) {serror(5); return;}  //type mismatch
	commas = (int) answer->numeric;
	Number(answer->text, num, decplaces, commas);
	answer->type =1;
	errnum =0;
	if(*token != ')') {serror(1); return;}
	get_token();

}
//-------------------------------------------------------------------------
void Parse::Strcat(Answer *answer)
{

	char string1[250];
	char string2[250];
	int l;

	if(errnum) return;
	get_token();
	if(*token != '('){serror(1); return;}
	get_token();
	eval_exp2(answer);
	if(errnum) return;
	if(answer->type != 1) {serror(5); return;}  //type mismatch
	strcpy(string1, answer->text);
	RightTrim(string1);
	l = strlen(string1);
	if(l)
	{
		string1[l] = 32;
		string1[l+1] =0;
	}
	if(*token != ',') {serror(1); return;}
	get_token();
	eval_exp2(answer);    //get second string
	if(errnum) return;
	if(answer->type != 1) {serror(5); return;}  //type mismatch
	RightTrim(answer->text);
	l = strlen(answer->text);
	if(l)
	{
		answer->text[l] = 32;
		answer->text[l+1] =0;
	}
	strcat(string1, answer->text);
	string1[120] =0;
	strcpy(answer->text, string1);

	if(*token != ')') {serror(1); return;}
	get_token();

}
//-------------------------------------------------------------------------
void Parse::Strcmp(Answer *answer)
{
	char string1[128];
	char string2[128];

	int i;
	if(errnum) return;
	get_token();
	if(*token != '('){serror(1); return;}
	get_token();
	eval_exp2(answer);
	if(errnum) return;
	if(answer->type != 1) {serror(5); return;}  //type mismatch
	RightTrim(answer->text);
	strcpy(string1, answer->text);


	if(*token != ',') {serror(1); return;}
	get_token();
	eval_exp2(answer);    //get second string
	if(errnum) return;
	if(answer->type != 1) {serror(5); return;}  //type mismatch
	RightTrim(answer->text);
	i = strcmp(string1, answer->text);
	if(i <0) i = -1;
	else if(i >0) i =1;

	answer->type = 2;
	answer->numeric = (double) i;

	if(*token != ')') {serror(1); return;}
	get_token();


}
//-------------------------------------------------------------------------
//convert a date into a serial number
//syntax:
//@Bigdays(14, 4, 2000)

void Parse::Bigdays(Answer *answer)
{

	int PrevDays[12] ={
//  j   f   m   a   m   j     j   a    s    o    n    d}
	0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};


	long int dd, mm, yyyy, bigday, temp, year, pyear, day, month, lp;
	//-----
	if(errnum) return;
	get_token();
	if(*token != '('){serror(1); return;}
	get_token();
	eval_exp2(answer);
	if(errnum) return;
	if(answer->type != 2) {serror(5); return;}  //type mismatch
	dd=  (long int) answer->numeric;

	if(*token != ','){serror(1); return;}       //syntax error
	get_token();
	eval_exp2(answer);
	if(errnum) return;
	if(answer->type != 2) {serror(5); return;}  //type mismatch
	mm=(long int) answer->numeric;

	if(*token != ','){serror(1); return;}        //syntax error
	get_token();
	eval_exp2(answer);
	if(errnum) return;
	if(answer->type != 2) {serror(5); return;}  //type mismatch
	yyyy = (long int) answer->numeric;


	//-----
	lp =0;
	if(!(yyyy %4)) lp =1;
	if(!(yyyy %100)) lp =0;
	if(!(yyyy %400)) lp =1;


	pyear = yyyy -1;
	temp = (pyear *365) + (pyear /4) - (pyear /100) + (pyear /400);
	bigday = temp + PrevDays[mm-1];
	if(mm >2) bigday += lp;
	bigday += dd;


	answer->numeric = (double) bigday;
	//int daynum = bigday %7;
	//strcpy(daystr, dchar[daynum]);
	if(*token != ')') {serror(1); return;}
	get_token();

}
//-------------------------------------------------------------------------
void Parse::Today(Answer *answer)
{

	int PrevDays[12] ={
//  j   f   m   a   m   j     j   a    s    o    n    d}
	0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};

	long int dd, mm, yyyy, bigday, temp, year, pyear, day, month, lp;


	struct date d;

	long int big1, big2;

	getdate(&d);

	yyyy = d.da_year;
	mm = d.da_mon;
	dd = d.da_day;

	get_token();
	if(*token != '('){serror(1); return;}
	//-----
	lp =0;
	if(!(yyyy %4)) lp =1;
	if(!(yyyy %100)) lp =0;
	if(!(yyyy %400)) lp =1;


	pyear = yyyy -1;
	temp = (pyear *365) + (pyear /4) - (pyear /100) + (pyear /400);
	bigday = temp + PrevDays[mm-1];
	if(mm >2) bigday += lp;
	bigday += dd;


	answer->numeric = (double) bigday;
	answer->type =2;
	get_token();
	if(*token != ')') {serror(1); return;}
	get_token();


}
//-------------------------------------------------------------------------
//Return the date of Easter.
// =@Easter(2000)
//if its negative the date is in March, else its in April
void Parse::Easter(Answer *answer)
{

	char gnum, *p, *goldstr = ".NC.K.SH.PE.MB.J.RG.OD.LA.IQF";

	long int xcol, date, ty, x, bigday, temp, year, pyear, day, month, lp;
	long int leapdays, tempyear, totaldays, prevdays1, prevdays2;
	int chr;
	//-----
	if(errnum) return;
	get_token();
	if(*token != '('){serror(1); return;}
	get_token();
	eval_exp2(answer);
	if(errnum) return;
	if(answer->type != 2) {serror(5); return;}  //type mismatch
	year=  (long int) answer->numeric;


	//int daynum = bigday %7;
	//strcpy(daystr, dchar[daynum]);
	if(*token != ')') {serror(1); return;}
	get_token();

	ty = year+1;
	gnum = ty%19;
	if(!gnum) gnum = 19;
	chr = gnum + 64;
	p = strchr(goldstr, chr); //find the r occurance of the char
	if(p == NULL) exit(1);

	x = ((p+1) - goldstr);
	x +=20;
	if(x >31)
		x -=31;
	else
		x = -x;
	//if its in March x is negative, else its positive

	//-----
	lp =0;
	if(!(year %4)) lp =1;
	if(!(year %100)) lp =0;
	if(!(year %400)) lp =1;


	tempyear = year -1;
	leapdays = (tempyear /4) +(tempyear /400) - (tempyear / 100);
	totaldays = tempyear *365 + leapdays; //total days in previous years
	prevdays1 = 59+lp;  //days from start of year to end of feb
	prevdays2 = prevdays1 +31; //from start of year to end of march

	bigday = prevdays1 + totaldays + labs(x);
	if(x > 0) bigday = prevdays2 + totaldays +x;
	xcol = 1+(bigday%7);
	date = labs(x)  + (8 - (xcol));
	if(x < 0 && date > 31)
	{                  //moon in march, following Sunday in April
		x = labs(x);
		date -=31;
	}
	//if Sunday is 21 March it must be moved to following Sunday
	if(x <0 && date == 21) date = 28;
	if(x <0) date = -date;
	answer->numeric = (double) date;


}
//-------------------------------------------------------------------------
//Syntax
// =@GETDATE(1999, 169)
//the first par is the year, the second par is the day number 1 to 365
// or 366 in a leap year.
// in this example the function returns the date and the month
// Decode it like this
// date = @int(@GetDate(2000, 169)) /32
// month = @GetDate(2000, 169)%32+1;
// the month is 1 to 12, the date 1 to 31
void Parse::GetDate(Answer *answer)
{
	int prevdays[12] ={
//  j   f   m   a   m   j     j   a    s    o    n    d}
	0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};


	int date, t, lp, year, month, bigdate;
	//-----
	if(errnum) return;
	get_token();
	if(*token != '('){serror(1); return;}
	get_token();
	eval_exp2(answer);
	if(errnum) return;
	if(answer->type != 2) {serror(5); return;}  //type mismatch
	year = (int) answer->numeric;

	if(*token != ','){serror(1); return;}       //syntax error
	get_token();
	eval_exp2(answer);
	if(errnum) return;
	if(answer->type != 2) {serror(5); return;}  //type mismatch
	if(*token != ')') {serror(1); return;}
	get_token();

	bigdate=(int) answer->numeric;


	//-----
	lp =0;
	if(!(year %4)) lp =1;
	if(!(year %100)) lp =0;
	if(!(year %400)) lp =1;
	if(lp) for(t = 2; t < 12; t++) prevdays[t] +=lp;
	month = 0;   //assume date is to big
	for(t = 12; t> 0; t--)
	{
		if(bigdate > prevdays[t-1])
		{
			month = t;
			break;
		}
	}

	if(!month) date = -1;  //flag error
	else
		date = month * 32+(bigdate - prevdays[month-1]);
	answer->numeric = (double) date;

}
//------------------------------------------------------------------------
//round a number down to an integer
void Parse::Int(Answer *answer)
{
	long int num;
	if(errnum) return;
	get_token();
	if(*token != '('){serror(1); return;}
	get_token();
	eval_exp2(answer);
	if(errnum) return;
	if(answer->type != 2) {serror(5); return;}  //type mismatch
	num = (long int) answer->numeric;
	answer->numeric = (double) num;
	if(*token != ')'){serror(1); return;}       //syntax error
	get_token();

}
//------------------------------------------------------------------------
//This is an internal helper function for the NPV function
//Entry:
//  rate = interest rate ie., 9% = .09
//  x1, y1, x2, y2 = the range of cash outflows and inflows

double Parse::Npv1(double rate, int x1, int y1, int x2, int y2)
{
	char cell_name[6];
	Cell *j;
	double nth, result, temp;
	int cy, cx;

	nth = 0.0L;
	result = 0.0L;
	//add up all the numeric cells in the range x1, y1, x2, y2
	//for each row scan from column to column, adding up horizontally first
	//then vertically
	for(cy = y1; cy<= y2; cy++)  //for each row
	{
		for(cx = x1; cx<= x2; cx++) //for each column
		{
			cell_name[0] = cx+'A';
			itoa(cy+1, &cell_name[1], 10);
			j = Find(cell_name);
			if(j->answer.type == 2)
			{
				nth++;
				temp = pow(rate, nth);
				if(temp == 0.0L){serror(10); return 0;}
				result += (j->answer.numeric / temp);
			}
		}
	}


	return  result;
}
//-----------------------------------------------------------------------

//------------------------------------------------------------------------
// compute the Net Present Value of a steam of cash flows
// Syntax:
//  =@NPV(B1, D9:G9)
// b1 = the discount interest rate ie., 9% is .09
// D9:G9 is the range of payments
void Parse::Npv(Answer *answer)
{
	int x1, y1, x2, y2, l, t, cx, cy, s;
	char *p, cell_name[6];
	double r;
	Answer rate;


	get_token();
	if(!*token == '(') {serror(1); return;}
	get_token();
	eval_exp2(&rate);
	if(errnum) return;
	if(rate.type != 2) {serror(1); return;}
	r = rate.numeric+1;
	get_token();

	p = token;
	//we now should have a string like 'D1:D8'  pointed to by p
	x1 = toupper(*token) - 'A';
	s =0;
	if(token[1] =='$') s=1;   //its the second $ (ie., A$12)
	y1 = atoi(&token[1+s]) -1;
	p = strchr(token, ':');
	if(p == NULL) {serror(1); return;}     //syntax error
	p++;
	while(*p == ' ' || *p=='$') p++;  //skip any spaces after ':' and before the sceond
									//cell reference
	if(!*p) {serror(1); return;}
	x2 = toupper(*p) -'A';

	p++;
	if(*p=='$') p++;
	y2 = atoi(p) -1;

	get_token();     //get the current token pointed to by prog
	if(*token !=')') {serror(1); return;}

	get_token(); //move forward (most likely to the null terminator)


	//make sure cell references are legal
	if(x1< 0 || x1 > 25 || x2 < 0 || x2 > 25 || y1 <0 || y1 >= y100 || y2 < 0 || y2 >=y100)
	{
		answer->type =-1;
		answer->errnum =7;  //cell out of range
		serror(7);
		return;
	}

	//if range twisted retwist back to normal
	if(x2 < x1)
	{
		t = x1;
		x1 = x2;
		x2 = t;
	}
	if(y2 <y1)
	{
		t = y1;
		y1 = y2;
		y2 = t;
	}

	answer->numeric = Npv1(r, x1, y1, x2, y2);

	answer->type =2;
	answer->errnum =0;
	errnum =0;

}
//------------------------------------------------------------------------


