{ READCFG.INC: Read a SURFMODL configuration file.  This will eventually
  replace READINI.
}
procedure READCFG (Datafile: text80; Is_surf_cfg: boolean);
var Infile: text;
    Realvar: vartype;
    Comment: text80;
    Cmmd: cmmdtype;
    Parm: parmtype;
    Line_num: integer;
    Num: integer;
    Filebad: boolean;
    Surfdir: text80;
    Dir: dirstr;
    Name: namestr;
    Ext: extstr;
    ch: integer;
    Done: boolean;
    Version: integer;
    Mat: integer;
    Lite: integer;

begin

  Filebad := FALSE;
  Done := FALSE;
  if (Is_surf_cfg) then begin
    { This is the SURFMODL.CFG file, need to set grsys & grmode }
    grsys := -1;
    grmode := -1;
  end else begin
    { Correctly name the .INI file }
    fsplit (Datafile, Dir, Name, Ext);
    { Save the Data file mask for other data file uses }
    Filemask := Dir + Name;
    Inifile := Filemask + '.INI';
    Datafile := Inifile;
  end;

  clrscr;
  writeln ('Reading configuration file: ', Datafile);

  assign (Infile, Datafile);
{$I-}
  reset (Infile);
{$I+}
  if (ioresult <> 0) then
    Filebad := TRUE;

  if (Is_surf_cfg) and (Filebad) then begin
    { SURFMODL.CFG file does not exist, try the environment vbl SURFDIR }
    Surfdir := getenv ('SURFDIR');
    if (Surfdir <> '') then begin
      Datafile := Surfdir + '\' + Datafile;
      assign (Infile, Datafile);
{$I-}
      reset (Infile);
{$I+}
      if (ioresult = 0) then
        Filebad := FALSE;
    end;
    if (Filebad) then begin
      writeln ('ERROR: File ', Datafile, ' does not exist.');
      halt;
    end;
  end; { if Is_surf_cfg }

  if (not Filebad) then begin

    Line_num := 0;
    Mat := -1;
    Lite := -1;
    Version := 5;
    while (not Filebad) and (not Done) do begin
      Num := inreal (Infile, Realvar, Comment, Cmmd, Parm, Line_num, FALSE);
      if (Cmmd = CMD_NONE) then
        Done := TRUE
      else begin
        case Cmmd of
          CMD_GRSYS:
            { Only valid in SURFMODL.CFG file }
            if (Is_surf_cfg) then begin
              if (Num <> 1) then
                Filebad := TRUE
              else
                grsys := round (Realvar[1]);
            end else
              Filebad := TRUE;

          CMD_GRMODE:
            { Only valid in SURFMODL.CFG file }
            if (Is_surf_cfg) then begin
              if (Num <> 1) then
                Filebad := TRUE
              else
                grmode := round (Realvar[1]);
            end else
              Filebad := TRUE;

          CMD_VERSION:
            if (Num <> 1) or (Realvar[1] < 5.0) or (Realvar[1] > 5.0) then
              Filebad := TRUE
            else
              Version := round (Realvar[1]);

          CMD_EYE:
            if (Num <> 3) then
              Filebad := TRUE
            else begin
              Xeye := Realvar[1];
              Yeye := Realvar[2];
              Zeye := Realvar[3];
            end;

          CMD_FOCAL:
            if (Num <> 3) then
              Filebad := TRUE
            else begin
              Xfocal := Realvar[1];
              Yfocal := Realvar[2];
              Zfocal := Realvar[3];
            end;

          CMD_MAGNIFY:
            if (Num <> 1) then
              Filebad := TRUE
            else
              Magnify := Realvar[1];

          CMD_VIEWTYPE:
            if (Num <> 0) then
              Filebad := TRUE
            else begin
              case Parm of
                PRM_STD:
                  Viewtype := 0;
                PRM_XY:
                  Viewtype := 1;
                PRM_XZ:
                  Viewtype := 2;
                PRM_YZ:
                  Viewtype := 3;
                else
                  { Unknown parameter }
                  Filebad := TRUE;
              end; { case }
            end; { if Num }

          CMD_MATL:
            if (Num <> 1) or (Realvar[1]<0.0) or
                (round (Realvar[1]) > Nmatl+1) then
              Filebad := TRUE
            else begin
              Mat := round (Realvar[1]);
              if (Mat > Nmatl) then
                Nmatl := Mat;
            end;

          CMD_MATCONST:
            if (Num <> 3) or (Mat < 1) then
              Filebad := TRUE
            else begin
              R1[Mat] := Realvar[1];
              R2[Mat] := Realvar[2];
              R3[Mat] := Realvar[3];
            end;

          CMD_MATCOLOR:
            if (Num <> 1) or (Mat < 1) or (Realvar[1] < 0.0) then
              Filebad := TRUE
            else
              Color[Mat] := round (Realvar[1]);

          CMD_MATAMBIENT:
            if (Num <> 1) or (Mat < 1) then
              Filebad := TRUE
            else
              Ambient[Mat] := Realvar[1];

          CMD_MATRGB:
            if (Num <> 3) or (Mat < 1) then
              Filebad := TRUE
            else begin
              Redmax[Mat] := round (Realvar[1]);
              Grnmax[Mat] := round (Realvar[2]);
              Blumax[Mat] := round (Realvar[3]);
            end;

          CMD_LIGHT:
            if (Num <> 1) or (Realvar[1] < 1.0) or
                (round (Realvar[1]) > Nlite+1) then
              Filebad := TRUE
            else begin
              Lite := round (Realvar[1]);
              if (Lite > Nlite) then
                Nlite := Lite;
            end;

          CMD_LTCOORD:
            if (Num <> 3) or (Lite < 1) then
              Filebad := TRUE
            else begin
              Xlite[Lite] := Realvar[1];
              Ylite[Lite] := Realvar[2];
              Zlite[Lite] := Realvar[3];
            end;

          CMD_LTINTENS:
            if (Num <> 1) then
              Filebad := TRUE
            else
              Intensity[Lite] := Realvar[1];

          CMD_GOURAUD:
            if (Num <> 1) then
              Filebad := TRUE
            else begin
              if (Realvar[1] > 0.0) then begin
                Epsilon := Realvar[1];
                Interpolate := TRUE;
              end else
                Interpolate := FALSE;
            end;

          CMD_SHADOWING:
            if (Num <> 0) then
              Filebad := TRUE
            else begin
              case Parm of
                PRM_ON:
                  Shadowing := TRUE;
                PRM_OFF:
                  Shadowing := FALSE;
                else
                  { Unknown parameter }
                  Filebad := TRUE;
              end;
            end; { if Num }

          CMD_AXISSHOW:
            if (Num <> 0) then
              Filebad := TRUE
            else begin
              case Parm of
                PRM_ON:
                  Showaxes := 1;
                PRM_OFF:
                  Showaxes := 0;
                else
                  { Unknown parameter }
                  Filebad := TRUE;
              end;
            end; { if Num }

          CMD_AXISLEN:
            if (Num <> 3) then
              Filebad := TRUE
            else begin
              Xaxislen := Realvar[1];
              Yaxislen := Realvar[2];
              Zaxislen := Realvar[3];
            end;

          CMD_AXISCOLOR:
            if (Num <> 1) or (Realvar[1]<0.0) or (Realvar[1]>15) then
              Filebad := TRUE
            else
              Axiscolor := round (Realvar[1]);

          CMD_DITHER:
            if (Num <> 1) then
              Filebad := TRUE;
            { Option no longer supported - Mono := FALSE always }

          CMD_RANDOM:
            if (Num <> 1) then
              Filebad := TRUE
            else begin
              if (Realvar[1] > 0.0) then begin
                Randshade := Realvar[1];
                Dorandom := TRUE;
              end else
                Dorandom := FALSE;
            end;

          CMD_BORDERS:
            if (Num <> 0) then
              Filebad := TRUE
            else begin
              case Parm of
                PRM_ON:
                  ShowAllBorders := 1;
                PRM_OFF:
                  ShowAllBorders := 0;
                else
                  { Unknown parameter }
                  Filebad := TRUE;
              end;
            end; { if Num }

          CMD_TEXTCOL:
            if (Num <> 1) then
              Filebad := TRUE
            else
              Textcol := round (Realvar[1]);

          CMD_BGCOL:
            if (Num <> 1) then
              Filebad := TRUE
            else
              BGcol := round (Realvar[1]);

          CMD_GRAPHTEXT:
            if (Num <> 1) then
              Filebad := TRUE
            else
              Graphcol := round (Realvar[1]);

          CMD_REVVIDEO:
            if (Num <> 0) then
              Filebad := TRUE
            else begin
              case Parm of
                PRM_ON:
                  RevVideo := TRUE;
                PRM_OFF:
                  RevVideo := FALSE;
                else
                  { Unknown parameter }
                  Filebad := TRUE;
              end;
            end; { if Num }

          CMD_SHOWTITLE:
            if (Num <> 0) then
              Filebad := TRUE
            else begin
              case Parm of
                PRM_ON:
                  ShowTitle := TRUE;
                PRM_OFF:
                  ShowTitle := FALSE;
                else
                  { Unknown parameter }
                  Filebad := TRUE;
              end;
            end; { if Num }

          CMD_XYADJUST:
            if (Num <> 1) then
              Filebad := TRUE
            else
              XYadjust := Realvar[1];

(* FOLLOWING COMMANDS WILL BE MOVED TO READFILE:
          CMD_TITLE:
            { The title was stored in the comment field }
            if (Num <> 0) then
              Filebad := TRUE
            else
              Flpurpose := Comment;

          CMD_MAXVERT:
            if (Num <> 1) then
              Filebad := TRUE
            else
              Maxvert := round (Realvar[1]);

          CMD_NSIDES:
            if (Num <> 1) then
              Filebad := TRUE
            else
              Nsides := round (Realvar[1]);

          CMD_NODES:
            if (Num <> 1) then
              Filebad := TRUE
            else
              Nnodes := round (Realvar[1]);

          CMD_SURFACES:
            if (Num <> 1) then
              Filebad := TRUE
            else
              Nsurf := round (Realvar[1]);

END OF READFILE COMMANDS *)

          else  { INVALID or NONE }
            Filebad := TRUE;
        end; { case Cmmd }
      end; { if Num = 0 }

    end; { while }

    close (Infile);
    if (Filebad) then begin
      writeln ('Error found in line ', Line_num, ' of ', Datafile);
      if (Is_surf_cfg) then
        halt(1)
      else begin
        write ('Press any key to continue: ');
        ch := getkey;
      end;
    end; 

  end; { if Filebad }

  if (Is_surf_cfg) and ((Grsys < 0) or (Grmode < 0)) then begin
    writeln ('ERROR: Missing GRSYS or GRMODE in ', Datafile);
    halt(1);
  end;

end; { procedure READCFG }
