
; SWAPSCRN.INC
; JIM TUCKER jtucker@adam.com.au 30 August 1994

; This will swap the 4000 data bytes (a color help screen for example) to
; the screen. Then swap them back. All registers preserved so this can be
; used in a TSR. The cursor is hidden while the data is on the screen.
; Do not allow user display in TSRs as the displayed screen is saved for
; next time.

; USAGE: call	swap_scrn1	;save screen, display data
;        mov	ah,0		;wait for a key
;	 int	16h		;bios 
;        call	swap_scrn2	;swap them back
;	 int	20h		;done

DATA_SEG@	dw	?
VIDEO_SEG@	dw	?
CURPOS@		dw	?

SWAP_SCRN1:	pushall
		mov	ds,cs
		mov	ax,data_buffer@
		shr	ax,4
		mov	cx,cs
		add	ax,cx
		mov	data_seg@,ax

		mov	video_seg@,0B800h	;guess
		mov	ah,0Fh			;get mode
		int	10h
		cmp	al,7			;mono?
		jne	>l1			;no
		mov	video_seg@,0B000h	;bad guess

L1:		mov	ah,03h			;save the curpos
		mov	bh,0
		int	10h
		mov	curpos@,dx

		mov	ah,02h			;move the cursor
		mov	dx,1A00h		;line 26 off the screen
		int	10h

		mov	es,video_seg@
		mov	ds,data_seg@		;establish the segments
		jmp	screen_swap

; Call here to restore the screen

SWAP_SCRN2:	pushall
		mov	ah,02h			;restore the cursor
		mov	dx,cs:curpos@
		mov	bh,0
		int	10h

		mov	ds,cs:video_seg@	;opposite to above
		mov	es,cs:data_seg@		;... and fall thru

; This swaps the screens so we do not need a separate buffer

SCREEN_SWAP:	xor	si,si
		mov	cx,2000			;words to move
L1:		mov	ax,[si]			;get char to display
		xchg	ax,dx			;save it in dx
		mov	ax,es:[si]		;get char from screen
		mov	es:[si],dx		;display the char
		mov	[si],ax			;and save the screen char
		add	si,2
		loop	l1
		popall
		ret				;change to iret for TSR

EVEN 16						;must be segment boundary
DATA_BUFFER@	equ	$			;your data follows this
						;must be 4000 bytes
; END SWAPSCRN.INC
