;
; LSD
;
; Copyright(c) LADsoft
;
; David Lindauer, gclind01@starbase.spd.louisville.edu
;
;
; Dosfiles.asm
;
; Function : provides dos file system usage
; 
;
	;MASM MODE
	.386p

include  os.asi 

include  segs.asi 
include  sys.mac 
include  prints.ase 
include  dispatch.ase 
include	 boot.ase 
include  ints.ase 

pdw	MACRO	reg
	push	eax
	mov	eax,reg
	call	printdword
	call	printspace
	pop	eax
	ENDM	
	PUBLIC	_dosfilehandler
FNAMELEN = 80
FBUFLEN = 256

seg386data	SEGMENT	
filebuf	db	FBUFLEN dup (?)		; Intermediate xfer buffer
namebuf	db	FNAMELEN dup (?)	; File name goes here
	align
bufptr	dd	0			; Pointer to user buffer
bytesmoved dd	0			; Number of bytes we have moved
seg386data	ENDS	


seg386	SEGMENT	
;
; Procedure to copy user filename to system space
;
getfilename	PROC	
	assume	es:dgroup
	assume	ds:nothing
	push	edx			; Save mode

	push	esi			; Save regs used
	push	edi
	push	ecx
	push	es
	mov	cx,DS386		; Destination is here
	mov	es,cx                   ;
	mov  	ecx,FNAMELEN            ; Move enough bytes to fill buffer

	mov	esi,ebx                 ; BX = pointer to filename
	mov	edi,offset dgroup:namebuf	; Get destination
	cld
	rep	movsb			; Move bytes
	DSADR	namebuf,dx		; Return DS<DOS>:DS = name buffer
	pop	es			; Restore regs
	pop	ecx
	pop	edi
	pop	esi
	pop	eax			; Restore mode
	ret
getfilename	ENDP	
;
; Read data from the file
;
readbuf	PROC	
	assume	ds:dgroup
	assume	es:nothing
	push	ebx			; Push handle
	DSADR	filebuf,dx		; Get buffer address
	MSDOS	3fh			; Call DOS to get data
	pop	ebx			; pop handle
	jc	$$enread		; Quit if error
	or	ax,ax			; Quit if no bytes read
	jz	$$enread		;
	movzx	ecx,ax			; Get count to move
	push	ecx
	mov	esi,offset dgroup:filebuf	; Get source = our buffer
	mov	edi,[bufptr]		; Get dest = user buffer
	cld
	rep	movsb			; Move bytes
	pop	ecx
	add	[bytesmoved],ecx	; Increment counter and buf pointer
	add	[bufptr],ecx		;
$$enread:
	ret				; done
readbuf	ENDP	
;
; Write data to a file
;
writebuf	PROC	
	assume	es:dgroup
	assume	ds:nothing
	push	ecx			; Save count
	mov	esi,[bufptr]		; Move from user buffer 
	mov	edi,offset dgroup:filebuf	; To our buffer
	cld
	rep	movsb			;
	pop	ecx                     ; Restore count
	push	ecx
	DSADR	filebuf,dx              ; Get buffer address
	MSDOS	40h			; Call DOS to write
	pop	ecx
	add	[bytesmoved],ecx	; Update position
	add	[bufptr],ecx		;
	ret
writebuf	ENDP	
;
; OS File handling routines
;
	assume	ds:nothing,es:nothing
open	PROC	
	call	getfilename             ; Yes move filename
	MSDOS	3dh			; Call DOS open routine
	ret
open	ENDP	
creat	PROC	
	call	getfilename		; Yes move filename
	MSDOS	3ch			; Call dos CREATE routine
	ret
creat	ENDP	
close	PROC	
	MSDOS	3eh			; Yes - dos close routine
	ret
close	ENDP	
read	PROC	
	push	esi       		; Save regs
	push	edi
	push	es
	push	ds
	push	ds
	pop	es
	assume	ds:dgroup
	assume	es:nothing
	mov	ax,DS386		; DS = OS data
	mov	ds,ax
	mov	[bufptr],edx		; Initialize pointers
	mov	[bytesmoved],0
$$read:
	cmp	ecx,FBUFLEN		; See if more than a buffer
	jbe	short $$doneread	; No -just get the bytes
	push	ecx			; Else push count to get
	mov	ecx,FBUFLEN		; Get a bufferfull
	call	readbuf			;
	pop	ecx			;
	jc	$$dr1                   ; Quit if error
	or	ax,ax                   ; Quit if nothing read
	jz	$$dr1			; 
	sub	ecx,FBUFLEN             ; Else update count for buffer
	jmp	short $$read		; loop
$$doneread:
	jcxz	short $$dr1             ; If no bytes to read skip this
	call	readbuf			; Else read last partially full buffer
$$dr1:
	mov	ecx,[bytesmoved]	; Get total bytes moved for return
	pop	ds			; Pop regs
	pop	es
	pop	edi
	pop	esi
	ret
read	ENDP	
write	PROC	
	push	esi			; Yes - push regs
	push	edi
	push	es
	mov	ax,DS386                ; ES gets OS DATA
	mov	es,ax
	assume	es:dgroup
	assume	ds:nothing
	mov	[bufptr],edx		; Initialize buffer pointer & count
	mov	[bytesmoved],0		;
$$write:
	cmp	ecx,FBUFLEN             ; See if less than a full buffer
	jbe	short $$donewrite	; yes -go do it
	push	ecx			; Else save count
	mov	ecx,FBUFLEN		; Write a buffer full
	call	writebuf		;
	pop	ecx			;
	sub	ecx,FBUFLEN		; Update count
	jmp	short $$write		; Next bufferfull
$$donewrite:
	jcxz	short $$dw1		; See if anything in last block
	call	writebuf                ; Write it if so
$$dw1:
	mov	ecx,[bytesmoved]	; Return bytes written
	pop	es
	pop	edi
	pop	esi
	ret
write	ENDP	
position	PROC	
	push	ecx			; Save cx
	mov	ecx,edx			; calculate pos into cx:dx
	and	edx,0ffffh
	shr	ecx,16
	MSDOS	42h			; Call DOS position command
	shl	edx,16
	and	eax,0ffffh		; translate back to dx
	or	edx,eax                 ;
	pop	ecx
	ret
position	ENDP	
_dosfilehandler	PROC	
	push	0
	call	TableDispatch
	dd	6
	dd	open
	dd	creat
	dd	close
	dd	nofunction
	dd	read
	dd	write
	dd	position
	ret
_dosfilehandler	ENDP	
seg386	ENDS	
END
