;
; LSD os library for use with C compilers
;
; Copyright(c) 1996 LADsoft
;
; David Lindauer, gclind01@starbase.spd.louisville.edu
;
	.386
	MODEL USE32 SMALL

include	lib.asi

	PUBLIC	_OSMakeFS, _OSFlushBuffers, _OSOpenFile,_OSCreateFile
	PUBLIC	_OSCloseFile, _OSDeleteFile, _OSTruncateFile
	PUBLIC	_OSRenameFile, _OSReadFile, _OSWriteFile, _OSFileSetPosition
	PUBLIC	_OSFileGetPosition
	PUBLIC	_OSFilePositionAtEOF, _OSFileSetTime, _OSFileGetTime
	PUBLIC	_OSGetStdHandle, _OSGetHandleType, _OSGetLastError

_TEXT	SEGMENT	
;
;* int OSMakeFS(int drive);
;
noerror:
	sub	eax,eax
	LEAVE
	ret
_OSMakeFS	PROC	
	ARG	DRIVE : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[DRIVE]
	OS	FS_MAKEFS
	pop	ebx
	jnc	short noerror
	LEAVE
	ret
_OSMakeFS	ENDP	
;
;* int OSFlushBuffers(void);
;
_OSFlushBuffers	PROC	
	ENTER	0,0
	OS	FS_FLUSHBUFFERS
	jnc	noerror
	LEAVE
	ret
_OSFlushBuffers	ENDP	
;
;* int OSOpenFile(int drive, char *filename, int *handle);
;
_OSOpenFile	PROC	
	ARG	DRIVE : DWORD, FILENAME : DWORD, HANDLE : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[DRIVE]
	mov	ecx,[FILENAME]
	OS	FS_OPEN
	mov	edx,[HANDLE]
	mov	[EDX],eax
	pop	ebx
	jnc	noerror
	LEAVE
	ret
_OSOpenFile	ENDP	
;
;* int OSCreateFile(int drive, char *filename, int *handle);
;
_OSCreateFile	PROC	
	ARG	DRIVE : DWORD, FILENAME : DWORD, HANDLE : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[DRIVE]
	mov	ecx,[FILENAME]
	OS	FS_CREATE
	mov	ebx,[HANDLE]
	mov	[ebx],eax
	pop	ebx
	jnc	noerror
	LEAVE
	ret
_OSCreateFile	ENDP	
;
;* int OSCloseFile(int handle);
;
_OSCloseFile	PROC	
	ARG	HANDLE : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[HANDLE]
	OS	FS_CLOSE
	pop	ebx
	jnc	noerror
	LEAVE
	ret
_OSCloseFile	ENDP	
;
;* int OSDeleteFile(int drive, char *filename);
;
_OSDeleteFile	PROC	
	ARG	DRIVE : DWORD, FILENAME : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[DRIVE]
	mov	ecx,[FILENAME]
	OS	FS_DELETE
	pop	ebx
	jnc	noerror
	LEAVE
	ret
_OSDeleteFile	ENDP	
;
;* int OSTruncateFile(int handle);
;
_OSTruncateFile	PROC	
	ARG	HANDLE : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[HANDLE]
	OS	FS_TRUNCATE
	pop	ebx
	jnc	noerror
	LEAVE
	ret
_OSTruncateFile	ENDP	
;
;* int OSRenameFile(int drive, char *orig, char*new);
;
_OSRenameFile	PROC	
	ARG	DRIVE : DWORD, ORIG : DWORD, NEW : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[DRIVE]
	mov	ecx,[ORIG]
	mov	edx,[NEW]
	OS	FS_RENAME
	pop	ebx
	jnc	noerror
	LEAVE
	ret
_OSRenameFile	ENDP	
;
;* int OSReadFile(int handle, int size, unsigned char *buffer, int*sizeread);
;
_OSReadFile	PROC	
	ARG	HANDLE : DWORD, BUFSIZE : DWORD, BUFFER : DWORD, SIZEREAD : DWORD
	ENTER	0,0
	push	ebx
	push	esi
	mov	ebx,[HANDLE]
	mov	ecx,[BUFSIZE]
	mov	esi,[BUFFER]
	OS	FS_READ
	mov	ebx,[SIZEREAD]
	mov	[ebx],ecx
	pop	esi
	pop	ebx
	jnc	noerror
	LEAVE
	ret
_OSReadFile	ENDP	
;
;* int OSWriteFile(int handle, int size, unsigned char *buffer, int *sizeread);
;
_OSWriteFile	PROC	
	ARG	HANDLE : DWORD, BUFSIZE : DWORD, BUFFER : DWORD, SIZEREAD : DWORD
	ENTER	0,0
	push	ebx
	push	esi
	mov	ebx,[HANDLE]
	mov	ecx,[BUFSIZE]
	mov	esi,[BUFFER]
	OS	FS_WRITE
	mov	ebx,[SIZEREAD]
	mov	[ebx],ecx
	pop	esi
	pop	ebx
	jnc	noerror
	LEAVE
	ret
_OSWriteFile	ENDP	
;
;* int OSFileSetPosition(int handle, int position, int method);
;
_OSFileSetPosition	PROC	
	ARG	HANDLE : DWORD, POSITION : DWORD, METHOD : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[HANDLE]
	mov	ecx,[METHOD]
	mov	edx,[POSITION]
	OS	FS_SETPOSITION
	pop	ebx
	jnc	noerror
	LEAVE
	ret
_OSFileSetPosition	ENDP	
;
;* int OSFileGetPosition(int handle, int *position);
;
_OSFileGetPosition	PROC	
	ARG	HANDLE : DWORD, POSITION : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[HANDLE]
	OS	FS_GETPOSITION
	mov	ebx,[POSITION]
	mov	[ebx],eax
	pop	ebx
	jnc	noerror
	LEAVE
	ret
_OSFileGetPosition	ENDP	
;
;* int OSFilePositionAtEOF(int handle);
;
_OSFilePositionAtEOF	PROC	
	
	ARG	HANDLE : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[HANDLE]
	OS	FS_POSEOF
	pop	ebx
	jnc	noerror
	LEAVE
	ret
_OSFilePositionAtEOF	ENDP	
;
;* int OSFileSetTime(int handle, int time);
;
_OSFileSetTime	PROC	
	ARG	HANDLE : DWORD, TIME : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[HANDLE]
	mov	edx,[TIME]
	OS	FS_SETIME
	pop	ebx
	jnc	noerror
	LEAVE
	ret
_OSFileSetTime	ENDP	
;
;* int OSFileGetTime(int handle, unsigned *time);
;
_OSFileGetTime	PROC	
	ARG	HANDLE : DWORD, TIME : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[HANDLE]
	OS	FS_GETIME
	mov	ebx,[TIME]
	mov	[ebx],eax
	pop	ebx
	jnc	noerror
	LEAVE
	ret
_OSFileGetTime	ENDP	
;
;* int OSGetStdHandle(int htype);
;
_OSGetStdHandle	PROC	
	ARG	HTYPE : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[HTYPE]
	OS	FS_GETSTDHANDLE
	pop	ebx
	LEAVE
	ret
_OSGetStdHandle	ENDP	
;
;* int OSGetHandleType(int handle);
;
_OSGetHandleType	PROC	
	ARG	HANDLE : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[HANDLE]
	OS	FS_GETHANDLETYPE
	pop	ebx
	LEAVE
	ret
_OSGetHandleType	ENDP	
;
;* int OSGetLastError(void);
;
_OSGetLastError	PROC	
	OS	FS_GETLASTERROR
	ret
_OSGetLastError	ENDP	
_TEXT	ENDS	
END